package com.bitbof.spinGame.worlds;

import java.util.ArrayList;

import org.lwjgl.opengl.GL11;

import com.badlogic.gdx.math.Circle;
import com.badlogic.gdx.math.Intersector;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.bitbof.spinGame.Rythm;
import com.bitbof.spinGame.Settings;
import com.bitbof.spinGame.assets.Art;
import com.bitbof.spinGame.assets.Assets;
import com.bitbof.spinGame.assets.Texture;
import com.bitbof.spinGame.entities.Bond;
import com.bitbof.spinGame.entities.Camera;
import com.bitbof.spinGame.entities.Creature;
import com.bitbof.spinGame.entities.Entity;
import com.bitbof.spinGame.entities.Floor;
import com.bitbof.spinGame.entities.GameLogo;

public class WorldOne extends World{
	public int level = 0;
	public ArrayList<Entity> entities;
	public Bond bond;
	public Rectangle goal;
	public Camera camera;
	public GameLogo logo;
	public int counter = 0;
	public boolean first = true;
	
	public WorldOne() {
		entities = new ArrayList<Entity>();
		initLevel();
	}
	
	public void initLevel() {
		entities.clear();
		bond = new Bond(this);
		camera = new Camera(this);
		Levels.initLevel(level, this);
		if(first) {
			first = false;
			logo = new GameLogo();
			entities.add(logo);
			camera.doCrazyZoom();
		}
	}
	
	@Override
	public void update() {
		
		if(!camera.isZooming()) {
			bond.update();
			if(bond.isDead()) {
				initLevel();
				return;
			}
		
		
			//check if reached goal
			for(int i = 0; i < bond.creatures.size() && !bond.locked; i++) {
				Creature c = bond.creatures.get(i);
				if(Intersector.overlapCircleRectangle(new Circle(new Vector2(c.pos.x, c.pos.y), c.size.x/2f), goal)) {
					level++;
					Assets.goal.play();
					initLevel();
					return;
				}
			}
			
			counter++;
			camera.pos = new Vector2(bond.getCenter()).mul(0.1f).add(new Vector2(camera.pos).mul(0.9f));
		}
		camera.update();
		//logo.pos = new Vector2(camera.pos);
		
		if(!camera.isZooming()) {
			for(int i = 0; i < entities.size(); i++) {
				Entity e = entities.get(i);
				e.update();
				if(e.isDead()) {
					entities.remove(i--);
				}
			}
		}
		
		
	}

	@Override
	public void draw() {
		
		GL11.glPushMatrix();

		GL11.glTranslatef(Settings.width/2f - camera.pos.x*camera.zoom, Settings.height/ 2f - camera.pos.y*camera.zoom, 0);
		GL11.glScalef(camera.zoom, camera.zoom, 1);
		
		
		for(int i = 0; i < 10; i++) {
			float rfac = (float) Math.sin((Rythm.getBeat()+i*4)/20f*Math.PI*0.5f + 0.5f);
			float rfac2 = (float) Math.sin((Rythm.getBeat()+i*4+2)/6f*Math.PI*0.5f + 0.5f);
			GL11.glPushMatrix();
				Texture texture = Art.texture;
				texture.bind();
				GL11.glColor4f(1-rfac,1- rfac2,rfac,0.05f*level/(float)Levels.levelCount);

				GL11.glTranslatef(camera.pos.x, camera.pos.y, 0);

				GL11.glScalef(500 * (rfac), 500*rfac, 1);
				GL11.glRotatef(new Vector2(goal.x+goal.width/2f, goal.y+goal.height/2f).sub(camera.pos).angle(), 0,0,1);

				
			    GL11.glBegin(GL11.GL_QUADS);
					GL11.glTexCoord2f(0, texture.getHeight());
					GL11.glVertex2f(-0.5f, -0.5f);
					GL11.glTexCoord2f(texture.getWidth(), texture.getHeight());
					GL11.glVertex2f(0.5f, -0.5f);
					GL11.glTexCoord2f(texture.getWidth(), 0);
					GL11.glVertex2f(0.5f, 0.5f);
					GL11.glTexCoord2f(0, 0);
					GL11.glVertex2f(-0.5f, 0.5f);
				GL11.glEnd();
			GL11.glPopMatrix();
		}
		for(int i = 0; i < 10; i++) {
			float rfac = (float) Math.sin((Rythm.getBeat()+i*4)/20f*Math.PI*0.5f + 0.5f);
			float rfac2 = (float) Math.sin((Rythm.getBeat()+i*4+2)/6f*Math.PI*0.5f + 0.5f);
			float grow = (Rythm.getBeat()/100f + i/10f)%1;
			GL11.glPushMatrix();
				Texture texture = Art.dirCircle;
				texture.bind();
				float alpha = (1-Math.max(0.9f, grow))*10f;
				GL11.glColor4f(1-rfac,1- rfac2,rfac, alpha*0.05f);

				GL11.glTranslatef(goal.x+goal.width/2f, goal.y+goal.height/2f, 0);

				GL11.glScalef(1000 * grow, 1000*grow, 1);
				GL11.glRotatef(new Vector2(goal.x+goal.width/2f, goal.y+goal.height/2f).sub(camera.pos).angle(), 0,0,1);

				
			    GL11.glBegin(GL11.GL_QUADS);
					GL11.glTexCoord2f(0, texture.getHeight());
					GL11.glVertex2f(-0.5f, -0.5f);
					GL11.glTexCoord2f(texture.getWidth(), texture.getHeight());
					GL11.glVertex2f(0.5f, -0.5f);
					GL11.glTexCoord2f(texture.getWidth(), 0);
					GL11.glVertex2f(0.5f, 0.5f);
					GL11.glTexCoord2f(0, 0);
					GL11.glVertex2f(-0.5f, 0.5f);
				GL11.glEnd();
			GL11.glPopMatrix();
		}
		
		
		for(int i = 0; i < entities.size(); i++) {
			Entity e = entities.get(i);
			e.draw();
		}
		
		bond.draw();
		
		if(level == 0) {
			GL11.glPushMatrix();
			Texture texture = Art.controls_move;
			texture.bind();
			GL11.glColor4f(0.6f-0.3f*((Rythm.getBeat()/2f)%1), 0.6f-0.3f*((Rythm.getBeat()/4f)%1), 0.6f, 1f);

			GL11.glTranslatef(14,-58,0);

			GL11.glScalef(32,32, 1);
		    GL11.glBegin(GL11.GL_QUADS);
				GL11.glTexCoord2f(0, texture.getHeight());
				GL11.glVertex2f(-0.5f, -0.5f);
				GL11.glTexCoord2f(texture.getWidth(), texture.getHeight());
				GL11.glVertex2f(0.5f, -0.5f);
				GL11.glTexCoord2f(texture.getWidth(), 0);
				GL11.glVertex2f(0.5f, 0.5f);
				GL11.glTexCoord2f(0, 0);
				GL11.glVertex2f(-0.5f, 0.5f);
			GL11.glEnd();
		GL11.glPopMatrix();
		}
		if(level == 2) {
			GL11.glPushMatrix();
			Texture texture = Art.controls_spin;
			texture.bind();
			GL11.glColor4f(0.6f-0.3f*((Rythm.getBeat()/2f)%1), 0.6f-0.3f*((Rythm.getBeat()/4f)%1), 0.6f, 1f);

			GL11.glTranslatef(210,-30,0);

			GL11.glScalef(64,32, 1);
		    GL11.glBegin(GL11.GL_QUADS);
				GL11.glTexCoord2f(0, texture.getHeight());
				GL11.glVertex2f(-0.5f, -0.5f);
				GL11.glTexCoord2f(texture.getWidth(), texture.getHeight());
				GL11.glVertex2f(0.5f, -0.5f);
				GL11.glTexCoord2f(texture.getWidth(), 0);
				GL11.glVertex2f(0.5f, 0.5f);
				GL11.glTexCoord2f(0, 0);
				GL11.glVertex2f(-0.5f, 0.5f);
			GL11.glEnd();
		GL11.glPopMatrix();
		}
		
		GL11.glPopMatrix();
		
		if(level == 10) {
			GL11.glPushMatrix();
				Texture texture = Art.end;
				texture.bind();
				GL11.glColor4f(1,1,1,1);
	
				GL11.glTranslatef(Settings.width/2f,Settings.height/2f,0);
	
				GL11.glScalef(512,512, 1);
			    GL11.glBegin(GL11.GL_QUADS);
					GL11.glTexCoord2f(0, texture.getHeight());
					GL11.glVertex2f(-0.5f, -0.5f);
					GL11.glTexCoord2f(texture.getWidth(), texture.getHeight());
					GL11.glVertex2f(0.5f, -0.5f);
					GL11.glTexCoord2f(texture.getWidth(), 0);
					GL11.glVertex2f(0.5f, 0.5f);
					GL11.glTexCoord2f(0, 0);
					GL11.glVertex2f(-0.5f, 0.5f);
				GL11.glEnd();
			GL11.glPopMatrix();
		}
	}

	@Override
	public ArrayList<Entity> getEntities() {
		return entities;
	}

	@Override
	public void addBlock(float x, float y, float w, float h, int type) {
		if(type == World.B_START) {
			if(level == 0) {
				camera.pos.x = x*World.BLOCKSIZE;
				camera.pos.y = y*World.BLOCKSIZE;
			}
			Creature c = new Creature(this);
			c.pos.x = x * World.BLOCKSIZE;
			c.pos.y = y * World.BLOCKSIZE;
			entities.add(c);
			bond = new Bond(this);
			bond.add(c);
			bond.pos = new Vector2(x * World.BLOCKSIZE, y * World.BLOCKSIZE);
		} else 	if(type == World.B_CREATURE) {
			Creature c = new Creature(this);
			c.pos.x = x * World.BLOCKSIZE;
			c.pos.y = y * World.BLOCKSIZE;
			entities.add(c);
		} else 	if(type == World.B_FLOOR) {
			Floor c = new Floor(this);
			c.pos.x = x * World.BLOCKSIZE;
			c.pos.y = y * World.BLOCKSIZE;
			c.size.x = w*World.BLOCKSIZE;
			c.size.y = h*World.BLOCKSIZE;
			entities.add(c);
		} else if(type == World.B_GOAL) {
			goal = new Rectangle(x * World.BLOCKSIZE-World.BLOCKSIZE/2f, y * World.BLOCKSIZE-h * World.BLOCKSIZE+World.BLOCKSIZE/2f, w * World.BLOCKSIZE, h * World.BLOCKSIZE);
		}

	}

}
