package com.bitbof.spinGame.screens;


import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.InputProcessor;
import com.bitbof.spinGame.Settings;
import com.bitbof.spinGame.SpinGame;
import com.bitbof.spinGame.assets.Art;
import com.bitbof.spinGame.assets.Assets;
import com.bitbof.spinGame.assets.Texture;

public class TemplateScreen extends Screen implements InputProcessor {
	
	private float deltaCount = 0;
	public boolean pause = false;
	
	public TemplateScreen(SpinGame templateGame) {
		super(templateGame);
		Gdx.input.setInputProcessor(this);
		initGL();
		Assets.loadAssets();
	}
	
	public void initGL(){
		GL11.glEnable(GL11.GL_TEXTURE_2D);
	    GL11.glEnable(GL11.GL_BLEND);
	    GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
	    GL11.glMatrixMode(GL11.GL_PROJECTION);
	    GL11.glOrtho(0, Settings.width, 0, Settings.height, -1, 1);
	    GL11.glMatrixMode(GL11.GL_MODELVIEW);
	}
	
	@Override
	public void update(float deltaTime) {
		deltaCount += deltaTime;
		if(deltaCount > 0.01) {
			deltaCount = 0;
			logic();
		}
	}
	
	public void logic() {
	}
	
	@Override
	public void present(float deltaTime) {
		if(pause)
			return;
	    GL11.glOrtho(0, Display.getDisplayMode().getWidth(), 0, Display.getDisplayMode().getHeight(), -1, 1);
	    GL11.glLoadIdentity();
	    GL11.glClear(GL11.GL_COLOR_BUFFER_BIT | GL11.GL_STENCIL_BUFFER_BIT);
	    
	    
	    GL11.glPushMatrix();
			Texture texture = Art.texture;
			texture.bind();
			GL11.glColor3f(1, 1,1);
			GL11.glTranslatef(Settings.width/2f, Settings.height/ 2f, 0);
			GL11.glScalef(1024, 768, 1);
			
		    GL11.glBegin(GL11.GL_QUADS);
				GL11.glTexCoord2f(0, texture.getHeight());
				GL11.glVertex2f(-0.5f, -0.5f);
				GL11.glTexCoord2f(texture.getWidth(), texture.getHeight());
				GL11.glVertex2f(0.5f, -0.5f);
				GL11.glTexCoord2f(texture.getWidth(), 0);
				GL11.glVertex2f(0.5f, 0.5f);
				GL11.glTexCoord2f(0, 0);
				GL11.glVertex2f(-0.5f, 0.5f);
			GL11.glEnd();
		GL11.glPopMatrix();
		
	}

	@Override
	public void pause() {

		pause = true;
	}

	@Override
	public void resume() {
	}
	

	@Override
	public void resize(int width, int height) {
		//GL11.glOrtho(0, Display.getDisplayMode().getWidth(), 0, Display.getDisplayMode().getHeight(), -1, 1);
	}
	
	@Override
	public void dispose() {

		GL11.glPopMatrix();
		GL11.glPopMatrix();
		GL11.glPopMatrix();
	}

	@Override
	public boolean keyDown(int keycode) {
		//game.setScreen(new SomeScreen(game));
		Assets.sound.play();
		if(keycode == Input.Keys.ESCAPE) {
			Gdx.app.exit();
		}
		return false;
	}

	@Override
	public boolean keyUp(int keycode) {
		return false;
	}

	@Override
	public boolean keyTyped(char character) {
		return false;
	}

	@Override
	public boolean touchDown(int x, int y, int pointer, int button) {
		return false;
	}

	@Override
	public boolean touchUp(int x, int y, int pointer, int button) {
		return false;
	}

	@Override
	public boolean touchDragged(int x, int y, int pointer) {
		return false;
	}

	@Override
	public boolean touchMoved(int x, int y) {
		return false;
	}

	@Override
	public boolean scrolled(int amount) {
		return false;
	}

}
