package com.bitbof.spinGame.screens;


import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.InputProcessor;
import com.bitbof.spinGame.Settings;
import com.bitbof.spinGame.SpinGame;
import com.bitbof.spinGame.assets.Art;
import com.bitbof.spinGame.assets.Assets;
import com.bitbof.spinGame.assets.Texture;
import com.bitbof.spinGame.worlds.WorldOne;

public class GameScreen extends Screen implements InputProcessor {
	
	private float deltaCount = 0;
	public boolean pause = false;
	public WorldOne world;
	
	public GameScreen(SpinGame templateGame) {
		super(templateGame);
		Gdx.input.setInputProcessor(this);
		world = new WorldOne();
	}
	
	@Override
	public void update(float deltaTime) {
		deltaCount += deltaTime;
		if(deltaCount > 0.01) {
			deltaCount = 0;
			logic();
		}
	}
	
	public void logic() {
		world.update();
	}
	
	@Override
	public void present(float deltaTime) {
		if(pause)
			return;
	    GL11.glOrtho(0, Display.getDisplayMode().getWidth(), 0, Display.getDisplayMode().getHeight(), -1, 1);
	    GL11.glLoadIdentity();
	    GL11.glClear(GL11.GL_COLOR_BUFFER_BIT | GL11.GL_STENCIL_BUFFER_BIT);
	    
	    world.draw();
	    
	}

	@Override
	public void pause() {

		pause = true;
	}

	@Override
	public void resume() {
	}
	

	@Override
	public void resize(int width, int height) {
		//GL11.glOrtho(0, Display.getDisplayMode().getWidth(), 0, Display.getDisplayMode().getHeight(), -1, 1);
	}
	
	@Override
	public void dispose() {

		GL11.glPopMatrix();
		GL11.glPopMatrix();
		GL11.glPopMatrix();
	}

	@Override
	public boolean keyDown(int keycode) {
		//game.setScreen(new SomeScreen(game));
		
		if(keycode == Input.Keys.ESCAPE) {
			Gdx.app.exit();
		}
		return false;
	}

	@Override
	public boolean keyUp(int keycode) {
		return false;
	}

	@Override
	public boolean keyTyped(char character) {
		return false;
	}

	@Override
	public boolean touchDown(int x, int y, int pointer, int button) {
		return false;
	}

	@Override
	public boolean touchUp(int x, int y, int pointer, int button) {
		return false;
	}

	@Override
	public boolean touchDragged(int x, int y, int pointer) {
		return false;
	}

	@Override
	public boolean touchMoved(int x, int y) {
		return false;
	}

	@Override
	public boolean scrolled(int amount) {
		return false;
	}

}
