package com.bitbof.spinGame.entities;

import org.lwjgl.opengl.GL11;

import com.badlogic.gdx.math.Vector2;
import com.bitbof.spinGame.Rythm;
import com.bitbof.spinGame.assets.Art;
import com.bitbof.spinGame.assets.Assets;
import com.bitbof.spinGame.assets.Texture;

public class GameLogo extends Entity{
	
	public Vector2 pos;
	public float scale = 10, spacing = 5;
	public long counter = 0;
	public String text = "nano spin";
	public boolean first = true;
	
	public float motion_in = 100, motion_pause = 50, motion_out = 100;
	
	public GameLogo() {
		counter = 0;
		pos = new Vector2(38,0);
	}
	
	@Override
	public void update() {
		counter++;
		if(first) {
			first = false;
			Assets.music.play();
			Rythm.startTime = System.nanoTime();
		}
		
	}

	@Override
	public void draw() {

		for(int i = 0 ; i < text.length(); i++) {
			GL11.glPushMatrix();
			Texture texture = getTex(text.charAt(i));
			if(texture == null) {
				continue;
			}
			texture.bind();
			
			Vector2 offset = new Vector2(pos.x + i*(spacing+scale), pos.y);
			
			if(counter < motion_in) {
				float norm = counter / motion_in;
				float easeOut = (float) Math.pow(norm-1, 4);
				Vector2 origin = new Vector2(0,0);
				GL11.glColor4f(1f-0.3f*((Rythm.getBeat()/2f)%1), 1f-0.3f*((Rythm.getBeat()/4f)%1), 1f, norm);
				GL11.glTranslatef(offset.x, offset.y+easeOut*10+20, 0);
				GL11.glRotatef(easeOut*180, 0, 0, -1);
				GL11.glTranslatef(0,-20,0);
				GL11.glScalef(scale, scale*2, 1);
				
			} else if(counter < motion_pause + motion_in) {
				
				GL11.glColor4f(1f-0.3f*((Rythm.getBeat()/2f)%1), 1f-0.3f*((Rythm.getBeat()/4f)%1), 1f, 1);
				GL11.glTranslatef(offset.x, offset.y, 0);
				GL11.glScalef(scale, scale*2, 1);
				
			} else if(counter < motion_out + motion_pause + motion_in){
				float norm = (counter- motion_pause - motion_in) / motion_out;
				float easeIn = (float) Math.pow(norm, 4);
				Vector2 origin = new Vector2(0,0);
				GL11.glColor4f(1f-0.3f*((Rythm.getBeat()/2f)%1), 1f-0.3f*((Rythm.getBeat()/4f)%1), 1f, 1-norm);
				GL11.glTranslatef(offset.x, offset.y+easeIn*10-20, 0);
				GL11.glRotatef(easeIn*180, 0, 0, 1);
				GL11.glTranslatef(0,20,0);
				GL11.glScalef(scale, scale*2, 1);
			} else {
				GL11.glPopMatrix();
				return;
			}
			
			
			
			
	
			
		    GL11.glBegin(GL11.GL_QUADS);
				GL11.glTexCoord2f(0, texture.getHeight());
				GL11.glVertex2f(-0.5f, -0.5f);
				GL11.glTexCoord2f(texture.getWidth(), texture.getHeight());
				GL11.glVertex2f(0.5f, -0.5f);
				GL11.glTexCoord2f(texture.getWidth(), 0);
				GL11.glVertex2f(0.5f, 0.5f);
				GL11.glTexCoord2f(0, 0);
				GL11.glVertex2f(-0.5f, 0.5f);
			GL11.glEnd();
			GL11.glPopMatrix();
		}
		
		
		
	}
	
	public Texture getTex(char c) {
		if(c == 'n') {
			return Art.l_n;
		} else if(c == 'a') {
			return Art.l_a;
		} else if(c == 'o') {
			return Art.l_o;
		} else if(c == 's') {
			return Art.l_s;
		} else if(c == 'p') {
			return Art.l_p;
		} else if(c == 'i') {
			return Art.l_i;
		} else if(c== ' ') {
			return null;
		}
		System.out.println("FAILLL");
		return null;
	}
	
	@Override
	public Vector2 getPos() {
		return null;
		
	}

	@Override
	public boolean isDead() {
		
		
		
		return counter > (motion_in + motion_pause + motion_out);
	}

}
