package com.bitbof.spinGame.entities;

import org.lwjgl.opengl.GL11;

import com.badlogic.gdx.math.Vector2;
import com.bitbof.spinGame.Rythm;
import com.bitbof.spinGame.assets.Art;
import com.bitbof.spinGame.assets.Texture;
import com.bitbof.spinGame.worlds.World;

public class Floor extends Entity{
	
	public Vector2 size, pos;
	public World world;
	
	public Floor(World w) {
		world = w;
		size = new Vector2(10, 10);
		pos = new Vector2(0, 0);
	}
	
	
	@Override
	public void update() {
		
	}

	@Override
	public void draw() {
		GL11.glPushMatrix();
			//Texture texture = Art.floor;
			//texture.bind();
			GL11.glDisable(GL11.GL_TEXTURE_2D);
			GL11.glColor4f(0.6f-0.3f*((Rythm.getBeat()/2f)%1), 0.6f-0.3f*((Rythm.getBeat()/4f)%1), 0.6f, 1f);
			GL11.glTranslatef(pos.x+size.x/2f-World.BLOCKSIZE/2f, pos.y-size.y/2 + World.BLOCKSIZE/2f, 0);
			//GL11.glTranslatef(-size.x/2f, -size.y/2f, 1);
			//GL11.glTranslatef(size.x/2f, -size.y/2f, 0);
			GL11.glScalef(size.x, size.y, 1);
			
			
		    GL11.glBegin(GL11.GL_QUADS);
				//GL11.glTexCoord2f(0, texture.getHeight());
				GL11.glVertex2f(-0.5f, -0.5f);
				//GL11.glTexCoord2f(texture.getWidth(), texture.getHeight());
				GL11.glVertex2f(0.5f, -0.5f);
				//GL11.glTexCoord2f(texture.getWidth(), 0);
				GL11.glVertex2f(0.5f, 0.5f);
				//GL11.glTexCoord2f(0, 0);
				GL11.glVertex2f(-0.5f, 0.5f);
			GL11.glEnd();
			GL11.glEnable(GL11.GL_TEXTURE_2D);
		GL11.glPopMatrix();
	}

	@Override
	public Vector2 getPos() {
		return null;
	}

	@Override
	public boolean isDead() {
		return false;
	}

}
