package com.bitbof.spinGame.entities;

import org.lwjgl.opengl.GL11;

import com.badlogic.gdx.math.Vector2;
import com.bitbof.spinGame.assets.Art;
import com.bitbof.spinGame.assets.Texture;
import com.bitbof.spinGame.worlds.World;

public class DeathEffect extends Entity{
	
	public Vector2 size, pos, v, a;
	public float height, radius;
	public boolean alive;
	public World world;
	public long counter = 0;
	public float rand;
	
	public DeathEffect(World w) {
		world = w;
		size = new Vector2(10, 10);
		pos = new Vector2((float)Math.random()*120f-20f, (float)Math.random()*-120f+20f);
		v = new Vector2(0,0);
		a = new Vector2(0,0);
		alive = true;
		radius = 5;
		rand = (float) Math.random()*2f-1f;
	}
	
	@Override
	public void update() {
		
		counter++;
		if(counter > 15) {
			alive = false;
		}
	}

	@Override
	public void draw() {
		GL11.glPushMatrix();
			float facA = 0;
			Texture texture = Art.deathA;
			texture.bind();
			GL11.glColor4f(1, 1, 1, 1 - (counter/15f));

			GL11.glTranslatef(pos.x, pos.y, 0);

			GL11.glScalef(size.x * (1-facA*0.3f), size.y * (1-facA*0.3f), 1);
			GL11.glRotatef(rand*1000 + (float) Math.sin(counter/15f*2*(-rand)*Math.PI), 0, 0, 1);
			
			
		    GL11.glBegin(GL11.GL_QUADS);
				GL11.glTexCoord2f(0, texture.getHeight());
				GL11.glVertex2f(-0.5f, -0.5f);
				GL11.glTexCoord2f(texture.getWidth(), texture.getHeight());
				GL11.glVertex2f(0.5f, -0.5f);
				GL11.glTexCoord2f(texture.getWidth(), 0);
				GL11.glVertex2f(0.5f, 0.5f);
				GL11.glTexCoord2f(0, 0);
				GL11.glVertex2f(-0.5f, 0.5f);
			GL11.glEnd();
		GL11.glPopMatrix();
		
		GL11.glPushMatrix();
		
		texture = Art.deathB;
		texture.bind();
		GL11.glColor4f(1, 1, 1, 1 - (counter/15f));

		GL11.glTranslatef((float) (pos.x+Math.sin(counter/14f*2*Math.PI)), pos.y, 0);

		GL11.glScalef(size.x * (1-facA*0.3f), size.y * (1-facA*0.3f), 1);
		GL11.glRotatef(rand*1000 + (float) -Math.sin(counter/14f*rand*Math.PI), 0, 0, 1);
		
		
	    GL11.glBegin(GL11.GL_QUADS);
			GL11.glTexCoord2f(0, texture.getHeight());
			GL11.glVertex2f(-0.5f, -0.5f);
			GL11.glTexCoord2f(texture.getWidth(), texture.getHeight());
			GL11.glVertex2f(0.5f, -0.5f);
			GL11.glTexCoord2f(texture.getWidth(), 0);
			GL11.glVertex2f(0.5f, 0.5f);
			GL11.glTexCoord2f(0, 0);
			GL11.glVertex2f(-0.5f, 0.5f);
		GL11.glEnd();
	GL11.glPopMatrix();
		
	}

	@Override
	public Vector2 getPos() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public boolean isDead() {
		// TODO Auto-generated method stub
		return !alive;
	}

}
