package com.bitbof.spinGame.entities;

import java.util.ArrayList;

import org.lwjgl.opengl.GL11;

import com.badlogic.gdx.math.Circle;
import com.badlogic.gdx.math.Intersector;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.bitbof.spinGame.Rythm;
import com.bitbof.spinGame.assets.Art;
import com.bitbof.spinGame.assets.Texture;
import com.bitbof.spinGame.worlds.World;

public class Creature extends Entity{

	public Vector2 size, pos, v, a;
	public float height, radius;
	public boolean alive;
	public World world;
	public boolean bonded, locked;
	public long lockedCounter;
	public boolean touching = false;
	public float offset;
	
	public Creature(World w) {
		world = w;
		size = new Vector2(10, 10);
		pos = new Vector2((float)Math.random()*120f-20f, (float)Math.random()*-120f+20f);
		v = new Vector2(0,0);
		a = new Vector2(0,0);
		alive = true;
		radius = 5;
		bonded = false;
		touching = true;
		offset = (float) Math.random();
	}
	
	
	@Override
	public void update() {
		//a.x += (Math.random() - 0.5f) * 0.5f;
		//a.y += (Math.random() - 0.5f) * 0.5f;
		a = a.mul(0.6f);
		v = v.add(a).mul(0.95f);
		pos = pos.add(v);
		if(locked) {
			lockedCounter++;
		} else {
			lockedCounter = Math.max(0, Math.min(lockedCounter - 1, 10));
		}
		
		//check collision
		touching = false;
		if(true){//bonded) {
			ArrayList<Entity> entities = world.getEntities();
			for(int e = 0 ; e < entities.size(); e++) {
				if(entities.get(e) instanceof Floor) {
					Floor c = (Floor)entities.get(e);
					if(Intersector.overlapCircleRectangle(new Circle(new Vector2(pos.x, pos.y), 0.0001f),
							new Rectangle(c.pos.x-World.BLOCKSIZE/2f, c.pos.y-c.size.y+World.BLOCKSIZE/2f, c.size.x, c.size.y))) {
						touching = true;
						break;
					}
				}
			}
		}
		
	}

	@Override
	public void draw() {
		//if(locked) {
			float facA = Math.min(lockedCounter/5f, 1);
			float rFac = (float) (1 - 0.1f *(Math.sin(Rythm.getBeat()*Math.PI)*0.5f + 0.5f));
			float rpx = (float) Math.sin(Rythm.getBeat()+offset*100*Math.PI);
			float rpy = (float) Math.cos(Rythm.getBeat()+offset*100*Math.PI);
			GL11.glPushMatrix();
				Texture texture = Art.texture;
				texture.bind();
				GL11.glColor3f(1, 1,1);
				if(!touching) {
					GL11.glColor4f(1, 1,1, 0.4f);
				}
				GL11.glTranslatef(pos.x, pos.y, 0);
				if(!bonded) {
					GL11.glTranslatef(rpx, rpy, 0);
				}
				GL11.glScalef(size.x * (1-facA*0.3f), size.y * (1-facA*0.3f), 1);
				if(!bonded) {
					GL11.glScalef(rFac,rFac,0);
				}
				
			    GL11.glBegin(GL11.GL_QUADS);
					GL11.glTexCoord2f(0, texture.getHeight());
					GL11.glVertex2f(-0.5f, -0.5f);
					GL11.glTexCoord2f(texture.getWidth(), texture.getHeight());
					GL11.glVertex2f(0.5f, -0.5f);
					GL11.glTexCoord2f(texture.getWidth(), 0);
					GL11.glVertex2f(0.5f, 0.5f);
					GL11.glTexCoord2f(0, 0);
					GL11.glVertex2f(-0.5f, 0.5f);
				GL11.glEnd();
			GL11.glPopMatrix();
			
			float facB = Math.max(0, Math.min(1, (lockedCounter - 5)/3f));
			if(facB > 0) {
				GL11.glPushMatrix();
				texture = Art.texture;
				texture.bind();
				GL11.glColor4f(0.6f-0.3f*((Rythm.getBeat()/2f)%1), 0.6f-0.3f*((Rythm.getBeat()/4f)%1), 0.6f, 1f);
				GL11.glTranslatef(pos.x, pos.y, 0);
				GL11.glScalef(size.x * (facB*0.5f), size.y * (facB*0.5f), 1);
				
			    GL11.glBegin(GL11.GL_QUADS);
					GL11.glTexCoord2f(0, texture.getHeight());
					GL11.glVertex2f(-0.5f, -0.5f);
					GL11.glTexCoord2f(texture.getWidth(), texture.getHeight());
					GL11.glVertex2f(0.5f, -0.5f);
					GL11.glTexCoord2f(texture.getWidth(), 0);
					GL11.glVertex2f(0.5f, 0.5f);
					GL11.glTexCoord2f(0, 0);
					GL11.glVertex2f(-0.5f, 0.5f);
				GL11.glEnd();
				GL11.glPopMatrix();
			}
			
		/*} else {
			GL11.glPushMatrix();
				Texture texture = Art.texture;
				texture.bind();
				GL11.glColor3f(1, 1,1);
				GL11.glTranslatef(pos.x, pos.y, 0);
				GL11.glScalef(size.x, size.y, 1);
				
			    GL11.glBegin(GL11.GL_QUADS);
					GL11.glTexCoord2f(0, texture.getHeight());
					GL11.glVertex2f(-0.5f, -0.5f);
					GL11.glTexCoord2f(texture.getWidth(), texture.getHeight());
					GL11.glVertex2f(0.5f, -0.5f);
					GL11.glTexCoord2f(texture.getWidth(), 0);
					GL11.glVertex2f(0.5f, 0.5f);
					GL11.glTexCoord2f(0, 0);
					GL11.glVertex2f(-0.5f, 0.5f);
				GL11.glEnd();
			GL11.glPopMatrix();
		}*/
		
	}

	@Override
	public Vector2 getPos() {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	public boolean isDead() {
		return !alive;
	}
	
	public void goThere(Vector2 p) {
		
		Vector2 dir = new Vector2(p).sub(pos);
		float origSpeed = dir.len();
		Vector2 dirNor = new Vector2(dir).mul(1.0f / dir.len());
		float speed = Math.min(origSpeed, 4f);
		if(speed > 0) {
			v = v.mul(0.5f).add(new Vector2(dirNor).mul(speed*0.5f));
		}
		
	}
	
	public void lock(boolean b) {
		locked = b;
	}

}
