package com.bitbof.spinGame.entities;

import com.badlogic.gdx.math.*;
import com.bitbof.spinGame.assets.Assets;
import com.bitbof.spinGame.worlds.World;

public class Camera extends Entity{
	
	public Vector2 pos, v, a;
	public float zoom;
	public World world;
	public long counter = 0;
	public boolean crazyZoom = false;
	
	public Camera(World w) {
		world = w;
		pos = new Vector2(0,0);
		v = new Vector2(0,0);
		a = new Vector2(0,0);
		zoom = 3.3f;
	}
	
	@Override
	public void update() {
		a = a.mul(0.6f);
		v = v.add(a).mul(0.95f);
		pos = pos.add(v);
		
		if(crazyZoom) {
			counter++;
			//0.01 -> 3.3 in 200
			float norm = Math.min(250, counter)/250f;
			float easeIn = (float) Math.pow(Math.sin(norm*Math.PI/2f), 10);
			zoom = (float) (easeIn*(3.3 - 0.00005) + 0.00005);
		}
		if(counter > 320) {
			crazyZoom = false;
		}
	}
	
	@Override
	public void draw() {
		//shouldn't really draw
	}

	@Override
	public Vector2 getPos() {
		return null;
	}

	@Override
	public boolean isDead() {
		return false;
	}
	
	public boolean isZooming() {
		return crazyZoom;
	}
	
	public void doCrazyZoom() {
		counter = 0;
		zoom = 0.00005f;
		crazyZoom = true;
		Assets.zoom.play();
	}

}
