package com.bitbof.spinGame.entities;

import java.util.ArrayList;
import java.util.List;

import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

import com.badlogic.gdx.math.Vector2;
import com.bitbof.spinGame.assets.Art;
import com.bitbof.spinGame.assets.Assets;
import com.bitbof.spinGame.assets.Texture;
import com.bitbof.spinGame.worlds.World;

public class Bond extends Entity{
	
	public World world;
	public ArrayList<Creature> creatures;
	public int leader;
	public boolean locked;
	public float angle, rv; //rv - rotational speed
	public Vector2 pos, v, a;
	public boolean kDown = false;
	public boolean alive = false;
	
	
	public Bond(World w) {
		creatures = new ArrayList<Creature>();
		locked = false;
		angle = 0;
		world = w;
		pos = new Vector2(0,0);
		v = new Vector2(0,0);
		a = new Vector2(0,0);
		alive = true;
		leader = 0;
	}
	
	public Creature getLeader() {
		if(leader == 0) {
			return creatures.get(0);
		}
		return creatures.get(creatures.size()-1);
	}
	
	@Override
	public void update() {
		if(creatures.size() == 0) {
			alive = false;
			return;
		}
		
		if ( Keyboard.isKeyDown(Keyboard.KEY_SPACE) || Math.abs(rv) > 0.2f){
			if(!locked){
				locked = true;
				Assets.lock.play();
				//Assets.sound.play();
				getLeader().lock(true);
				rv = 0;
				angle = new Vector2(creatures.get(0).pos).sub(new Vector2(creatures.get(creatures.size()-1).pos)).angle();
				if(leader != 0) {
					angle = new Vector2(creatures.get(creatures.size()-1).pos).sub(new Vector2(creatures.get(0).pos)).angle();
				}
				v.mul(0);
				a.mul(0);
				angle += 180;
				angle %= 360;
			}
			
			Vector2 input = new Vector2(0, 0);
			if(Keyboard.isKeyDown(Keyboard.KEY_UP)) {
				input.y += 0.1;
			}
			if(Keyboard.isKeyDown(Keyboard.KEY_DOWN)) {
				input.y -= 0.1;
			}
			if(Keyboard.isKeyDown(Keyboard.KEY_LEFT)) {
				input.x -= 0.1;
			}
			if(Keyboard.isKeyDown(Keyboard.KEY_RIGHT)) {
				input.x += 0.1;
			}
			if(input.len() > 0) {
				rv = angleDir(angle, input.angle())*0.1f;
			}
			
			//if(Keyboard.isKeyDown(Keyboard.KEY_UP)) {
			//	rv = Math.min(4, rv + 4f/(float)creatures.size());
			//}
			angle += rv;
			angle %= 360;
			rv *= 0.6f;
			Vector2 p1, p2;
			
			if(leader == 0) {
				Creature c = creatures.get(0);
				c.v = c.v.mul(0);
				c = creatures.get(creatures.size()-1);
				
				float radius = (creatures.size()-1)*10;
				Vector2 newPos = new Vector2((float)Math.cos(angle/180.0f*Math.PI), (float)Math.sin(angle/180.0f*Math.PI));
				newPos.mul(radius);
				newPos.add(pos);
				c.pos = newPos;
				
				p1 = new Vector2(pos);
				p2 = new Vector2(creatures.get(creatures.size()-1).pos);
				
			} else {
				Creature c = creatures.get(creatures.size()-1);
				c.v = c.v.mul(0);
				c = creatures.get(0);
				
				float radius = (creatures.size()-1)*10;
				Vector2 newPos = new Vector2((float)Math.cos(angle/180.0f*Math.PI), (float)Math.sin(angle/180.0f*Math.PI));
				newPos.mul(radius);
				newPos.add(pos);
				c.pos = newPos;
				
				p2 = new Vector2(creatures.get(0).pos);
				p1 = new Vector2(creatures.get(creatures.size()-1).pos);
			}
			
			for(int i = 1 ; i < creatures.size() - 1; i++) {
				Creature c = creatures.get(i);
				float fac = i/((float)creatures.size()-1);
				if(leader == 0) {
					c.pos = ( new Vector2(p1).mul(1-fac).add(new Vector2(p2).mul(fac)) );
				} else {
					c.pos = ( new Vector2(p1).mul(fac).add(new Vector2(p2).mul(1-fac)) );
				}
			}
			
		} else {
			if(locked){
				locked = false;
				getLeader().lock(false);
				rv = 0;
				toggleLeader();
				Assets.unlock.play();
			}
			
			//check if some died
			//cheap solution atm
			//if(leader == 0) {
				boolean skipped = false;
				for(int i = 0; i < creatures.size(); i++) {
					Creature c = creatures.get(i);
					if(!c.touching) {
						DeathEffect eff = new DeathEffect(world);
						eff.pos = new Vector2(c.pos);
						creatures.remove(i--);
						c.alive = false;
						Assets.playDeath();
						world.getEntities().add(eff);
					}
				}
			//}
			if(creatures.size() == 0) {
				alive = false;
				return;
			}
				
				
			Vector2 input = new Vector2(0, 0);
			if(Keyboard.isKeyDown(Keyboard.KEY_UP)) {
				input.y += 0.1;
			}
			if(Keyboard.isKeyDown(Keyboard.KEY_DOWN)) {
				input.y -= 0.1;
			}
			if(Keyboard.isKeyDown(Keyboard.KEY_LEFT)) {
				input.x -= 0.1;
			}
			if(Keyboard.isKeyDown(Keyboard.KEY_RIGHT)) {
				input.x += 0.1;
			}
			input.mul(0.5f);
			//taking a look at where it's going...check if leader should change
			float bondAngle = new Vector2(creatures.get(0).pos).sub(new Vector2(creatures.get(creatures.size()-1).pos)).angle();
			if(leader != 0) {
				bondAngle = new Vector2(creatures.get(creatures.size()-1).pos).sub(new Vector2(creatures.get(0).pos)).angle();
			}
			float inAngle = input.angle();
			if(input.len() > 0 && angleDifference(inAngle, bondAngle) > 130) {
				toggleLeader();
			}
			
			
			a = a.add(input);
			
			if(Keyboard.isKeyDown(Keyboard.KEY_0)) {
				if(!kDown) {
					kDown = true;
					if(leader == 0) {
						leader = 1;
						Creature c = creatures.get(creatures.size()-1);
						pos = new Vector2(c.pos);
					} else {
						leader = 0;
						Creature c = creatures.get(0);
						pos = new Vector2(c.pos);
					}
				}
			} else {
				kDown = false;
			}
			
			a = a.mul(0.9f);
			v = v.add(a).mul(0.8f);
			
			
			Vector2 dir, p1, p2;
			
			
			if(leader == 0) {
				pos = pos.add(v);
				Creature c = creatures.get(0);
				c.goThere(new Vector2(pos));
				pos = new Vector2(c.pos);
				c = creatures.get(creatures.size()-1);
				
				
				float radius = (creatures.size()-1)*10;
				dir = new Vector2(pos).sub(c.pos);
				dir.mul(-radius / dir.len());
				Vector2 newPos = new Vector2(pos).add(dir);
				c.goThere(newPos);
				
				p1 = new Vector2(pos);
				p2 = new Vector2(creatures.get(creatures.size()-1).pos);
				
			} else {
				Creature c = creatures.get(creatures.size()-1);
				pos = pos.add(v);
				c.goThere(new Vector2(pos));
				pos = new Vector2(c.pos);
				
				c = creatures.get(0);
				
				
				float radius = (creatures.size()-1)*10;
				dir = new Vector2(pos).sub(c.pos);
				dir.mul(-radius / dir.len());
				Vector2 newPos = new Vector2(pos).add(dir);
				c.goThere(newPos);
				
				p2 = new Vector2(creatures.get(0).pos);
				p1 = new Vector2(creatures.get(creatures.size()-1).pos);
			}
			
			for(int i = 1 ; i < creatures.size() - 1; i++) {
				Creature c = creatures.get(i);
				float fac = i/((float)creatures.size()-1);
				if(leader == 0) {
					c.goThere( new Vector2(p1).mul(1-fac).add(new Vector2(p2).mul(fac)) );
				} else {
					c.goThere( new Vector2(p1).mul(fac).add(new Vector2(p2).mul(1-fac)) );
				}
			}
			
			checkPickup();
			
			//if a creature touches one of the bond -> add to bond, unless already in bond
		}
	}

	@Override
	public void draw() {
		if(true)
			return;
		GL11.glPushMatrix();
			Texture texture = Art.texture;
			texture.bind();
			GL11.glColor3f(1, 0, 0);
			GL11.glTranslatef(pos.x, pos.y, 0);
			GL11.glScalef(2, 2, 1);
			
		    GL11.glBegin(GL11.GL_QUADS);
				GL11.glTexCoord2f(0, texture.getHeight());
				GL11.glVertex2f(-0.5f, -0.5f);
				GL11.glTexCoord2f(texture.getWidth(), texture.getHeight());
				GL11.glVertex2f(0.5f, -0.5f);
				GL11.glTexCoord2f(texture.getWidth(), 0);
				GL11.glVertex2f(0.5f, 0.5f);
				GL11.glTexCoord2f(0, 0);
				GL11.glVertex2f(-0.5f, 0.5f);
			GL11.glEnd();
		GL11.glPopMatrix();
	}

	@Override
	public Vector2 getPos() {
		return null;
	}

	@Override
	public boolean isDead() {
		return !alive;
	}
	
	public Vector2 getCenter() {
		if(!alive) {
			return new Vector2(pos);
		}
		return new Vector2(creatures.get(0).pos).mul(0.5f).add(new Vector2(creatures.get(creatures.size()-1).pos).mul(0.5f));
	}
	
	public float angleDifference(float a1, float a2) {
		float dif = (float)Math.abs(a1 - a2) % 360;

		if (dif > 180)
		    dif = 360 - dif;
		return dif;
	}
	public float angleDir(float a1, float a2) {
		while(a1 < 0) {
			a1 += 360;
		}
		while(a2 < 0) {
			a2 += 360;
		}
		a1 %= 360;
		a2 %= 360;
		float result = a2 - a1;
		if (result < -180) {
			result += 360;
		}
		if (result > 180) {
			result -= 360;
		}
		return result;
	}
	
	public void toggleLeader() {
		if(leader == 0) {
			leader = 1;
			Creature c = creatures.get(creatures.size()-1);
			pos = new Vector2(c.pos);
			v = new Vector2(c.v);
		} else {
			leader = 0;
			Creature c = creatures.get(0);
			pos = new Vector2(c.pos);
			v = new Vector2(c.v);
		}
	}
	
	//see if new creatures can be added
	public void checkPickup() {
		ArrayList<Entity> entities = world.getEntities();
		for(int i = 0 ; i < creatures.size(); i++) {
			for(int e = 0 ; e < entities.size(); e++) {
				if(entities.get(e) instanceof Creature) {
					Creature c = (Creature)entities.get(e);
					if(!c.bonded) {
						float dist = c.pos.dst(creatures.get(i).pos);
						if(dist < c.radius * 2) {
							creatures.add(i, c);
							c.bonded = true;
							Assets.collect.play();
							
						}
					}
				}
			}
		}
	}
	
	public void add(Creature cr) {
		if(cr.bonded) {
			return;
		}
		creatures.add(cr);
		cr.bonded = true;
	}

}
