package com.bitbof.spinGame.assets;


import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.audio.Sound;
import com.bitbof.spinGame.Rythm;

public class Assets {
	
	private static boolean done = false;
	public static Music music;
	public static Sound sound, death, collect, lock, unlock, goal, zoom;
	public static long lastDeath;
	
	public static void loadAssets() {
		if(done)
			return;
		Art.init();
		done = true;
		music = Gdx.app.getAudio().newMusic(Gdx.files.internal("music.mp3"));
		sound = Gdx.app.getAudio().newSound(Gdx.files.internal("sound.mp3"));
		death = Gdx.app.getAudio().newSound(Gdx.files.internal("death.wav"));
		collect = Gdx.app.getAudio().newSound(Gdx.files.internal("collect.wav"));
		lock = Gdx.app.getAudio().newSound(Gdx.files.internal("lock.wav"));
		unlock = Gdx.app.getAudio().newSound(Gdx.files.internal("unlock.wav"));
		zoom = Gdx.app.getAudio().newSound(Gdx.files.internal("zoom.wav"));
		goal = Gdx.app.getAudio().newSound(Gdx.files.internal("goal.wav"));
		music.setLooping(true);
		Rythm.bpm = 104;
	}
	
	public static void playDeath() {
		long delta = System.currentTimeMillis()-lastDeath;
		if(delta < 100) {
			return;
		}
		death.play();
		lastDeath = System.currentTimeMillis();
	}
}