package com.bitbof.spinGame.assets;

import java.io.IOException;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.ImageIcon;

public class Art {
	private static TextureLoader texLoader = new TextureLoader();
	public static Texture texture, floor, intro, glow, dirCircle, deathA, deathB, controls_move, controls_spin,
				l_n, l_a, l_o, l_s, l_p, l_i, bitbofA, bitbofB, end;
	public static Texture[] faces = new Texture[6];
	public static void init() {
		try {
			
			texture = texLoader.getTexture("texture.png");
			intro = texLoader.getTexture("intro.png");
			floor = texLoader.getTexture("floor.png");
			glow = texLoader.getTexture("glow.png");
			dirCircle = texLoader.getTexture("dirCircle.png");
			deathA = texLoader.getTexture("deathA.png");
			deathB = texLoader.getTexture("deathB.png");
			l_n = texLoader.getTexture("l_n.png");
			l_a = texLoader.getTexture("l_a.png");
			l_o = texLoader.getTexture("l_o.png");
			l_s = texLoader.getTexture("l_s.png");
			l_p = texLoader.getTexture("l_p.png");
			l_i = texLoader.getTexture("l_i.png");
			controls_move = texLoader.getTexture("controls_move.png");
			controls_spin = texLoader.getTexture("controls_spin.png");
			bitbofA = texLoader.getTexture("bitbofA.png");
			bitbofB = texLoader.getTexture("bitbofB.png");
			end = texLoader.getTexture("end.png");
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	public static BufferedImage loadImageFile(String fname) {
		if(fname == null)
			return null;
		URL url = TextureLoader.class.getClassLoader().getResource(fname);
		Image img = null;
		try{
			img = new ImageIcon(url).getImage();
		} catch(Exception e) {
			return null;
		}
		if(img == null)
			return null;
		BufferedImage bufferedImage = new BufferedImage(img.getWidth(null), img.getHeight(null), BufferedImage.TYPE_INT_ARGB);
        Graphics g = bufferedImage.getGraphics();
        g.drawImage(img, 0, 0, null);
        g.dispose();
        
        return bufferedImage;
	}
	
}
