package com.bitbof.spinGame;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.FPSLogger;
import com.bitbof.spinGame.screens.Screen;

public abstract class Game implements ApplicationListener {

	Screen screen;
	FPSLogger fpsLogger;
	
	public void setScreen(Screen screen)
	{
		this.screen.pause();
		this.screen.dispose();
		this.screen = screen;
	}
	
	public abstract Screen getStartScreen();
	
	@Override
	public void create() {
		screen = getStartScreen();
		if(Settings.showFps)
			fpsLogger = new FPSLogger();
	}
	
	@Override
	public void render() {
		screen.update(Gdx.graphics.getDeltaTime());
		screen.present(Gdx.graphics.getDeltaTime());
		if(fpsLogger != null)
			fpsLogger.log();
	}
	
	@Override
	public void resume() {
		screen.resume();
	}
	
	@Override
	public void pause() {
		screen.pause();
	}
	
	@Override
	public void resize(int width, int height) {
		screen.resize(width, height);
	}
	
	@Override
	public void dispose() {
		screen.dispose();
	}
}
