/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.openal;

import com.badlogic.gdx.backends.openal.OpenALAudio;
import com.badlogic.gdx.backends.openal.OpenALMusic;
import com.badlogic.gdx.backends.openal.OpenALSound;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;

public class Wav {

    private static class WavInputStream
    extends FilterInputStream {
        int channels;
        int sampleRate;
        int dataRemaining;

        WavInputStream(FileHandle file) {
            super(file.read());
            try {
                if (this.read() != 82 || this.read() != 73 || this.read() != 70 || this.read() != 70) {
                    throw new GdxRuntimeException("RIFF header not found: " + file);
                }
                this.skip(4L);
                if (this.read() != 87 || this.read() != 65 || this.read() != 86 || this.read() != 69) {
                    throw new GdxRuntimeException("Invalid wave file header: " + file);
                }
                if (this.read() != 102 || this.read() != 109 || this.read() != 116 || this.read() != 32) {
                    throw new GdxRuntimeException("fmt header not found: " + file);
                }
                int waveChunkLength = this.read() & 0xFF | (this.read() & 0xFF) << 8 | (this.read() & 0xFF) << 16 | (this.read() & 0xFF) << 24;
                int type = this.read() & 0xFF | (this.read() & 0xFF) << 8;
                if (type != 1) {
                    throw new GdxRuntimeException("WAV files must be PCM: " + type);
                }
                this.channels = this.read() & 0xFF | (this.read() & 0xFF) << 8;
                if (this.channels != 1 && this.channels != 2) {
                    throw new GdxRuntimeException("WAV files must have 1 or 2 channels: " + this.channels);
                }
                this.sampleRate = this.read() & 0xFF | (this.read() & 0xFF) << 8 | (this.read() & 0xFF) << 16 | (this.read() & 0xFF) << 24;
                this.skip(6L);
                int bitsPerSample = this.read() & 0xFF | (this.read() & 0xFF) << 8;
                if (bitsPerSample != 16) {
                    throw new GdxRuntimeException("WAV files must have 16 bits per sample: " + bitsPerSample);
                }
                this.skip(waveChunkLength - 16);
                if (this.read() != 100 || this.read() != 97 || this.read() != 116 || this.read() != 97) {
                    throw new GdxRuntimeException("data header not found: " + file);
                }
                this.dataRemaining = this.read() & 0xFF | (this.read() & 0xFF) << 8 | (this.read() & 0xFF) << 16 | (this.read() & 0xFF) << 24;
            }
            catch (Throwable ex) {
                try {
                    this.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new GdxRuntimeException("Error reading WAV file: " + file, ex);
            }
        }

        public int readData(byte[] buffer) throws IOException {
            if (this.dataRemaining == 0) {
                return -1;
            }
            int length = Math.min(this.read(buffer), this.dataRemaining);
            if (length == -1) {
                return -1;
            }
            this.dataRemaining -= length;
            return length;
        }
    }

    public static class Sound
    extends OpenALSound {
        public Sound(OpenALAudio audio, FileHandle file) {
            super(audio);
            WavInputStream input = new WavInputStream(file);
            ByteArrayOutputStream output = new ByteArrayOutputStream(4096);
            try {
                int length;
                byte[] buffer = new byte[2048];
                while ((length = input.readData(buffer)) != -1) {
                    output.write(buffer, 0, length);
                }
            }
            catch (IOException ex) {
                throw new GdxRuntimeException("Error reading WAV file: " + file, (Throwable)ex);
            }
            this.setup(output.toByteArray(), input.channels, input.sampleRate);
        }
    }

    public static class Music
    extends OpenALMusic {
        private WavInputStream input;

        public Music(OpenALAudio audio, FileHandle file) {
            super(audio, file);
            this.input = new WavInputStream(file);
            this.setup(this.input.channels, this.input.sampleRate);
        }

        @Override
        protected int read(byte[] buffer) {
            if (this.input == null) {
                this.input = new WavInputStream(this.file);
                this.setup(this.input.channels, this.input.sampleRate);
            }
            try {
                return this.input.readData(buffer);
            }
            catch (IOException ex) {
                throw new GdxRuntimeException("Error reading WAV file: " + this.file, (Throwable)ex);
            }
        }

        @Override
        protected void reset() {
            if (this.input == null) {
                return;
            }
            try {
                this.input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.input = null;
        }
    }
}

