/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.openal;

import com.badlogic.gdx.Audio;
import com.badlogic.gdx.audio.AudioDevice;
import com.badlogic.gdx.audio.AudioRecorder;
import com.badlogic.gdx.backends.openal.JavaSoundAudioDevice;
import com.badlogic.gdx.backends.openal.JavaSoundAudioRecorder;
import com.badlogic.gdx.backends.openal.Mp3;
import com.badlogic.gdx.backends.openal.Ogg;
import com.badlogic.gdx.backends.openal.OpenALMusic;
import com.badlogic.gdx.backends.openal.OpenALSound;
import com.badlogic.gdx.backends.openal.Wav;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.ObjectMap;
import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;

public class OpenALAudio
implements Audio {
    private IntArray idleSources;
    private IntArray allSources;
    private ObjectMap<String, Class<? extends OpenALSound>> extensionToSoundClass = new ObjectMap();
    private ObjectMap<String, Class<? extends OpenALMusic>> extensionToMusicClass = new ObjectMap();
    Array<OpenALMusic> music = new Array(false, 1, OpenALMusic.class);

    public OpenALAudio() {
        this(16);
    }

    public OpenALAudio(int simultaneousSources) {
        this.registerSound("ogg", Ogg.Sound.class);
        this.registerMusic("ogg", Ogg.Music.class);
        this.registerSound("wav", Wav.Sound.class);
        this.registerMusic("wav", Wav.Music.class);
        this.registerSound("mp3", Mp3.Sound.class);
        this.registerMusic("mp3", Mp3.Music.class);
        try {
            AL.create();
        }
        catch (LWJGLException ex) {
            throw new GdxRuntimeException("Error initializing OpenAL.", (Throwable)ex);
        }
        this.allSources = new IntArray(false, simultaneousSources);
        for (int i = 0; i < simultaneousSources; ++i) {
            int sourceID = AL10.alGenSources();
            if (AL10.alGetError() != 0) break;
            this.allSources.add(sourceID);
        }
        this.idleSources = new IntArray(this.allSources);
        FloatBuffer orientation = (FloatBuffer)BufferUtils.createFloatBuffer(6).put(new float[]{0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f}).flip();
        AL10.alListener(4111, orientation);
        FloatBuffer velocity = (FloatBuffer)BufferUtils.createFloatBuffer(3).put(new float[]{0.0f, 0.0f, 0.0f}).flip();
        AL10.alListener(4102, velocity);
        FloatBuffer position = (FloatBuffer)BufferUtils.createFloatBuffer(3).put(new float[]{0.0f, 0.0f, 0.0f}).flip();
        AL10.alListener(4100, position);
    }

    public void registerSound(String extension, Class<? extends OpenALSound> soundClass) {
        if (extension == null) {
            throw new IllegalArgumentException("extension cannot be null.");
        }
        if (soundClass == null) {
            throw new IllegalArgumentException("soundClass cannot be null.");
        }
        this.extensionToSoundClass.put((Object)extension, soundClass);
    }

    public void registerMusic(String extension, Class<? extends OpenALMusic> musicClass) {
        if (extension == null) {
            throw new IllegalArgumentException("extension cannot be null.");
        }
        if (musicClass == null) {
            throw new IllegalArgumentException("musicClass cannot be null.");
        }
        this.extensionToMusicClass.put((Object)extension, musicClass);
    }

    public OpenALSound newSound(FileHandle file) {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be null.");
        }
        Class soundClass = (Class)this.extensionToSoundClass.get((Object)file.extension());
        if (soundClass == null) {
            throw new GdxRuntimeException("Unknown file extension for sound: " + file);
        }
        try {
            return (OpenALSound)soundClass.getConstructor(OpenALAudio.class, FileHandle.class).newInstance(this, file);
        }
        catch (Exception ex) {
            throw new GdxRuntimeException("Error creating sound " + soundClass.getName() + " for file: " + file, (Throwable)ex);
        }
    }

    public OpenALMusic newMusic(FileHandle file) {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be null.");
        }
        Class musicClass = (Class)this.extensionToMusicClass.get((Object)file.extension());
        if (musicClass == null) {
            throw new GdxRuntimeException("Unknown file extension for music: " + file);
        }
        try {
            return (OpenALMusic)musicClass.getConstructor(OpenALAudio.class, FileHandle.class).newInstance(this, file);
        }
        catch (Exception ex) {
            throw new GdxRuntimeException("Error creating music " + musicClass.getName() + " for file: " + file, (Throwable)ex);
        }
    }

    int obtainSource(boolean isMusic) {
        int n = this.idleSources.size;
        for (int i = 0; i < n; ++i) {
            int sourceID = this.idleSources.get(i);
            int state = AL10.alGetSourcei(sourceID, 4112);
            if (state == 4114 || state == 4115) continue;
            if (isMusic) {
                this.idleSources.removeIndex(i);
            }
            AL10.alSourceStop(sourceID);
            AL10.alSourcei(sourceID, 4105, 0);
            return sourceID;
        }
        return -1;
    }

    void freeSource(int sourceID) {
        AL10.alSourceStop(sourceID);
        AL10.alSourcei(sourceID, 4105, 0);
        this.idleSources.add(sourceID);
    }

    void freeBuffer(int bufferID) {
        int n = this.idleSources.size;
        for (int i = 0; i < n; ++i) {
            int sourceID = this.idleSources.get(i);
            if (AL10.alGetSourcei(sourceID, 4105) != bufferID) continue;
            AL10.alSourceStop(sourceID);
            AL10.alSourcei(sourceID, 4105, 0);
        }
    }

    void stopSourcesWithBuffer(int bufferID) {
        int n = this.idleSources.size;
        for (int i = 0; i < n; ++i) {
            int sourceID = this.idleSources.get(i);
            if (AL10.alGetSourcei(sourceID, 4105) != bufferID) continue;
            AL10.alSourceStop(sourceID);
        }
    }

    public void update() {
        for (int i = 0; i < this.music.size; ++i) {
            ((OpenALMusic[])this.music.items)[i].update();
        }
    }

    public void dispose() {
        int n = this.allSources.size;
        for (int i = 0; i < n; ++i) {
            int sourceID = this.allSources.get(i);
            int state = AL10.alGetSourcei(sourceID, 4112);
            if (state != 4116) {
                AL10.alSourceStop(sourceID);
            }
            AL10.alDeleteSources(sourceID);
        }
        AL.destroy();
        while (AL.isCreated()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public AudioDevice newAudioDevice(int samplingRate, boolean isMono) {
        return new JavaSoundAudioDevice(samplingRate, isMono);
    }

    public AudioRecorder newAudioRecoder(int samplingRate, boolean isMono) {
        return new JavaSoundAudioRecorder(samplingRate, isMono);
    }
}

