/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.openal;

import com.badlogic.gdx.backends.openal.OggInputStream;
import com.badlogic.gdx.backends.openal.OpenALAudio;
import com.badlogic.gdx.backends.openal.OpenALMusic;
import com.badlogic.gdx.backends.openal.OpenALSound;
import com.badlogic.gdx.files.FileHandle;
import java.io.ByteArrayOutputStream;

public class Ogg {

    public static class Sound
    extends OpenALSound {
        public Sound(OpenALAudio audio, FileHandle file) {
            super(audio);
            int length;
            OggInputStream input = new OggInputStream(file.read());
            ByteArrayOutputStream output = new ByteArrayOutputStream(4096);
            byte[] buffer = new byte[2048];
            while (!input.atEnd() && (length = input.read(buffer)) != -1) {
                output.write(buffer, 0, length);
            }
            this.setup(output.toByteArray(), input.getChannels(), input.getSampleRate());
        }
    }

    public static class Music
    extends OpenALMusic {
        private OggInputStream input;

        public Music(OpenALAudio audio, FileHandle file) {
            super(audio, file);
            this.input = new OggInputStream(file.read());
            this.setup(this.input.getChannels(), this.input.getSampleRate());
        }

        @Override
        protected int read(byte[] buffer) {
            if (this.input == null) {
                this.input = new OggInputStream(this.file.read());
                this.setup(this.input.getChannels(), this.input.getSampleRate());
            }
            return this.input.read(buffer);
        }

        @Override
        protected void reset() {
            if (this.input == null) {
                return;
            }
            this.input.close();
            this.input = null;
        }
    }
}

