/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.openal;

import com.badlogic.gdx.audio.AudioDevice;
import com.badlogic.gdx.utils.GdxRuntimeException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.SourceDataLine;

public class JavaSoundAudioDevice
implements AudioDevice {
    private SourceDataLine line;
    private final boolean isMono;
    private byte[] bytes = new byte[176400];

    public JavaSoundAudioDevice(int samplingRate, boolean isMono) {
        this.isMono = isMono;
        try {
            AudioFormat format = new AudioFormat(samplingRate, 16, isMono ? 1 : 2, true, false);
            this.line = AudioSystem.getSourceDataLine(format);
            this.line.open(format, Math.min(2048, samplingRate / 5) * 2);
            this.line.start();
        }
        catch (Exception ex) {
            throw new GdxRuntimeException("Error creating JavaSoundAudioDevice.", (Throwable)ex);
        }
    }

    public void dispose() {
        this.line.drain();
        this.line.close();
    }

    public boolean isMono() {
        return this.isMono;
    }

    public void writeSamples(short[] samples, int offset, int numSamples) {
        if (this.bytes.length < samples.length * 2) {
            this.bytes = new byte[samples.length * 2];
        }
        int i = offset;
        int j = 0;
        while (i < offset + numSamples) {
            short value = samples[i];
            this.bytes[j] = (byte)(value & 0xFF);
            this.bytes[j + 1] = (byte)(value >> 8);
            ++i;
            j += 2;
        }
        for (int writtenBytes = this.line.write(this.bytes, 0, numSamples * 2); writtenBytes != numSamples * 2; writtenBytes += this.line.write(this.bytes, writtenBytes, numSamples * 2 - writtenBytes)) {
        }
    }

    public void writeSamples(float[] samples, int offset, int numSamples) {
        if (this.bytes.length < samples.length * 2) {
            this.bytes = new byte[samples.length * 2];
        }
        int i = offset;
        int j = 0;
        while (i < offset + numSamples) {
            float fValue = samples[i];
            if (fValue > 1.0f) {
                fValue = 1.0f;
            }
            if (fValue < -1.0f) {
                fValue = -1.0f;
            }
            short value = (short)(fValue * 32767.0f);
            this.bytes[j] = (byte)(value & 0xFF);
            this.bytes[j + 1] = (byte)(value >> 8);
            ++i;
            j += 2;
        }
        for (int writtenBytes = this.line.write(this.bytes, 0, numSamples * 2); writtenBytes != numSamples * 2; writtenBytes += this.line.write(this.bytes, writtenBytes, numSamples * 2 - writtenBytes)) {
        }
    }

    public int getLatency() {
        return 0;
    }
}

