/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl;

import com.badlogic.gdx.graphics.GL10;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.util.glu.GLU;

public class LwjglGLU
implements com.badlogic.gdx.graphics.GLU {
    FloatBuffer modelb = BufferUtils.createFloatBuffer(16);
    FloatBuffer projectb = BufferUtils.createFloatBuffer(16);
    IntBuffer viewb = BufferUtils.createIntBuffer(4);
    FloatBuffer winb = BufferUtils.createFloatBuffer(3);

    public void gluLookAt(GL10 gl, float eyeX, float eyeY, float eyeZ, float centerX, float centerY, float centerZ, float upX, float upY, float upZ) {
        GLU.gluLookAt(eyeX, eyeY, eyeZ, centerX, centerY, centerZ, upX, upY, upZ);
    }

    public void gluOrtho2D(GL10 gl, float left, float right, float bottom, float top) {
        GLU.gluOrtho2D(left, right, bottom, top);
    }

    public void gluPerspective(GL10 gl, float fovy, float aspect, float zNear, float zFar) {
        GLU.gluPerspective(fovy, aspect, zNear, zFar);
    }

    public boolean gluProject(float objX, float objY, float objZ, float[] model, int modelOffset, float[] project, int projectOffset, int[] view, int viewOffset, float[] win, int winOffset) {
        this.modelb.clear();
        this.modelb.put(model, modelOffset, 16);
        this.projectb.clear();
        this.projectb.put(project, projectOffset, 16);
        this.viewb.clear();
        this.viewb.put(view, viewOffset, 4);
        this.winb.clear();
        boolean result = GLU.gluProject(objX, objY, objZ, this.modelb, this.projectb, this.viewb, this.winb);
        win[winOffset] = this.winb.get(0);
        win[winOffset + 1] = this.winb.get(1);
        win[winOffset + 2] = this.winb.get(2);
        return result;
    }

    public boolean gluUnProject(float winX, float winY, float winZ, float[] model, int modelOffset, float[] project, int projectOffset, int[] view, int viewOffset, float[] obj, int objOffset) {
        this.modelb.clear();
        this.modelb.put(model, modelOffset, 16);
        this.projectb.clear();
        this.projectb.put(project, projectOffset, 16);
        this.viewb.clear();
        this.viewb.put(view, viewOffset, 4);
        this.winb.clear();
        boolean result = GLU.gluUnProject(winX, winY, winZ, this.modelb, this.projectb, this.viewb, this.winb);
        obj[objOffset] = this.winb.get(0);
        obj[objOffset + 1] = this.winb.get(1);
        obj[objOffset + 2] = this.winb.get(2);
        return result;
    }
}

