/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.tablelayout;

import com.esotericsoftware.tablelayout.BaseTableLayout;
import com.esotericsoftware.tablelayout.Cell;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public abstract class Toolkit<C, T extends C, L extends BaseTableLayout> {
    private static final ArrayList<String> classPrefixes = new ArrayList();

    public abstract void addChild(C var1, C var2, String var3);

    public abstract void removeChild(C var1, C var2);

    public abstract int getMinWidth(C var1);

    public abstract int getMinHeight(C var1);

    public abstract int getPrefWidth(C var1);

    public abstract int getPrefHeight(C var1);

    public abstract int getMaxWidth(C var1);

    public abstract int getMaxHeight(C var1);

    public abstract void clearDebugRectangles(L var1);

    public abstract void addDebugRectangle(L var1, int var2, int var3, int var4, int var5, int var6);

    public abstract C newStack();

    public abstract L getLayout(T var1);

    public T newTable(T parent) {
        try {
            return (T)parent.getClass().newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to create an instance of: " + parent.getClass().getName());
        }
    }

    public void setWidget(L layout, Cell cell, C widget) {
        if (widget != null) {
            this.removeChild(((BaseTableLayout)layout).table, widget);
            ((BaseTableLayout)layout).widgetToCell.remove(widget);
        }
        cell.widget = widget;
        ((BaseTableLayout)layout).nameToWidget.put(cell.name, widget);
        ((BaseTableLayout)layout).widgetToCell.put(widget, cell);
        this.addChild(((BaseTableLayout)layout).table, widget, null);
    }

    int getWidgetWidth(L layout, C widget, String value) {
        if (value.equals("min")) {
            return this.getMinWidth(widget);
        }
        if (value.equals("pref")) {
            return this.getPrefWidth(widget);
        }
        if (value.equals("max")) {
            return this.getMaxWidth(widget);
        }
        return this.width(layout, value);
    }

    int getWidgetHeight(L layout, C widget, String value) {
        if (value.equals("min")) {
            return this.getMinHeight(widget);
        }
        if (value.equals("pref")) {
            return this.getPrefHeight(widget);
        }
        if (value.equals("max")) {
            return this.getMaxHeight(widget);
        }
        return this.height(layout, value);
    }

    protected String validateSize(String size) {
        return size;
    }

    public C newWidget(L layout, String className) {
        try {
            return this.wrap(Class.forName(className).newInstance());
        }
        catch (Exception ex) {
            int n = classPrefixes.size();
            for (int i = 0; i < n; ++i) {
                String prefix = classPrefixes.get(i);
                try {
                    return this.newInstance(prefix + className);
                }
                catch (Exception ignored) {
                    continue;
                }
            }
            throw new RuntimeException("Error creating instance of class: " + className, ex);
        }
    }

    protected C newInstance(String className) throws Exception {
        return (C)Class.forName(className).newInstance();
    }

    public C wrap(Object object) {
        if (object instanceof BaseTableLayout) {
            return (C)((BaseTableLayout)object).getTable();
        }
        try {
            return (C)object;
        }
        catch (ClassCastException ex) {
            throw new RuntimeException("Unknown object type: " + object.getClass());
        }
    }

    public void setProperty(L layout, C object, String name, List<String> values) {
        try {
            this.invokeMethod(object, name, values);
        }
        catch (NoSuchMethodException ex1) {
            try {
                this.invokeMethod(object, "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1), values);
            }
            catch (NoSuchMethodException ex2) {
                try {
                    Field field = object.getClass().getField(name);
                    Object value = this.convertType(object, field.getType(), name, values.get(0));
                    if (value != null) {
                        field.set(object, value);
                    }
                }
                catch (Exception ex3) {
                    throw new RuntimeException("No method, bean property, or field found: " + name + "\nClass: " + object.getClass() + "\nValues: " + values);
                }
            }
        }
    }

    public void setTableProperty(L layout, String name, List<String> values) {
        block39: {
            name = name.toLowerCase();
            int n = values.size();
            for (int i = 0; i < n; ++i) {
                values.set(i, values.get(i).toLowerCase());
            }
            try {
                if (name.equals("size")) {
                    switch (values.size()) {
                        case 2: {
                            ((BaseTableLayout)layout).height = this.validateSize(values.get(1));
                        }
                        case 1: {
                            ((BaseTableLayout)layout).width = this.validateSize(values.get(0));
                        }
                    }
                    break block39;
                }
                if (name.equals("width") || name.equals("w")) {
                    ((BaseTableLayout)layout).width = this.validateSize(values.get(0));
                    break block39;
                }
                if (name.equals("height") || name.equals("h")) {
                    ((BaseTableLayout)layout).height = this.validateSize(values.get(0));
                    break block39;
                }
                if (name.equals("padding") || name.equals("pad")) {
                    switch (values.size()) {
                        case 4: {
                            String value = values.get(3);
                            if (value.length() > 0) {
                                ((BaseTableLayout)layout).padRight = this.validateSize(value);
                            }
                        }
                        case 3: {
                            String value = values.get(2);
                            if (value.length() > 0) {
                                ((BaseTableLayout)layout).padBottom = this.validateSize(value);
                            }
                        }
                        case 2: {
                            String value = values.get(0);
                            if (value.length() > 0) {
                                ((BaseTableLayout)layout).padTop = this.validateSize(value);
                            }
                            if ((value = values.get(1)).length() > 0) {
                                ((BaseTableLayout)layout).padLeft = this.validateSize(value);
                            }
                            break block39;
                        }
                        case 1: {
                            ((BaseTableLayout)layout).padBottom = ((BaseTableLayout)layout).padRight = this.validateSize(values.get(0));
                            ((BaseTableLayout)layout).padLeft = ((BaseTableLayout)layout).padRight;
                            ((BaseTableLayout)layout).padTop = ((BaseTableLayout)layout).padRight;
                            break block39;
                        }
                        default: {
                            throw new IllegalArgumentException("Invalid number of values (" + values.size() + "): " + values);
                        }
                    }
                }
                if (name.startsWith("padding") || name.startsWith("pad")) {
                    if ((name = name.replace("padding", "").replace("pad", "")).equals("top") || name.equals("t")) {
                        ((BaseTableLayout)layout).padTop = this.validateSize(values.get(0));
                        break block39;
                    }
                    if (name.equals("left") || name.equals("l")) {
                        ((BaseTableLayout)layout).padLeft = this.validateSize(values.get(0));
                        break block39;
                    }
                    if (name.equals("bottom") || name.equals("b")) {
                        ((BaseTableLayout)layout).padBottom = this.validateSize(values.get(0));
                        break block39;
                    }
                    if (name.equals("right") || name.equals("r")) {
                        ((BaseTableLayout)layout).padRight = this.validateSize(values.get(0));
                        break block39;
                    }
                    throw new IllegalArgumentException("Unknown property.");
                }
                if (name.equals("align")) {
                    int align = 0;
                    int n2 = values.size();
                    for (int i = 0; i < n2; ++i) {
                        String value = values.get(i);
                        if (value.equals("center")) {
                            align |= 1;
                            continue;
                        }
                        if (value.equals("left")) {
                            align |= 8;
                            continue;
                        }
                        if (value.equals("right")) {
                            align |= 0x10;
                            continue;
                        }
                        if (value.equals("top")) {
                            align |= 2;
                            continue;
                        }
                        if (value.equals("bottom")) {
                            align |= 4;
                            continue;
                        }
                        throw new IllegalArgumentException("Invalid value: " + value);
                    }
                    ((BaseTableLayout)layout).align = align;
                    break block39;
                }
                if (name.equals("debug")) {
                    int debug = 0;
                    if (values.size() == 0) {
                        debug = 1;
                    }
                    int n3 = values.size();
                    for (int i = 0; i < n3; ++i) {
                        String value = values.get(i);
                        if (value.equalsIgnoreCase("all") || value.equalsIgnoreCase("true")) {
                            debug |= 1;
                        }
                        if (value.equalsIgnoreCase("cell")) {
                            debug |= 4;
                        }
                        if (value.equalsIgnoreCase("table")) {
                            debug |= 2;
                        }
                        if (!value.equalsIgnoreCase("widget")) continue;
                        debug |= 8;
                    }
                    ((BaseTableLayout)layout).debug = debug;
                    break block39;
                }
                throw new IllegalArgumentException("Unknown table property: " + name);
            }
            catch (Exception ex) {
                throw new RuntimeException("Error setting table property: " + name, ex);
            }
        }
    }

    public void setCellProperty(Cell c, String name, List<String> values) {
        block94: {
            name = name.toLowerCase();
            int n = values.size();
            for (int i = 0; i < n; ++i) {
                values.set(i, values.get(i).toLowerCase());
            }
            try {
                int i;
                if (name.equals("expand")) {
                    switch (values.size()) {
                        case 0: {
                            c.expandX = c.expandY = Integer.valueOf(1);
                            break;
                        }
                        case 1: {
                            String value = values.get(0);
                            if (value.equals("x")) {
                                c.expandX = 1;
                                break;
                            }
                            if (value.equals("y")) {
                                c.expandY = 1;
                                break;
                            }
                            c.expandX = c.expandY = Integer.valueOf(Integer.parseInt(value));
                            break;
                        }
                        case 2: {
                            String value = values.get(0);
                            if (value.length() > 0) {
                                c.expandX = Integer.parseInt(value);
                            }
                            if ((value = values.get(1)).length() <= 0) break;
                            c.expandY = Integer.parseInt(value);
                        }
                    }
                    break block94;
                }
                if (name.equals("fill")) {
                    switch (values.size()) {
                        case 0: {
                            c.fillX = c.fillY = Float.valueOf(1.0f);
                            break;
                        }
                        case 1: {
                            String value = values.get(0);
                            if (value.equals("x")) {
                                c.fillX = Float.valueOf(1.0f);
                                break;
                            }
                            if (value.equals("y")) {
                                c.fillY = Float.valueOf(1.0f);
                                break;
                            }
                            c.fillX = c.fillY = Float.valueOf((float)Integer.parseInt(value) / 100.0f);
                            break;
                        }
                        case 2: {
                            String value = values.get(0);
                            if (value.length() > 0) {
                                c.fillX = Float.valueOf((float)Integer.parseInt(value) / 100.0f);
                            }
                            if ((value = values.get(1)).length() <= 0) break;
                            c.fillY = Float.valueOf((float)Integer.parseInt(value) / 100.0f);
                        }
                    }
                    break block94;
                }
                if (name.equals("size")) {
                    switch (values.size()) {
                        case 2: {
                            String value = values.get(0);
                            if (value.length() > 0) {
                                c.minWidth = c.prefWidth = this.validateSize(value);
                            }
                            if ((value = values.get(1)).length() > 0) {
                                c.minHeight = c.prefHeight = this.validateSize(value);
                            }
                            break block94;
                        }
                        case 1: {
                            String value = values.get(0);
                            if (value.length() > 0) {
                                c.prefWidth = c.prefHeight = this.validateSize(value);
                                c.minHeight = c.prefHeight;
                                c.minWidth = c.prefHeight;
                            }
                            break block94;
                        }
                        default: {
                            throw new IllegalArgumentException("Invalid number of values (" + values.size() + "): " + values);
                        }
                    }
                }
                if (name.equals("width") || name.equals("w")) {
                    switch (values.size()) {
                        case 3: {
                            String value = values.get(2);
                            if (value.length() > 0) {
                                c.maxWidth = this.validateSize(value);
                            }
                        }
                        case 2: {
                            String value = values.get(1);
                            if (value.length() > 0) {
                                c.prefWidth = this.validateSize(value);
                            }
                        }
                        case 1: {
                            String value = values.get(0);
                            if (value.length() > 0) {
                                c.minWidth = this.validateSize(value);
                            }
                            break block94;
                        }
                        default: {
                            throw new IllegalArgumentException("Invalid number of values (" + values.size() + "): " + values);
                        }
                    }
                }
                if (name.equals("height") || name.equals("h")) {
                    switch (values.size()) {
                        case 3: {
                            String value = values.get(2);
                            if (value.length() > 0) {
                                c.maxHeight = this.validateSize(value);
                            }
                        }
                        case 2: {
                            String value = values.get(1);
                            if (value.length() > 0) {
                                c.prefHeight = this.validateSize(value);
                            }
                        }
                        case 1: {
                            String value = values.get(0);
                            if (value.length() > 0) {
                                c.minHeight = this.validateSize(value);
                            }
                            break block94;
                        }
                        default: {
                            throw new IllegalArgumentException("Invalid number of values (" + values.size() + "): " + values);
                        }
                    }
                }
                if (name.equals("spacing") || name.equals("space")) {
                    switch (values.size()) {
                        case 4: {
                            String value = values.get(3);
                            if (value.length() > 0) {
                                c.spaceRight = this.validateSize(value);
                            }
                        }
                        case 3: {
                            String value = values.get(2);
                            if (value.length() > 0) {
                                c.spaceBottom = this.validateSize(value);
                            }
                        }
                        case 2: {
                            String value = values.get(0);
                            if (value.length() > 0) {
                                c.spaceTop = this.validateSize(value);
                            }
                            if ((value = values.get(1)).length() > 0) {
                                c.spaceLeft = this.validateSize(value);
                            }
                            break block94;
                        }
                        case 1: {
                            c.spaceBottom = c.spaceRight = this.validateSize(values.get(0));
                            c.spaceLeft = c.spaceRight;
                            c.spaceTop = c.spaceRight;
                            break block94;
                        }
                        default: {
                            throw new IllegalArgumentException("Invalid number of values (" + values.size() + "): " + values);
                        }
                    }
                }
                if (name.equals("padding") || name.equals("pad")) {
                    switch (values.size()) {
                        case 4: {
                            String value = values.get(3);
                            if (value.length() > 0) {
                                c.padRight = this.validateSize(value);
                            }
                        }
                        case 3: {
                            String value = values.get(2);
                            if (value.length() > 0) {
                                c.padBottom = this.validateSize(value);
                            }
                        }
                        case 2: {
                            String value = values.get(0);
                            if (value.length() > 0) {
                                c.padTop = this.validateSize(value);
                            }
                            if ((value = values.get(1)).length() > 0) {
                                c.padLeft = this.validateSize(value);
                            }
                            break block94;
                        }
                        case 1: {
                            c.padBottom = c.padRight = this.validateSize(values.get(0));
                            c.padLeft = c.padRight;
                            c.padTop = c.padRight;
                            break block94;
                        }
                        default: {
                            throw new IllegalArgumentException("Invalid number of values (" + values.size() + "): " + values);
                        }
                    }
                }
                if (name.startsWith("padding") || name.startsWith("pad")) {
                    if ((name = name.replace("padding", "").replace("pad", "")).equals("top") || name.equals("t")) {
                        c.padTop = this.validateSize(values.get(0));
                        break block94;
                    }
                    if (name.equals("left") || name.equals("l")) {
                        c.padLeft = this.validateSize(values.get(0));
                        break block94;
                    }
                    if (name.equals("bottom") || name.equals("b")) {
                        c.padBottom = this.validateSize(values.get(0));
                        break block94;
                    }
                    if (name.equals("right") || name.equals("r")) {
                        c.padRight = this.validateSize(values.get(0));
                        break block94;
                    }
                    throw new IllegalArgumentException("Unknown property.");
                }
                if (name.startsWith("spacing") || name.startsWith("space")) {
                    if ((name = name.replace("spacing", "").replace("space", "")).equals("top") || name.equals("t")) {
                        c.spaceTop = this.validateSize(values.get(0));
                        break block94;
                    }
                    if (name.equals("left") || name.equals("l")) {
                        c.spaceLeft = this.validateSize(values.get(0));
                        break block94;
                    }
                    if (name.equals("bottom") || name.equals("b")) {
                        c.spaceBottom = this.validateSize(values.get(0));
                        break block94;
                    }
                    if (name.equals("right") || name.equals("r")) {
                        c.spaceRight = this.validateSize(values.get(0));
                        break block94;
                    }
                    throw new IllegalArgumentException("Unknown property.");
                }
                if (name.equals("align")) {
                    c.align = 0;
                    int n2 = values.size();
                    for (i = 0; i < n2; ++i) {
                        Cell cell;
                        String value = values.get(i);
                        if (value.equals("center")) {
                            cell = c;
                            Integer.valueOf(cell.align | 1);
                            cell.align = cell.align;
                            continue;
                        }
                        if (value.equals("left")) {
                            cell = c;
                            Integer.valueOf(cell.align | 8);
                            cell.align = cell.align;
                            continue;
                        }
                        if (value.equals("right")) {
                            cell = c;
                            Integer.valueOf(cell.align | 0x10);
                            cell.align = cell.align;
                            continue;
                        }
                        if (value.equals("top")) {
                            cell = c;
                            Integer.valueOf(cell.align | 2);
                            cell.align = cell.align;
                            continue;
                        }
                        if (value.equals("bottom")) {
                            cell = c;
                            Integer.valueOf(cell.align | 4);
                            cell.align = cell.align;
                            continue;
                        }
                        throw new IllegalArgumentException("Invalid value: " + value);
                    }
                    break block94;
                }
                if (name.equals("ignore")) {
                    c.ignore = values.size() == 0 ? true : Boolean.valueOf(values.get(0));
                    break block94;
                }
                if (name.equals("colspan")) {
                    c.colspan = Integer.parseInt(values.get(0));
                    break block94;
                }
                if (name.equals("uniform")) {
                    if (values.size() == 0) {
                        c.uniformX = c.uniformY = Boolean.valueOf(true);
                    }
                    int n3 = values.size();
                    for (i = 0; i < n3; ++i) {
                        String value = values.get(i);
                        if (value.equals("x")) {
                            c.uniformX = true;
                            continue;
                        }
                        if (value.equals("y")) {
                            c.uniformY = true;
                            continue;
                        }
                        if (value.equals("false")) {
                            c.uniformY = null;
                            c.uniformY = null;
                            continue;
                        }
                        throw new IllegalArgumentException("Invalid value: " + value);
                    }
                    break block94;
                }
                throw new IllegalArgumentException("Unknown cell property.");
            }
            catch (Exception ex) {
                throw new RuntimeException("Error setting cell property: " + name, ex);
            }
        }
    }

    public int width(L layout, String value) {
        int length;
        if (value == null || (length = value.length()) == 0) {
            return this.width(0.0f);
        }
        if (value.charAt(length - 1) == '%' && length > 1) {
            return (int)((float)(((BaseTableLayout)layout).getLayoutWidth() * Integer.parseInt(value.substring(0, length - 1))) / 100.0f);
        }
        if (value.endsWith("px")) {
            return Integer.parseInt(value.substring(0, value.length() - 2));
        }
        return this.width(value == null ? 0.0f : (float)Integer.parseInt(value));
    }

    public int width(float value) {
        return (int)value;
    }

    public int height(L layout, String value) {
        int length;
        if (value == null || (length = value.length()) == 0) {
            return this.height(0.0f);
        }
        if (value.charAt(length - 1) == '%' && length > 1) {
            return (int)((float)(((BaseTableLayout)layout).getLayoutHeight() * Integer.parseInt(value.substring(0, length - 1))) / 100.0f);
        }
        if (value.endsWith("px")) {
            return Integer.parseInt(value.substring(0, value.length() - 2));
        }
        return this.height(value == null ? 0.0f : (float)Integer.parseInt(value));
    }

    public int height(float value) {
        return (int)value;
    }

    private void invokeMethod(Object object, String name, List<String> values) throws NoSuchMethodException {
        Object[] params = values.toArray();
        Class[] stringParamTypes = new Class[params.length];
        Method method2 = null;
        try {
            int n = params.length;
            for (int i = 0; i < n; ++i) {
                stringParamTypes[i] = String.class;
            }
            method2 = object.getClass().getMethod(name, stringParamTypes);
        }
        catch (NoSuchMethodException ignored) {
            try {
                int n = params.length;
                for (int i = 0; i < n; ++i) {
                    stringParamTypes[i] = CharSequence.class;
                }
                method2 = object.getClass().getMethod(name, stringParamTypes);
            }
            catch (NoSuchMethodException ignored2) {
                // empty catch block
            }
        }
        if (method2 != null) {
            try {
                method2.invoke(object, params);
            }
            catch (Exception ex) {
                throw new RuntimeException("Error invoking method: " + name, ex);
            }
            return;
        }
        block10: for (Method method2 : object.getClass().getMethods()) {
            Class<?>[] paramTypes;
            if (!method2.getName().equalsIgnoreCase(name) || (paramTypes = method2.getParameterTypes()).length != values.size()) continue;
            params = values.toArray();
            int nn = paramTypes.length;
            for (int ii = 0; ii < nn; ++ii) {
                Object value = this.convertType(object, paramTypes[ii], name, (String)params[ii]);
                if (value == null) continue block10;
                params[ii] = value;
            }
            try {
                method2.invoke(object, params);
                return;
            }
            catch (Exception ex) {
                throw new RuntimeException("Error invoking method: " + name, ex);
            }
        }
        throw new NoSuchMethodException();
    }

    protected Object convertType(Object parentObject, Class memberType, String memberName, String value) {
        Field field;
        if (memberType == String.class || memberType == CharSequence.class) {
            return value;
        }
        try {
            if (memberType == Integer.TYPE || memberType == Integer.class) {
                return Integer.valueOf(value);
            }
            if (memberType == Float.TYPE || memberType == Float.class) {
                return Float.valueOf(value);
            }
            if (memberType == Long.TYPE || memberType == Long.class) {
                return Long.valueOf(value);
            }
            if (memberType == Double.TYPE || memberType == Double.class) {
                return Double.valueOf(value);
            }
            if (memberType == Short.TYPE || memberType == Short.class) {
                return Short.valueOf(value);
            }
            if (memberType == Byte.TYPE || memberType == Byte.class) {
                return Byte.valueOf(value);
            }
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        if (memberType == Boolean.TYPE || memberType == Boolean.class) {
            return Boolean.valueOf(value);
        }
        if (memberType == Character.TYPE || memberType == Character.class) {
            return Character.valueOf(value.charAt(0));
        }
        try {
            field = Toolkit.getField(memberType, value);
            if (field != null && memberType == field.getType()) {
                return field.get(null);
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        try {
            field = Toolkit.getField(parentObject.getClass(), value);
            if (field != null && memberType == field.getType()) {
                return field.get(null);
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        return null;
    }

    private static Field getField(Class type, String name) {
        try {
            Field field = type.getField(name);
            if (field != null) {
                return field;
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        while (type != null && type != Object.class) {
            Field[] fields = type.getDeclaredFields();
            int n = fields.length;
            for (int i = 0; i < n; ++i) {
                if (!fields[i].getName().equalsIgnoreCase(name)) continue;
                return fields[i];
            }
            type = type.getSuperclass();
        }
        return null;
    }

    public static void addClassPrefix(String prefix) {
        classPrefixes.add(prefix);
    }
}

