/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.tablelayout;

import com.esotericsoftware.tablelayout.Cell;
import com.esotericsoftware.tablelayout.TableLayoutParser;
import com.esotericsoftware.tablelayout.Toolkit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseTableLayout<C, T extends C, L extends BaseTableLayout, K extends Toolkit<C, T, L>> {
    public static final int CENTER = 1;
    public static final int TOP = 2;
    public static final int BOTTOM = 4;
    public static final int LEFT = 8;
    public static final int RIGHT = 16;
    public static final String MIN = "min";
    public static final String PREF = "pref";
    public static final String MAX = "max";
    public static final int DEBUG_NONE = 0;
    public static final int DEBUG_ALL = 1;
    public static final int DEBUG_TABLE = 2;
    public static final int DEBUG_CELL = 4;
    public static final int DEBUG_WIDGET = 8;
    K toolkit;
    T table;
    HashMap<String, C> nameToWidget = new HashMap();
    HashMap<C, Cell> widgetToCell = new HashMap();
    private int columns;
    private int rows;
    private final ArrayList<Cell> cells = new ArrayList();
    private final Cell cellDefaults = Cell.defaults(this);
    private final ArrayList<Cell> columnDefaults = new ArrayList(4);
    private Cell rowDefaults;
    private int layoutX;
    private int layoutY;
    private int layoutWidth;
    private int layoutHeight;
    private int tableMinWidth;
    private int tableMinHeight;
    private int tablePrefWidth;
    private int tablePrefHeight;
    String width;
    String height;
    String padTop;
    String padLeft;
    String padBottom;
    String padRight;
    int align = 1;
    int debug = 0;

    public BaseTableLayout(K toolkit) {
        this.toolkit = toolkit;
    }

    public abstract void invalidate();

    public abstract void invalidateHierarchy();

    public void setLayoutSize(int tableLayoutX, int tableLayoutY, int tableLayoutWidth, int tableLayoutHeight) {
        this.layoutX = tableLayoutX;
        this.layoutY = tableLayoutY;
        this.layoutWidth = tableLayoutWidth;
        this.layoutHeight = tableLayoutHeight;
    }

    public C register(String name, C widget) {
        if (this.nameToWidget.containsKey(name = name.toLowerCase())) {
            throw new IllegalArgumentException("Name is already used: " + name);
        }
        this.nameToWidget.put(name, widget);
        return widget;
    }

    public void parse(String tableDescription) {
        TableLayoutParser.parse(this, tableDescription);
    }

    public Cell<C> add(C widget) {
        Cell cell = new Cell(this);
        cell.widget = widget;
        this.widgetToCell.put(widget, cell);
        for (Map.Entry<String, C> entry : this.nameToWidget.entrySet()) {
            if (widget != entry.getValue()) continue;
            cell.name = entry.getKey();
            break;
        }
        if (this.cells.size() > 0) {
            Cell lastCell = this.cells.get(this.cells.size() - 1);
            if (!lastCell.endRow) {
                cell.column = lastCell.column + lastCell.colspan;
                cell.row = lastCell.row;
            } else {
                cell.row = lastCell.row + 1;
            }
            if (cell.row > 0) {
                block1: for (int i = this.cells.size() - 1; i >= 0; --i) {
                    int column;
                    Cell other = this.cells.get(i);
                    int nn = column + other.colspan;
                    for (column = other.column; column < nn; ++column) {
                        if (other.column != cell.column) continue;
                        cell.cellAboveIndex = i;
                        break block1;
                    }
                }
            }
        }
        this.cells.add(cell);
        if (cell.column < this.columnDefaults.size()) {
            Cell columnDefaults = this.columnDefaults.get(cell.column);
            cell.set(columnDefaults != null ? columnDefaults : this.cellDefaults);
        } else {
            cell.set(this.cellDefaults);
        }
        cell.merge(this.rowDefaults);
        ((Toolkit)this.toolkit).addChild(this.table, widget, null);
        return cell;
    }

    public Cell<C> stack(C ... widgets) {
        Object stack = ((Toolkit)this.toolkit).newStack();
        int n = widgets.length;
        for (int i = 0; i < n; ++i) {
            ((Toolkit)this.toolkit).addChild(stack, widgets[i], null);
        }
        return this.add(stack);
    }

    public Cell row() {
        if (this.cells.size() > 0) {
            this.endRow();
        }
        this.rowDefaults = new Cell(this);
        return this.rowDefaults;
    }

    private void endRow() {
        int rowColumns = 0;
        for (int i = this.cells.size() - 1; i >= 0; --i) {
            Cell cell = this.cells.get(i);
            if (cell.endRow) break;
            rowColumns += cell.colspan.intValue();
        }
        this.columns = Math.max(this.columns, rowColumns);
        ++this.rows;
        this.cells.get((int)(this.cells.size() - 1)).endRow = true;
    }

    public Cell columnDefaults(int column) {
        Cell cell;
        Cell cell2 = cell = this.columnDefaults.size() > column ? this.columnDefaults.get(column) : null;
        if (cell == null) {
            cell = new Cell(this);
            cell.set(this.cellDefaults);
            if (column >= this.columnDefaults.size()) {
                for (int i = this.columnDefaults.size(); i < column; ++i) {
                    this.columnDefaults.add(null);
                }
                this.columnDefaults.add(cell);
            } else {
                this.columnDefaults.set(column, cell);
            }
        }
        return cell;
    }

    public void reset() {
        this.clear();
        this.padTop = null;
        this.padLeft = null;
        this.padBottom = null;
        this.padRight = null;
        this.align = 1;
        if (this.debug != 0) {
            ((Toolkit)this.toolkit).clearDebugRectangles((BaseTableLayout)this);
        }
        this.debug = 0;
        this.cellDefaults.set(Cell.defaults(this));
        this.columnDefaults.clear();
        this.rowDefaults = null;
    }

    public void clear() {
        for (int i = this.cells.size() - 1; i >= 0; --i) {
            ((Toolkit)this.toolkit).removeChild(this.table, this.cells.get((int)i).widget);
        }
        this.cells.clear();
        this.nameToWidget.clear();
        this.widgetToCell.clear();
        this.rows = 0;
        this.columns = 0;
    }

    public C getWidget(String name) {
        return this.nameToWidget.get(name.toLowerCase());
    }

    public List<C> getWidgets() {
        return new ArrayList<C>(this.nameToWidget.values());
    }

    public List<C> getWidgets(String namePrefix) {
        ArrayList<C> widgets = new ArrayList<C>();
        for (Map.Entry<String, C> entry : this.nameToWidget.entrySet()) {
            if (!entry.getKey().startsWith(namePrefix)) continue;
            widgets.add(entry.getValue());
        }
        return widgets;
    }

    public Cell getCell(C widget) {
        return this.widgetToCell.get(widget);
    }

    public Cell getCell(String name) {
        return this.getCell(this.getWidget(name));
    }

    public List<Cell> getAllCells() {
        return new ArrayList<Cell>(this.widgetToCell.values());
    }

    public List<Cell> getAllCells(String namePrefix) {
        ArrayList<Cell> cells = new ArrayList<Cell>();
        for (Cell cell : this.widgetToCell.values()) {
            if (!cell.name.startsWith(namePrefix)) continue;
            cells.add(cell);
        }
        return cells;
    }

    public List<Cell> getCells() {
        return this.cells;
    }

    public void setWidget(String name, C widget) {
        this.getCell(name).setWidget(widget);
    }

    public void setParent(BaseTableLayout parent) {
        this.nameToWidget = parent.nameToWidget;
        this.widgetToCell = parent.widgetToCell;
    }

    public void setToolkit(K toolkit) {
        this.toolkit = toolkit;
    }

    public T getTable() {
        return this.table;
    }

    public void setTable(T table) {
        this.table = table;
    }

    public int getLayoutX() {
        return this.layoutX;
    }

    public int getLayoutY() {
        return this.layoutY;
    }

    public int getLayoutWidth() {
        return this.layoutWidth;
    }

    public int getLayoutHeight() {
        return this.layoutHeight;
    }

    public int getMinWidth() {
        return this.tableMinWidth;
    }

    public int getMinHeight() {
        return this.tableMinHeight;
    }

    public int getPrefWidth() {
        return this.tablePrefWidth;
    }

    public int getPrefHeight() {
        return this.tablePrefHeight;
    }

    public Cell defaults() {
        return this.cellDefaults;
    }

    public K getToolkit() {
        return this.toolkit;
    }

    public L size(String width, String height) {
        this.width = width;
        this.height = height;
        return (L)this;
    }

    public L width(String width) {
        this.width = width;
        return (L)this;
    }

    public L height(String height) {
        this.height = height;
        return (L)this;
    }

    public L size(int width, int height) {
        this.width = String.valueOf(width);
        this.height = String.valueOf(height);
        return (L)this;
    }

    public L width(int width) {
        this.width = String.valueOf(width);
        return (L)this;
    }

    public L height(int height) {
        this.height = String.valueOf(height);
        return (L)this;
    }

    public L pad(String pad) {
        this.padTop = pad;
        this.padLeft = pad;
        this.padBottom = pad;
        this.padRight = pad;
        return (L)this;
    }

    public L pad(String top, String left, String bottom, String right) {
        this.padTop = top;
        this.padLeft = left;
        this.padBottom = bottom;
        this.padRight = right;
        return (L)this;
    }

    public L padTop(String padTop) {
        this.padTop = padTop;
        return (L)this;
    }

    public L padLeft(String padLeft) {
        this.padLeft = padLeft;
        return (L)this;
    }

    public L padBottom(String padBottom) {
        this.padBottom = padBottom;
        return (L)this;
    }

    public L padRight(String padRight) {
        this.padRight = padRight;
        return (L)this;
    }

    public L pad(int pad) {
        this.padTop = String.valueOf(pad);
        this.padLeft = String.valueOf(pad);
        this.padBottom = String.valueOf(pad);
        this.padRight = String.valueOf(pad);
        return (L)this;
    }

    public L pad(int top, int left, int bottom, int right) {
        this.padTop = String.valueOf(top);
        this.padLeft = String.valueOf(left);
        this.padBottom = String.valueOf(bottom);
        this.padRight = String.valueOf(right);
        return (L)this;
    }

    public L padTop(int padTop) {
        this.padTop = String.valueOf(padTop);
        return (L)this;
    }

    public L padLeft(int padLeft) {
        this.padLeft = String.valueOf(padLeft);
        return (L)this;
    }

    public L padBottom(int padBottom) {
        this.padBottom = String.valueOf(padBottom);
        return (L)this;
    }

    public L padRight(int padRight) {
        this.padRight = String.valueOf(padRight);
        return (L)this;
    }

    public L align(int align) {
        this.align = align;
        return (L)this;
    }

    public L align(String value) {
        this.align = 0;
        if (value.contains("center")) {
            this.align |= 1;
        }
        if (value.contains("left")) {
            this.align |= 8;
        }
        if (value.contains("right")) {
            this.align |= 0x10;
        }
        if (value.contains("top")) {
            this.align |= 2;
        }
        if (value.contains("bottom")) {
            this.align |= 4;
        }
        return (L)this;
    }

    public L center() {
        this.align |= 1;
        return (L)this;
    }

    public L top() {
        this.align |= 2;
        this.align &= 0xFFFFFFFB;
        return (L)this;
    }

    public L left() {
        this.align |= 8;
        this.align &= 0xFFFFFFEF;
        return (L)this;
    }

    public L bottom() {
        this.align |= 4;
        this.align &= 0xFFFFFFFD;
        return (L)this;
    }

    public L right() {
        this.align |= 0x10;
        this.align &= 0xFFFFFFF7;
        return (L)this;
    }

    public L debug() {
        this.debug = 1;
        this.invalidate();
        return (L)this;
    }

    public L debug(int debug) {
        this.debug = debug;
        if (debug == 0) {
            ((Toolkit)this.toolkit).clearDebugRectangles((BaseTableLayout)this);
        } else {
            this.invalidate();
        }
        return (L)this;
    }

    public L debug(String value) {
        this.debug = 0;
        if (value == null) {
            return (L)this;
        }
        if (value.equalsIgnoreCase("true")) {
            this.debug |= 1;
        }
        if (value.contains("all")) {
            this.debug |= 1;
        }
        if (value.contains("cell")) {
            this.debug |= 4;
        }
        if (value.contains("table")) {
            this.debug |= 2;
        }
        if (value.contains("widget")) {
            this.debug |= 8;
        }
        if (this.debug == 0) {
            ((Toolkit)this.toolkit).clearDebugRectangles((BaseTableLayout)this);
        } else {
            this.invalidate();
        }
        return (L)this;
    }

    public int getDebug() {
        return this.debug;
    }

    public String getWidth() {
        return this.width;
    }

    public String getHeight() {
        return this.height;
    }

    public String getPadTop() {
        return this.padTop;
    }

    public String getPadLeft() {
        return this.padLeft;
    }

    public String getPadBottom() {
        return this.padBottom;
    }

    public String getPadRight() {
        return this.padRight;
    }

    public int getAlign() {
        return this.align;
    }

    public void layout() {
        int nn;
        int column;
        int spannedCellWidth;
        Cell c;
        int i;
        int i2;
        int amount;
        int i3;
        int used;
        int extra;
        int i4;
        int[] rowMaxHeight;
        int[] columnMaxWidth;
        int i5;
        K toolkit = this.toolkit;
        ArrayList<Cell> cells = this.cells;
        if (cells.size() > 0 && !cells.get((int)(cells.size() - 1)).endRow) {
            this.endRow();
        }
        int[] columnMinWidth = new int[this.columns];
        int[] rowMinHeight = new int[this.rows];
        int[] columnPrefWidth = new int[this.columns];
        int[] rowPrefHeight = new int[this.rows];
        int spaceRightLast = 0;
        int n = cells.size();
        for (i5 = 0; i5 < n; ++i5) {
            Cell c2 = cells.get(i5);
            if (c2.ignore.booleanValue()) continue;
            c2.padLeftTemp = c2.column == 0 ? ((Toolkit)toolkit).width((BaseTableLayout)this, c2.padLeft) : ((Toolkit)toolkit).width((BaseTableLayout)this, c2.padLeft) + Math.max(0, ((Toolkit)toolkit).width((BaseTableLayout)this, c2.spaceLeft) - spaceRightLast);
            c2.padTopTemp = c2.cellAboveIndex == -1 ? ((Toolkit)toolkit).height((BaseTableLayout)this, c2.padTop) : ((Toolkit)toolkit).height((BaseTableLayout)this, c2.padTop) + Math.max(0, ((Toolkit)toolkit).height((BaseTableLayout)this, c2.spaceTop) - ((Toolkit)toolkit).height((BaseTableLayout)this, cells.get((int)c2.cellAboveIndex).spaceBottom));
            int spaceRight = ((Toolkit)toolkit).width((BaseTableLayout)this, c2.spaceRight);
            c2.padRightTemp = c2.column + c2.colspan == this.columns ? ((Toolkit)toolkit).width((BaseTableLayout)this, c2.padRight) : ((Toolkit)toolkit).width((BaseTableLayout)this, c2.padRight) + spaceRight;
            c2.padBottomTemp = c2.row == this.rows - 1 ? ((Toolkit)toolkit).height((BaseTableLayout)this, c2.padBottom) : ((Toolkit)toolkit).height((BaseTableLayout)this, c2.padBottom) + ((Toolkit)toolkit).height((BaseTableLayout)this, c2.spaceBottom);
            spaceRightLast = spaceRight;
            int prefWidth = ((Toolkit)toolkit).getWidgetWidth((BaseTableLayout)this, c2.widget, c2.prefWidth);
            int prefHeight = ((Toolkit)toolkit).getWidgetHeight((BaseTableLayout)this, c2.widget, c2.prefHeight);
            int minWidth = ((Toolkit)toolkit).getWidgetWidth((BaseTableLayout)this, c2.widget, c2.minWidth);
            int minHeight = ((Toolkit)toolkit).getWidgetHeight((BaseTableLayout)this, c2.widget, c2.minHeight);
            if (prefWidth < minWidth) {
                prefWidth = minWidth;
            }
            if (prefHeight < minHeight) {
                prefHeight = minHeight;
            }
            if (c2.colspan == 1) {
                int hpadding = c2.padLeftTemp + c2.padRightTemp;
                columnPrefWidth[c2.column] = Math.max(columnPrefWidth[c2.column], prefWidth + hpadding);
                columnMinWidth[c2.column] = Math.max(columnMinWidth[c2.column], minWidth + hpadding);
            }
            int vpadding = c2.padTopTemp + c2.padBottomTemp;
            rowPrefHeight[c2.row] = Math.max(rowPrefHeight[c2.row], prefHeight + vpadding);
            rowMinHeight[c2.row] = Math.max(rowMinHeight[c2.row], minHeight + vpadding);
        }
        this.tableMinWidth = 0;
        this.tableMinHeight = 0;
        this.tablePrefWidth = 0;
        this.tablePrefHeight = 0;
        for (i5 = 0; i5 < this.columns; ++i5) {
            this.tableMinWidth += columnMinWidth[i5];
            this.tablePrefWidth += columnPrefWidth[i5];
        }
        for (i5 = 0; i5 < this.rows; ++i5) {
            this.tableMinHeight += rowMinHeight[i5];
            this.tablePrefHeight += Math.max(rowMinHeight[i5], rowPrefHeight[i5]);
        }
        int hpadding = ((Toolkit)toolkit).width((BaseTableLayout)this, this.padLeft) + ((Toolkit)toolkit).width((BaseTableLayout)this, this.padRight);
        int vpadding = ((Toolkit)toolkit).height((BaseTableLayout)this, this.padTop) + ((Toolkit)toolkit).height((BaseTableLayout)this, this.padBottom);
        int width = ((Toolkit)toolkit).width((BaseTableLayout)this, this.width) - hpadding;
        int height = ((Toolkit)toolkit).height((BaseTableLayout)this, this.height) - vpadding;
        this.tableMinWidth = Math.max(this.tableMinWidth + hpadding, width);
        this.tableMinHeight = Math.max(this.tableMinHeight + vpadding, height);
        this.tablePrefWidth = Math.max(this.tablePrefWidth + hpadding, this.tableMinWidth);
        this.tablePrefHeight = Math.max(this.tablePrefHeight + vpadding, this.tableMinHeight);
        int tableLayoutWidth = this.layoutWidth;
        int totalGrowWidth = this.tablePrefWidth - this.tableMinWidth;
        if (totalGrowWidth == 0) {
            columnMaxWidth = columnMinWidth;
        } else {
            int extraWidth = Math.max(0, tableLayoutWidth - this.tableMinWidth);
            columnMaxWidth = new int[this.columns];
            for (int i6 = 0; i6 < this.columns; ++i6) {
                int growWidth = columnPrefWidth[i6] - columnMinWidth[i6];
                float growRatio = (float)growWidth / (float)totalGrowWidth;
                columnMaxWidth[i6] = columnMinWidth[i6] + (int)((float)extraWidth * growRatio);
            }
        }
        int tableLayoutHeight = this.layoutHeight;
        int totalGrowHeight = this.tablePrefHeight - this.tableMinHeight;
        if (totalGrowHeight == 0) {
            rowMaxHeight = rowMinHeight;
        } else {
            int extraHeight = Math.max(0, tableLayoutHeight - this.tableMinHeight);
            rowMaxHeight = new int[this.rows];
            for (int i7 = 0; i7 < this.rows; ++i7) {
                int growHeight = rowPrefHeight[i7] - rowMinHeight[i7];
                float growRatio = (float)growHeight / (float)totalGrowHeight;
                rowMaxHeight[i7] = rowMinHeight[i7] + (int)((float)extraHeight * growRatio);
            }
        }
        int[] columnWidth = new int[this.columns];
        int[] rowHeight = new int[this.rows];
        float[] expandWidth = new float[this.columns];
        float[] expandHeight = new float[this.rows];
        float totalExpandWidth = 0.0f;
        float totalExpandHeight = 0.0f;
        int n2 = cells.size();
        for (int i8 = 0; i8 < n2; ++i8) {
            int column2;
            Cell c3 = cells.get(i8);
            if (c3.ignore.booleanValue()) continue;
            int spannedCellMaxWidth = 0;
            int nn2 = column2 + c3.colspan;
            for (column2 = c3.column; column2 < nn2; ++column2) {
                spannedCellMaxWidth += columnMaxWidth[column2];
                if (c3.colspan != 1 || c3.expandX == 0 || expandWidth[column2] != 0.0f) continue;
                expandWidth[column2] = (float)c3.expandX.intValue() / (float)c3.colspan.intValue();
                totalExpandWidth += (float)c3.expandX.intValue() / (float)c3.colspan.intValue();
            }
            spannedCellMaxWidth -= c3.padLeftTemp + c3.padRightTemp;
            if (c3.expandY != 0 && expandHeight[c3.row] == 0.0f) {
                expandHeight[c3.row] = c3.expandY.intValue();
                totalExpandHeight += (float)c3.expandY.intValue();
            }
            int prefWidth = ((Toolkit)toolkit).getWidgetWidth((BaseTableLayout)this, c3.widget, c3.prefWidth);
            int prefHeight = ((Toolkit)toolkit).getWidgetHeight((BaseTableLayout)this, c3.widget, c3.prefHeight);
            int minWidth = ((Toolkit)toolkit).getWidgetWidth((BaseTableLayout)this, c3.widget, c3.minWidth);
            int minHeight = ((Toolkit)toolkit).getWidgetHeight((BaseTableLayout)this, c3.widget, c3.minHeight);
            if (prefWidth < minWidth) {
                prefWidth = minWidth;
            }
            if (prefHeight < minHeight) {
                prefHeight = minHeight;
            }
            c3.widgetWidth = Math.min(spannedCellMaxWidth, prefWidth);
            c3.widgetHeight = Math.min(rowMaxHeight[c3.row] - c3.padTopTemp - c3.padBottomTemp, prefHeight);
            if (c3.colspan == 1) {
                columnWidth[c3.column] = Math.max(columnWidth[c3.column], c3.widgetWidth + c3.padLeftTemp + c3.padRightTemp);
            }
            rowHeight[c3.row] = Math.max(rowHeight[c3.row], c3.widgetHeight + c3.padTopTemp + c3.padBottomTemp);
        }
        int uniformMaxWidth = 0;
        int uniformMaxHeight = 0;
        int n3 = cells.size();
        for (i4 = 0; i4 < n3; ++i4) {
            Cell c4 = cells.get(i4);
            if (c4.ignore.booleanValue()) continue;
            if (c4.uniformX != null) {
                uniformMaxWidth = Math.max(uniformMaxWidth, columnWidth[c4.column] - c4.padLeftTemp - c4.padRightTemp);
            }
            if (c4.uniformY == null) continue;
            uniformMaxHeight = Math.max(uniformMaxHeight, rowHeight[c4.row] - c4.padTopTemp - c4.padBottomTemp);
        }
        if (uniformMaxWidth > 0 || uniformMaxHeight > 0) {
            n3 = cells.size();
            for (i4 = 0; i4 < n3; ++i4) {
                int tempPadding;
                int diff;
                Cell c5 = cells.get(i4);
                if (c5.ignore.booleanValue()) continue;
                if (uniformMaxWidth > 0 && c5.uniformX != null && (diff = uniformMaxWidth - (columnWidth[c5.column] - (tempPadding = c5.padLeftTemp + c5.padRightTemp))) > 0) {
                    columnWidth[c5.column] = uniformMaxWidth + tempPadding;
                    this.tableMinWidth += diff;
                    this.tablePrefWidth += diff;
                }
                if (uniformMaxHeight <= 0 || c5.uniformY == null || (diff = uniformMaxHeight - (rowHeight[c5.row] - (tempPadding = c5.padTopTemp + c5.padBottomTemp))) <= 0) continue;
                rowHeight[c5.row] = uniformMaxHeight + tempPadding;
                this.tableMinHeight += diff;
                this.tablePrefHeight += diff;
            }
        }
        if (totalExpandWidth > 0.0f) {
            extra = Math.max(0, tableLayoutWidth - this.tablePrefWidth);
            used = 0;
            int lastIndex = 0;
            for (i3 = 0; i3 < this.columns; ++i3) {
                if (expandWidth[i3] == 0.0f) continue;
                amount = (int)((float)extra * expandWidth[i3] / totalExpandWidth);
                int n4 = i3;
                columnWidth[n4] = columnWidth[n4] + amount;
                used += amount;
                lastIndex = i3;
            }
            int n5 = lastIndex;
            columnWidth[n5] = columnWidth[n5] + (extra - used);
        }
        if (totalExpandHeight > 0.0f) {
            extra = Math.max(0, tableLayoutHeight - this.tablePrefHeight);
            used = 0;
            int lastIndex = 0;
            for (i3 = 0; i3 < this.rows; ++i3) {
                if (expandHeight[i3] == 0.0f) continue;
                amount = (int)((float)extra * expandHeight[i3] / totalExpandHeight);
                int n6 = i3;
                rowHeight[n6] = rowHeight[n6] + amount;
                used += amount;
                lastIndex = i3;
            }
            int n7 = lastIndex;
            rowHeight[n7] = rowHeight[n7] + (extra - used);
        }
        n3 = cells.size();
        for (i4 = 0; i4 < n3; ++i4) {
            int column3;
            Cell c6 = cells.get(i4);
            if (c6.ignore.booleanValue() || c6.colspan == 1) continue;
            int minWidth = ((Toolkit)toolkit).getWidgetWidth((BaseTableLayout)this, c6.widget, c6.minWidth);
            int spannedCellWidth2 = 0;
            int nn3 = column3 + c6.colspan;
            for (column3 = c6.column; column3 < nn3; ++column3) {
                spannedCellWidth2 += columnWidth[column3];
            }
            int extraWidth = Math.max(0, minWidth - spannedCellWidth2) / c6.colspan;
            int column4 = c6.column;
            int nn4 = column4 + c6.colspan;
            while (column4 < nn4) {
                int n8 = column4++;
                columnWidth[n8] = columnWidth[n8] + extraWidth;
            }
            c6.widgetWidth = Math.max(c6.widgetWidth, minWidth - (c6.padLeftTemp + c6.padRightTemp));
        }
        int tableWidth = 0;
        int tableHeight = 0;
        for (i2 = 0; i2 < this.columns; ++i2) {
            tableWidth += columnWidth[i2];
        }
        tableWidth = Math.max(tableWidth + hpadding, width);
        for (i2 = 0; i2 < this.rows; ++i2) {
            tableHeight += rowHeight[i2];
        }
        tableHeight = Math.max(tableHeight + vpadding, height);
        int x = this.layoutX + ((Toolkit)toolkit).width((BaseTableLayout)this, this.padLeft);
        if ((this.align & 0x10) != 0) {
            x += tableLayoutWidth - tableWidth;
        } else if ((this.align & 8) == 0) {
            x += (tableLayoutWidth - tableWidth) / 2;
        }
        int y = this.layoutY + ((Toolkit)toolkit).height((BaseTableLayout)this, this.padTop);
        if ((this.align & 4) != 0) {
            y += tableLayoutHeight - tableHeight;
        } else if ((this.align & 2) == 0) {
            y += (tableLayoutHeight - tableHeight) / 2;
        }
        int currentX = x;
        int currentY = y;
        int n9 = cells.size();
        for (i = 0; i < n9; ++i) {
            c = cells.get(i);
            if (c.ignore.booleanValue()) continue;
            spannedCellWidth = 0;
            nn = column + c.colspan;
            for (column = c.column; column < nn; ++column) {
                spannedCellWidth += columnWidth[column];
            }
            spannedCellWidth -= c.padLeftTemp + c.padRightTemp;
            currentX += c.padLeftTemp;
            if (c.fillX.floatValue() > 0.0f) {
                c.widgetWidth = (int)((float)spannedCellWidth * c.fillX.floatValue());
                int maxWidth = ((Toolkit)toolkit).getWidgetWidth((BaseTableLayout)this, c.widget, c.maxWidth);
                if (maxWidth > 0) {
                    c.widgetWidth = Math.min(c.widgetWidth, maxWidth);
                }
            }
            if (c.fillY.floatValue() > 0.0f) {
                c.widgetHeight = (int)((float)rowHeight[c.row] * c.fillY.floatValue()) - c.padTopTemp - c.padBottomTemp;
                int maxHeight = ((Toolkit)toolkit).getWidgetHeight((BaseTableLayout)this, c.widget, c.maxHeight);
                if (maxHeight > 0) {
                    c.widgetHeight = Math.min(c.widgetHeight, maxHeight);
                }
            }
            c.widgetX = (c.align & 8) != 0 ? currentX : ((c.align & 0x10) != 0 ? currentX + spannedCellWidth - c.widgetWidth : currentX + (spannedCellWidth - c.widgetWidth) / 2);
            c.widgetY = (c.align & 2) != 0 ? currentY + c.padTopTemp : ((c.align & 4) != 0 ? currentY + rowHeight[c.row] - c.widgetHeight - c.padBottomTemp : currentY + (rowHeight[c.row] - c.widgetHeight + c.padTopTemp - c.padBottomTemp) / 2);
            if (c.endRow) {
                currentX = x;
                currentY += rowHeight[c.row];
                continue;
            }
            currentX += spannedCellWidth + c.padRightTemp;
        }
        if (this.debug == 0) {
            return;
        }
        ((Toolkit)toolkit).clearDebugRectangles((BaseTableLayout)this);
        currentX = x;
        currentY = y;
        if ((this.debug & 2) != 0 || (this.debug & 1) != 0) {
            ((Toolkit)toolkit).addDebugRectangle((BaseTableLayout)this, 2, this.layoutX, this.layoutY, tableLayoutWidth, tableLayoutHeight);
            ((Toolkit)toolkit).addDebugRectangle((BaseTableLayout)this, 2, x, y, tableWidth - hpadding, tableHeight - vpadding);
        }
        n9 = cells.size();
        for (i = 0; i < n9; ++i) {
            c = cells.get(i);
            if (c.ignore.booleanValue()) continue;
            if ((this.debug & 8) != 0 || (this.debug & 1) != 0) {
                ((Toolkit)toolkit).addDebugRectangle((BaseTableLayout)this, 8, c.widgetX, c.widgetY, c.widgetWidth, c.widgetHeight);
            }
            spannedCellWidth = 0;
            nn = column + c.colspan;
            for (column = c.column; column < nn; ++column) {
                spannedCellWidth += columnWidth[column];
            }
            spannedCellWidth -= c.padLeftTemp + c.padRightTemp;
            currentX += c.padLeftTemp;
            if ((this.debug & 4) != 0 || (this.debug & 1) != 0) {
                ((Toolkit)toolkit).addDebugRectangle((BaseTableLayout)this, 4, currentX, currentY + c.padTopTemp, spannedCellWidth, rowHeight[c.row] - c.padTopTemp - c.padBottomTemp);
            }
            if (c.endRow) {
                currentX = x;
                currentY += rowHeight[c.row];
                continue;
            }
            currentX += spannedCellWidth + c.padRightTemp;
        }
    }
}

