/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Array;
import java.io.IOException;
import java.io.Writer;
import java.util.regex.Pattern;

public class JsonWriter
extends Writer {
    Writer writer;
    private final Array<JsonObject> stack = new Array();
    private JsonObject current;
    private boolean named;
    private OutputType outputType = OutputType.json;

    public JsonWriter(Writer writer) {
        this.writer = writer;
    }

    public void setOutputType(OutputType outputType) {
        this.outputType = outputType;
    }

    public JsonWriter name(String name) throws IOException {
        if (this.current == null || this.current.array) {
            throw new IllegalStateException("Current item must be an object.");
        }
        if (!this.current.needsComma) {
            this.current.needsComma = true;
        } else {
            this.writer.write(44);
        }
        this.writer.write(this.outputType.quoteName(name));
        this.writer.write(58);
        this.named = true;
        return this;
    }

    public JsonWriter object() throws IOException {
        if (this.current != null) {
            if (this.current.array) {
                if (!this.current.needsComma) {
                    this.current.needsComma = true;
                } else {
                    this.writer.write(44);
                }
            } else {
                if (!this.named && !this.current.array) {
                    throw new IllegalStateException("Name must be set.");
                }
                this.named = false;
            }
        }
        this.current = new JsonObject(false);
        this.stack.add(this.current);
        return this;
    }

    public JsonWriter array() throws IOException {
        if (this.current != null) {
            if (this.current.array) {
                if (!this.current.needsComma) {
                    this.current.needsComma = true;
                } else {
                    this.writer.write(44);
                }
            } else {
                if (!this.named && !this.current.array) {
                    throw new IllegalStateException("Name must be set.");
                }
                this.named = false;
            }
        }
        this.current = new JsonObject(true);
        this.stack.add(this.current);
        return this;
    }

    public JsonWriter value(Object value) throws IOException {
        if (this.current != null) {
            if (this.current.array) {
                if (!this.current.needsComma) {
                    this.current.needsComma = true;
                } else {
                    this.writer.write(44);
                }
            } else {
                if (!this.named) {
                    throw new IllegalStateException("Name must be set.");
                }
                this.named = false;
            }
        }
        if (value == null || value instanceof Number || value instanceof Boolean) {
            this.writer.write(String.valueOf(value));
        } else {
            this.writer.write(this.outputType.quoteValue(value.toString()));
        }
        return this;
    }

    public JsonWriter object(String name) throws IOException {
        return this.name(name).object();
    }

    public JsonWriter array(String name) throws IOException {
        return this.name(name).array();
    }

    public JsonWriter set(String name, Object value) throws IOException {
        return this.name(name).value(value);
    }

    public JsonWriter pop() throws IOException {
        if (this.named) {
            throw new IllegalStateException("Expected an object, array, or value since a name was set.");
        }
        this.stack.pop().close();
        this.current = this.stack.size == 0 ? null : this.stack.peek();
        return this;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writer.write(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        while (this.stack.size > 0) {
            this.pop();
        }
        this.writer.close();
    }

    public static enum OutputType {
        json,
        javascript,
        minimal;

        private static Pattern javascriptPattern;
        private static Pattern minimalPattern;

        public String quoteValue(String value) {
            value = value.replace("\\", "\\\\");
            if (this == minimal && !value.equals("true") && !value.equals("false") && !value.equals("null") && minimalPattern.matcher(value).matches()) {
                return value;
            }
            return '\"' + value + '\"';
        }

        public String quoteName(String value) {
            value = value.replace("\\", "\\\\");
            switch (this) {
                case minimal: {
                    if (minimalPattern.matcher(value).matches()) {
                        return value;
                    }
                    return '\"' + value + '\"';
                }
                case javascript: {
                    if (javascriptPattern.matcher(value).matches()) {
                        return value;
                    }
                    return '\"' + value + '\"';
                }
            }
            return '\"' + value + '\"';
        }

        static {
            javascriptPattern = Pattern.compile("[a-zA-Z_$][a-zA-Z_$0-9]*");
            minimalPattern = Pattern.compile("[a-zA-Z_$][^:}\\], ]*");
        }
    }

    private class JsonObject {
        final boolean array;
        boolean needsComma;

        JsonObject(boolean array) throws IOException {
            this.array = array;
            JsonWriter.this.writer.write(array ? 91 : 123);
        }

        void close() throws IOException {
            JsonWriter.this.writer.write(this.array ? 93 : 125);
        }
    }
}

