/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.SerializationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class JsonReader {
    private static final byte[] _json_actions = JsonReader.init__json_actions_0();
    private static final short[] _json_key_offsets = JsonReader.init__json_key_offsets_0();
    private static final char[] _json_trans_keys = JsonReader.init__json_trans_keys_0();
    private static final byte[] _json_single_lengths = JsonReader.init__json_single_lengths_0();
    private static final byte[] _json_range_lengths = JsonReader.init__json_range_lengths_0();
    private static final short[] _json_index_offsets = JsonReader.init__json_index_offsets_0();
    private static final byte[] _json_trans_targs = JsonReader.init__json_trans_targs_0();
    private static final byte[] _json_trans_actions = JsonReader.init__json_trans_actions_0();
    private static final byte[] _json_eof_actions = JsonReader.init__json_eof_actions_0();
    static final int json_start = 1;
    static final int json_first_final = 71;
    static final int json_error = 0;
    static final int json_en_object = 9;
    static final int json_en_array = 43;
    static final int json_en_main = 1;
    private final Array elements = new Array(8);
    private Object root;
    private Object current;

    public Object parse(String json) {
        char[] data = json.toCharArray();
        return this.parse(data, 0, data.length);
    }

    public Object parse(Reader reader) {
        try {
            int length;
            char[] data = new char[1024];
            int offset = 0;
            while ((length = reader.read(data, offset, data.length - offset)) != -1) {
                if (length == 0) {
                    char[] newData = new char[data.length * 2];
                    System.arraycopy(data, 0, newData, 0, data.length);
                    data = newData;
                    continue;
                }
                offset += length;
            }
            return this.parse(data, 0, offset);
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
    }

    public Object parse(InputStream input) {
        try {
            return this.parse(new InputStreamReader(input, "ISO-8859-1"));
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
    }

    public Object parse(FileHandle file) {
        try {
            return this.parse(file.read());
        }
        catch (Exception ex) {
            throw new SerializationException("Error parsing file: " + file, ex);
        }
    }

    /*
     * Unable to fully structure code
     */
    public Object parse(char[] data, int offset, int length) {
        p = offset;
        eof = pe = length;
        top = 0;
        stack = new int[4];
        s = 0;
        names = new Array<String>(8);
        needsUnescape = false;
        parseRuntimeEx = null;
        debug = false;
        if (debug) {
            System.out.println();
        }
        try {
            cs = 1;
            top = 0;
            _trans = 0;
            _goto_targ = 0;
            block29: while (true) {
                switch (_goto_targ) {
                    case 0: {
                        if (p == pe) {
                            _goto_targ = 4;
                            continue block29;
                        }
                        if (cs == 0) {
                            _goto_targ = 5;
                            continue block29;
                        }
                    }
                    case 1: {
                        _keys = JsonReader._json_key_offsets[cs];
                        _trans = JsonReader._json_index_offsets[cs];
                        _klen = JsonReader._json_single_lengths[cs];
                        if (_klen <= 0) ** GOTO lbl45
                        _lower = _keys;
                        _upper = _keys + _klen - 1;
                        while (_upper >= _lower) {
                            _mid = _lower + (_upper - _lower >> 1);
                            if (data[p] < JsonReader._json_trans_keys[_mid]) {
                                _upper = _mid - 1;
                                continue;
                            }
                            if (data[p] > JsonReader._json_trans_keys[_mid]) {
                                _lower = _mid + 1;
                                continue;
                            }
                            _trans += _mid - _keys;
                            ** GOTO lbl59
                        }
                        _keys += _klen;
                        _trans += _klen;
lbl45:
                        // 2 sources

                        if ((_klen = JsonReader._json_range_lengths[cs]) > 0) {
                            _lower = _keys;
                            _upper = _keys + (_klen << 1) - 2;
                            while (_upper >= _lower) {
                                _mid = _lower + (_upper - _lower >> 1 & -2);
                                if (data[p] < JsonReader._json_trans_keys[_mid]) {
                                    _upper = _mid - 2;
                                    continue;
                                }
                                if (data[p] > JsonReader._json_trans_keys[_mid + 1]) {
                                    _lower = _mid + 2;
                                    continue;
                                }
                                _trans += _mid - _keys >> 1;
                                ** GOTO lbl59
                            }
                            _trans += _klen;
                        }
lbl59:
                        // 5 sources

                        cs = JsonReader._json_trans_targs[_trans];
                        if (JsonReader._json_trans_actions[_trans] != 0) {
                            _acts = JsonReader._json_trans_actions[_trans];
                            _nacts = JsonReader._json_actions[_acts++];
                            while (_nacts-- > 0) {
                                switch (JsonReader._json_actions[_acts++]) {
                                    case 0: {
                                        s = p;
                                        needsUnescape = false;
                                        break;
                                    }
                                    case 1: {
                                        needsUnescape = true;
                                        break;
                                    }
                                    case 2: {
                                        name = new String(data, s, p - s);
                                        s = p;
                                        if (needsUnescape) {
                                            name = this.unescape(name);
                                        }
                                        if (debug) {
                                            System.out.println("name: " + name);
                                        }
                                        names.add(name);
                                        break;
                                    }
                                    case 3: {
                                        value = new String(data, s, p - s);
                                        s = p;
                                        if (needsUnescape) {
                                            value = this.unescape(value);
                                        }
                                        v0 = name = names.size > 0 ? (String)names.pop() : null;
                                        if (debug) {
                                            System.out.println("string: " + name + "=" + value);
                                        }
                                        this.string(name, value);
                                        break;
                                    }
                                    case 4: {
                                        value = new String(data, s, p - s);
                                        s = p;
                                        v1 = name = names.size > 0 ? (String)names.pop() : null;
                                        if (debug) {
                                            System.out.println("number: " + name + "=" + Float.parseFloat(value));
                                        }
                                        this.number(name, Float.parseFloat(value));
                                        break;
                                    }
                                    case 5: {
                                        v2 = name = names.size > 0 ? (String)names.pop() : null;
                                        if (debug) {
                                            System.out.println("boolean: " + name + "=true");
                                        }
                                        this.bool(name, true);
                                        break;
                                    }
                                    case 6: {
                                        v3 = name = names.size > 0 ? (String)names.pop() : null;
                                        if (debug) {
                                            System.out.println("boolean: " + name + "=false");
                                        }
                                        this.bool(name, false);
                                        break;
                                    }
                                    case 7: {
                                        v4 = name = names.size > 0 ? (String)names.pop() : null;
                                        if (debug) {
                                            System.out.println("null: " + name);
                                        }
                                        this.string(name, null);
                                        break;
                                    }
                                    case 8: {
                                        v5 = name = names.size > 0 ? (String)names.pop() : null;
                                        if (debug) {
                                            System.out.println("startObject: " + name);
                                        }
                                        this.startObject(name);
                                        if (top == stack.length) {
                                            newStack = new int[stack.length * 2];
                                            System.arraycopy(stack, 0, newStack, 0, stack.length);
                                            stack = newStack;
                                        }
                                        stack[top++] = cs;
                                        cs = 9;
                                        _goto_targ = 2;
                                        continue block29;
                                    }
                                    case 9: {
                                        if (debug) {
                                            System.out.println("endObject");
                                        }
                                        this.pop();
                                        cs = stack[--top];
                                        _goto_targ = 2;
                                        continue block29;
                                    }
                                    case 10: {
                                        v6 = name = names.size > 0 ? (String)names.pop() : null;
                                        if (debug) {
                                            System.out.println("startArray: " + name);
                                        }
                                        this.startArray(name);
                                        if (top == stack.length) {
                                            newStack = new int[stack.length * 2];
                                            System.arraycopy(stack, 0, newStack, 0, stack.length);
                                            stack = newStack;
                                        }
                                        stack[top++] = cs;
                                        cs = 43;
                                        _goto_targ = 2;
                                        continue block29;
                                    }
                                    case 11: {
                                        if (debug) {
                                            System.out.println("endArray");
                                        }
                                        this.pop();
                                        cs = stack[--top];
                                        _goto_targ = 2;
                                        continue block29;
                                    }
                                }
                            }
                        }
                    }
                    case 2: {
                        if (cs == 0) {
                            _goto_targ = 5;
                            continue block29;
                        }
                        if (++p != pe) {
                            _goto_targ = 1;
                            continue block29;
                        }
                    }
                    case 4: {
                        if (p != eof) break block29;
                        __acts = JsonReader._json_eof_actions[cs];
                        __nacts = JsonReader._json_actions[__acts++];
                        while (__nacts-- > 0) {
                            switch (JsonReader._json_actions[__acts++]) {
                                case 3: {
                                    value = new String(data, s, p - s);
                                    s = p;
                                    if (needsUnescape) {
                                        value = this.unescape(value);
                                    }
                                    v7 = name = names.size > 0 ? (String)names.pop() : null;
                                    if (debug) {
                                        System.out.println("string: " + name + "=" + value);
                                    }
                                    this.string(name, value);
                                    break;
                                }
                                case 4: {
                                    value = new String(data, s, p - s);
                                    s = p;
                                    v8 = name = names.size > 0 ? (String)names.pop() : null;
                                    if (debug) {
                                        System.out.println("number: " + name + "=" + Float.parseFloat(value));
                                    }
                                    this.number(name, Float.parseFloat(value));
                                    break;
                                }
                                case 5: {
                                    v9 = name = names.size > 0 ? (String)names.pop() : null;
                                    if (debug) {
                                        System.out.println("boolean: " + name + "=true");
                                    }
                                    this.bool(name, true);
                                    break;
                                }
                                case 6: {
                                    v10 = name = names.size > 0 ? (String)names.pop() : null;
                                    if (debug) {
                                        System.out.println("boolean: " + name + "=false");
                                    }
                                    this.bool(name, false);
                                    break;
                                }
                                case 7: {
                                    v11 = name = names.size > 0 ? (String)names.pop() : null;
                                    if (debug) {
                                        System.out.println("null: " + name);
                                    }
                                    this.string(name, null);
                                }
                            }
                        }
                        break block29;
                    }
                }
                break;
            }
        }
        catch (RuntimeException ex) {
            parseRuntimeEx = ex;
        }
        if (p < pe) {
            lineNumber = 1;
            for (i = 0; i < p; ++i) {
                if (data[i] != '\n') continue;
                ++lineNumber;
            }
            throw new SerializationException("Error parsing JSON on line " + lineNumber + " near: " + new String(data, p, pe - p), parseRuntimeEx);
        }
        if (this.elements.size != 0) {
            element = this.elements.peek();
            this.elements.clear();
            if (element instanceof ObjectMap) {
                throw new SerializationException("Error parsing JSON, unmatched brace.");
            }
            throw new SerializationException("Error parsing JSON, unmatched bracket.");
        }
        root = this.root;
        this.root = null;
        return root;
    }

    private static byte[] init__json_actions_0() {
        return new byte[]{0, 1, 0, 1, 1, 1, 2, 1, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 11, 2, 0, 2, 2, 0, 3, 2, 3, 9, 2, 3, 11, 2, 4, 9, 2, 4, 11, 2, 5, 9, 2, 5, 11, 2, 6, 9, 2, 6, 11, 2, 7, 9, 2, 7, 11};
    }

    private static short[] init__json_key_offsets_0() {
        return new short[]{0, 0, 19, 21, 23, 32, 35, 37, 41, 43, 55, 57, 59, 63, 82, 84, 86, 91, 102, 109, 118, 125, 128, 136, 138, 147, 151, 153, 160, 170, 178, 186, 194, 202, 207, 215, 223, 231, 236, 244, 252, 260, 265, 274, 295, 297, 299, 304, 324, 331, 334, 342, 344, 353, 357, 359, 366, 376, 384, 392, 400, 408, 413, 421, 429, 437, 442, 450, 458, 466, 471, 480, 483, 490, 496, 503, 508, 516, 524, 532, 540, 548, 551, 559, 567, 575, 578, 586, 594, 602, 605, 605};
    }

    private static char[] init__json_trans_keys_0() {
        return new char[]{' ', '\"', '$', '-', '0', '[', '_', 'f', 'n', 't', '{', '\t', '\r', '1', '9', 'A', 'Z', 'a', 'z', '\"', '\\', '\"', '\\', '\"', '/', '\\', 'b', 'f', 'n', 'r', 't', 'u', '0', '1', '9', '0', '9', '+', '-', '0', '9', '0', '9', ' ', '\"', '$', ',', '_', '}', '\t', '\r', 'A', 'Z', 'a', 'z', '\"', '\\', '\"', '\\', ' ', ':', '\t', '\r', ' ', '\"', '$', '-', '0', '[', '_', 'f', 'n', 't', '{', '\t', '\r', '1', '9', 'A', 'Z', 'a', 'z', '\"', '\\', '\"', '\\', ' ', ',', '}', '\t', '\r', ' ', '\"', '$', '_', '}', '\t', '\r', 'A', 'Z', 'a', 'z', ' ', ',', ':', ']', '}', '\t', '\r', '\"', '/', '\\', 'b', 'f', 'n', 'r', 't', 'u', ' ', ',', ':', ']', '}', '\t', '\r', '0', '1', '9', ' ', ',', '.', 'E', 'e', '}', '\t', '\r', '0', '9', ' ', ',', 'E', 'e', '}', '\t', '\r', '0', '9', '+', '-', '0', '9', '0', '9', ' ', ',', '}', '\t', '\r', '0', '9', ' ', ',', '.', 'E', 'e', '}', '\t', '\r', '0', '9', ' ', ',', ':', ']', 'a', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', ',', ':', ']', 's', '}', '\t', '\r', ' ', ',', ':', ']', 'e', '}', '\t', '\r', ' ', ',', '}', '\t', '\r', ' ', ',', ':', ']', 'u', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', ',', '}', '\t', '\r', ' ', ',', ':', ']', 'r', '}', '\t', '\r', ' ', ',', ':', ']', 'u', '}', '\t', '\r', ' ', ',', ':', ']', 'e', '}', '\t', '\r', ' ', ',', '}', '\t', '\r', '\"', '/', '\\', 'b', 'f', 'n', 'r', 't', 'u', ' ', '\"', '$', ',', '-', '0', '[', ']', '_', 'f', 'n', 't', '{', '\t', '\r', '1', '9', 'A', 'Z', 'a', 'z', '\"', '\\', '\"', '\\', ' ', ',', ']', '\t', '\r', ' ', '\"', '$', '-', '0', '[', ']', '_', 'f', 'n', 't', '{', '\t', '\r', '1', '9', 'A', 'Z', 'a', 'z', ' ', ',', ':', ']', '}', '\t', '\r', '0', '1', '9', ' ', ',', '.', 'E', ']', 'e', '\t', '\r', '0', '9', ' ', ',', 'E', ']', 'e', '\t', '\r', '0', '9', '+', '-', '0', '9', '0', '9', ' ', ',', ']', '\t', '\r', '0', '9', ' ', ',', '.', 'E', ']', 'e', '\t', '\r', '0', '9', ' ', ',', ':', ']', 'a', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', ',', ':', ']', 's', '}', '\t', '\r', ' ', ',', ':', ']', 'e', '}', '\t', '\r', ' ', ',', ']', '\t', '\r', ' ', ',', ':', ']', 'u', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', ',', ']', '\t', '\r', ' ', ',', ':', ']', 'r', '}', '\t', '\r', ' ', ',', ':', ']', 'u', '}', '\t', '\r', ' ', ',', ':', ']', 'e', '}', '\t', '\r', ' ', ',', ']', '\t', '\r', '\"', '/', '\\', 'b', 'f', 'n', 'r', 't', 'u', ' ', '\t', '\r', ' ', ',', ':', ']', '}', '\t', '\r', ' ', '.', 'E', 'e', '\t', '\r', ' ', 'E', 'e', '\t', '\r', '0', '9', ' ', '\t', '\r', '0', '9', ' ', '.', 'E', 'e', '\t', '\r', '0', '9', ' ', ',', ':', ']', 'a', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', ',', ':', ']', 's', '}', '\t', '\r', ' ', ',', ':', ']', 'e', '}', '\t', '\r', ' ', '\t', '\r', ' ', ',', ':', ']', 'u', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', '\t', '\r', ' ', ',', ':', ']', 'r', '}', '\t', '\r', ' ', ',', ':', ']', 'u', '}', '\t', '\r', ' ', ',', ':', ']', 'e', '}', '\t', '\r', ' ', '\t', '\r', '\u0000'};
    }

    private static byte[] init__json_single_lengths_0() {
        return new byte[]{0, 11, 2, 2, 7, 1, 0, 2, 0, 6, 2, 2, 2, 11, 2, 2, 3, 5, 5, 7, 5, 1, 6, 0, 5, 2, 0, 3, 6, 6, 6, 6, 6, 3, 6, 6, 6, 3, 6, 6, 6, 3, 7, 13, 2, 2, 3, 12, 5, 1, 6, 0, 5, 2, 0, 3, 6, 6, 6, 6, 6, 3, 6, 6, 6, 3, 6, 6, 6, 3, 7, 1, 5, 4, 3, 1, 4, 6, 6, 6, 6, 1, 6, 6, 6, 1, 6, 6, 6, 1, 0, 0};
    }

    private static byte[] init__json_range_lengths_0() {
        return new byte[]{0, 4, 0, 0, 1, 1, 1, 1, 1, 3, 0, 0, 1, 4, 0, 0, 1, 3, 1, 1, 1, 1, 1, 1, 2, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 0, 0, 1, 4, 1, 1, 1, 1, 2, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0};
    }

    private static short[] init__json_index_offsets_0() {
        return new short[]{0, 0, 16, 19, 22, 31, 34, 36, 40, 42, 52, 55, 58, 62, 78, 81, 84, 89, 98, 105, 114, 121, 124, 132, 134, 142, 146, 148, 154, 163, 171, 179, 187, 195, 200, 208, 216, 224, 229, 237, 245, 253, 258, 267, 285, 288, 291, 296, 313, 320, 323, 331, 333, 341, 345, 347, 353, 362, 370, 378, 386, 394, 399, 407, 415, 423, 428, 436, 444, 452, 457, 466, 469, 476, 482, 488, 492, 499, 507, 515, 523, 531, 534, 542, 550, 558, 561, 569, 577, 585, 588, 589};
    }

    private static byte[] init__json_trans_targs_0() {
        return new byte[]{1, 2, 72, 5, 73, 71, 72, 77, 82, 86, 71, 1, 76, 72, 72, 0, 71, 4, 3, 71, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 73, 76, 0, 74, 0, 8, 8, 75, 0, 75, 0, 9, 10, 18, 17, 18, 90, 9, 18, 18, 0, 12, 42, 11, 12, 42, 11, 12, 13, 12, 0, 13, 14, 20, 21, 22, 16, 20, 29, 34, 38, 16, 13, 28, 20, 20, 0, 16, 19, 15, 16, 19, 15, 16, 17, 90, 16, 0, 17, 10, 18, 18, 90, 17, 18, 18, 0, 12, 0, 13, 0, 0, 12, 18, 15, 15, 15, 15, 15, 15, 15, 15, 0, 16, 17, 0, 0, 90, 16, 20, 22, 28, 0, 16, 17, 23, 25, 25, 90, 16, 0, 24, 0, 16, 17, 25, 25, 90, 16, 24, 0, 26, 26, 27, 0, 27, 0, 16, 17, 90, 16, 27, 0, 16, 17, 23, 25, 25, 90, 16, 28, 0, 16, 17, 0, 0, 30, 90, 16, 20, 16, 17, 0, 0, 31, 90, 16, 20, 16, 17, 0, 0, 32, 90, 16, 20, 16, 17, 0, 0, 33, 90, 16, 20, 16, 17, 90, 16, 0, 16, 17, 0, 0, 35, 90, 16, 20, 16, 17, 0, 0, 36, 90, 16, 20, 16, 17, 0, 0, 37, 90, 16, 20, 16, 17, 90, 16, 0, 16, 17, 0, 0, 39, 90, 16, 20, 16, 17, 0, 0, 40, 90, 16, 20, 16, 17, 0, 0, 41, 90, 16, 20, 16, 17, 90, 16, 0, 11, 11, 11, 11, 11, 11, 11, 11, 0, 43, 44, 48, 47, 49, 50, 46, 91, 48, 57, 62, 66, 46, 43, 56, 48, 48, 0, 46, 70, 45, 46, 70, 45, 46, 47, 91, 46, 0, 47, 44, 48, 49, 50, 46, 91, 48, 57, 62, 66, 46, 47, 56, 48, 48, 0, 46, 47, 0, 91, 0, 46, 48, 50, 56, 0, 46, 47, 51, 53, 91, 53, 46, 0, 52, 0, 46, 47, 53, 91, 53, 46, 52, 0, 54, 54, 55, 0, 55, 0, 46, 47, 91, 46, 55, 0, 46, 47, 51, 53, 91, 53, 46, 56, 0, 46, 47, 0, 91, 58, 0, 46, 48, 46, 47, 0, 91, 59, 0, 46, 48, 46, 47, 0, 91, 60, 0, 46, 48, 46, 47, 0, 91, 61, 0, 46, 48, 46, 47, 91, 46, 0, 46, 47, 0, 91, 63, 0, 46, 48, 46, 47, 0, 91, 64, 0, 46, 48, 46, 47, 0, 91, 65, 0, 46, 48, 46, 47, 91, 46, 0, 46, 47, 0, 91, 67, 0, 46, 48, 46, 47, 0, 91, 68, 0, 46, 48, 46, 47, 0, 91, 69, 0, 46, 48, 46, 47, 91, 46, 0, 45, 45, 45, 45, 45, 45, 45, 45, 0, 71, 71, 0, 71, 0, 0, 0, 0, 71, 72, 71, 6, 7, 7, 71, 0, 71, 7, 7, 71, 74, 0, 71, 71, 75, 0, 71, 6, 7, 7, 71, 76, 0, 71, 0, 0, 0, 78, 0, 71, 72, 71, 0, 0, 0, 79, 0, 71, 72, 71, 0, 0, 0, 80, 0, 71, 72, 71, 0, 0, 0, 81, 0, 71, 72, 71, 71, 0, 71, 0, 0, 0, 83, 0, 71, 72, 71, 0, 0, 0, 84, 0, 71, 72, 71, 0, 0, 0, 85, 0, 71, 72, 71, 71, 0, 71, 0, 0, 0, 87, 0, 71, 72, 71, 0, 0, 0, 88, 0, 71, 72, 71, 0, 0, 0, 89, 0, 71, 72, 71, 71, 0, 0, 0, 0};
    }

    private static byte[] init__json_trans_actions_0() {
        return new byte[]{0, 0, 1, 1, 1, 21, 1, 1, 1, 1, 17, 0, 1, 1, 1, 0, 28, 1, 1, 7, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 19, 0, 1, 1, 0, 25, 1, 1, 5, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 21, 1, 1, 1, 1, 17, 0, 1, 1, 1, 0, 28, 1, 1, 7, 0, 0, 0, 0, 19, 0, 0, 0, 0, 1, 1, 19, 0, 1, 1, 0, 5, 0, 5, 0, 0, 5, 0, 3, 3, 3, 3, 3, 3, 3, 3, 0, 7, 7, 0, 0, 31, 7, 0, 0, 0, 0, 9, 9, 0, 0, 0, 37, 9, 0, 0, 0, 9, 9, 0, 0, 37, 9, 0, 0, 0, 0, 0, 0, 0, 0, 9, 9, 37, 9, 0, 0, 9, 9, 0, 0, 0, 37, 9, 0, 0, 7, 7, 0, 0, 0, 31, 7, 0, 7, 7, 0, 0, 0, 31, 7, 0, 7, 7, 0, 0, 0, 31, 7, 0, 7, 7, 0, 0, 0, 31, 7, 0, 13, 13, 49, 13, 0, 7, 7, 0, 0, 0, 31, 7, 0, 7, 7, 0, 0, 0, 31, 7, 0, 7, 7, 0, 0, 0, 31, 7, 0, 15, 15, 55, 15, 0, 7, 7, 0, 0, 0, 31, 7, 0, 7, 7, 0, 0, 0, 31, 7, 0, 7, 7, 0, 0, 0, 31, 7, 0, 11, 11, 43, 11, 0, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 1, 0, 1, 1, 21, 23, 1, 1, 1, 1, 17, 0, 1, 1, 1, 0, 28, 1, 1, 7, 0, 0, 0, 0, 23, 0, 0, 0, 0, 1, 1, 1, 21, 23, 1, 1, 1, 1, 17, 0, 1, 1, 1, 0, 7, 7, 0, 34, 0, 7, 0, 0, 0, 0, 9, 9, 0, 0, 40, 0, 9, 0, 0, 0, 9, 9, 0, 40, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 9, 9, 40, 9, 0, 0, 9, 9, 0, 0, 40, 0, 9, 0, 0, 7, 7, 0, 34, 0, 0, 7, 0, 7, 7, 0, 34, 0, 0, 7, 0, 7, 7, 0, 34, 0, 0, 7, 0, 7, 7, 0, 34, 0, 0, 7, 0, 13, 13, 52, 13, 0, 7, 7, 0, 34, 0, 0, 7, 0, 7, 7, 0, 34, 0, 0, 7, 0, 7, 7, 0, 34, 0, 0, 7, 0, 15, 15, 58, 15, 0, 7, 7, 0, 34, 0, 0, 7, 0, 7, 7, 0, 34, 0, 0, 7, 0, 7, 7, 0, 34, 0, 0, 7, 0, 11, 11, 46, 11, 0, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 7, 0, 0, 0, 0, 7, 0, 9, 0, 0, 0, 9, 0, 9, 0, 0, 9, 0, 0, 9, 9, 0, 0, 9, 0, 0, 0, 9, 0, 0, 7, 0, 0, 0, 0, 0, 7, 0, 7, 0, 0, 0, 0, 0, 7, 0, 7, 0, 0, 0, 0, 0, 7, 0, 7, 0, 0, 0, 0, 0, 7, 0, 13, 13, 0, 7, 0, 0, 0, 0, 0, 7, 0, 7, 0, 0, 0, 0, 0, 7, 0, 7, 0, 0, 0, 0, 0, 7, 0, 15, 15, 0, 7, 0, 0, 0, 0, 0, 7, 0, 7, 0, 0, 0, 0, 0, 7, 0, 7, 0, 0, 0, 0, 0, 7, 0, 11, 11, 0, 0, 0, 0};
    }

    private static byte[] init__json_eof_actions_0() {
        return new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 9, 9, 9, 9, 7, 7, 7, 7, 13, 7, 7, 7, 15, 7, 7, 7, 11, 0, 0};
    }

    private void set(String name, Object value) {
        if (this.current instanceof ObjectMap) {
            ((ObjectMap)this.current).put(name, value);
        } else if (this.current instanceof Array) {
            ((Array)this.current).add(value);
        } else {
            this.root = value;
        }
    }

    protected void startObject(String name) {
        ObjectMap value = new ObjectMap();
        if (this.current != null) {
            this.set(name, value);
        }
        this.elements.add(value);
        this.current = value;
    }

    protected void startArray(String name) {
        Array value = new Array();
        if (this.current != null) {
            this.set(name, value);
        }
        this.elements.add(value);
        this.current = value;
    }

    protected void pop() {
        this.root = this.elements.pop();
        this.current = this.elements.size > 0 ? this.elements.peek() : null;
    }

    protected void string(String name, String value) {
        this.set(name, value);
    }

    protected void number(String name, float value) {
        this.set(name, Float.valueOf(value));
    }

    protected void bool(String name, boolean value) {
        this.set(name, value);
    }

    private String unescape(String value) {
        int length = value.length();
        StringBuilder buffer = new StringBuilder(length + 16);
        int i = 0;
        while (i < length) {
            char c;
            if ((c = value.charAt(i++)) != '\\') {
                buffer.append(c);
                continue;
            }
            if (i == length) break;
            if ((c = value.charAt(i++)) == 'u') {
                buffer.append(Character.toChars(Integer.parseInt(value.substring(i, i + 4), 16)));
                i += 4;
                continue;
            }
            switch (c) {
                case '\"': 
                case '/': 
                case '\\': {
                    break;
                }
                case 'b': {
                    c = '\b';
                    break;
                }
                case 'f': {
                    c = '\f';
                    break;
                }
                case 'n': {
                    c = '\n';
                    break;
                }
                case 'r': {
                    c = '\r';
                    break;
                }
                case 't': {
                    c = '\t';
                    break;
                }
                default: {
                    throw new SerializationException("Illegal escaped character: \\" + c);
                }
            }
            buffer.append(c);
        }
        return buffer.toString();
    }
}

