/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonWriter;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.SerializationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Json {
    private static final boolean debug = false;
    private JsonWriter writer;
    private String typeName = "class";
    private boolean usePrototypes = true;
    private JsonWriter.OutputType outputType;
    private final ObjectMap<Class, ObjectMap<String, FieldMetadata>> typeToFields = new ObjectMap();
    private final ObjectMap<String, Class> tagToClass = new ObjectMap();
    private final ObjectMap<Class, String> classToTag = new ObjectMap();
    private final ObjectMap<Class, Serializer> classToSerializer = new ObjectMap();
    private final ObjectMap<Class, Object[]> classToDefaultValues = new ObjectMap();
    private boolean ignoreUnknownFields;

    public Json() {
        this.outputType = JsonWriter.OutputType.minimal;
    }

    public Json(JsonWriter.OutputType outputType) {
        this.outputType = outputType;
    }

    public void setIgnoreUnknownFields(boolean ignoreUnknownFields) {
        this.ignoreUnknownFields = ignoreUnknownFields;
    }

    public void setOutputType(JsonWriter.OutputType outputType) {
        this.outputType = outputType;
    }

    public void addClassTag(String tag, Class type) {
        this.tagToClass.put(tag, type);
        this.classToTag.put(type, tag);
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public <T> void setSerializer(Class<T> type, Serializer<T> serializer) {
        this.classToSerializer.put(type, serializer);
    }

    public void setUsePrototypes(boolean usePrototypes) {
        this.usePrototypes = usePrototypes;
    }

    public void setElementType(Class type, String fieldName, Class elementType) {
        FieldMetadata metadata;
        ObjectMap<String, FieldMetadata> fields = this.typeToFields.get(type);
        if (fields == null) {
            fields = this.cacheFields(type);
        }
        if ((metadata = fields.get(fieldName)) == null) {
            throw new SerializationException("Field not found: " + fieldName + " (" + type.getName() + ")");
        }
        metadata.elementType = elementType;
    }

    private ObjectMap<String, FieldMetadata> cacheFields(Class type) {
        ArrayList allFields = new ArrayList();
        for (Class nextClass = type; nextClass != Object.class; nextClass = nextClass.getSuperclass()) {
            Collections.addAll(allFields, nextClass.getDeclaredFields());
        }
        ObjectMap<String, FieldMetadata> nameToField = new ObjectMap<String, FieldMetadata>();
        int n = allFields.size();
        for (int i = 0; i < n; ++i) {
            Field field = (Field)allFields.get(i);
            int modifiers = field.getModifiers();
            if (Modifier.isTransient(modifiers) || Modifier.isStatic(modifiers) || field.isSynthetic()) continue;
            if (!field.isAccessible()) {
                try {
                    field.setAccessible(true);
                }
                catch (AccessControlException ex) {
                    continue;
                }
            }
            nameToField.put(field.getName(), new FieldMetadata(field));
        }
        this.typeToFields.put(type, nameToField);
        return nameToField;
    }

    public String toJson(Object object) {
        return this.toJson(object, object == null ? null : object.getClass(), (Class)null);
    }

    public String toJson(Object object, Class knownType) {
        return this.toJson(object, knownType, (Class)null);
    }

    public String toJson(Object object, Class knownType, Class elementType) {
        StringWriter buffer = new StringWriter();
        this.toJson(object, knownType, elementType, buffer);
        return buffer.toString();
    }

    public void toJson(Object object, FileHandle file) {
        this.toJson(object, object == null ? null : object.getClass(), null, file);
    }

    public void toJson(Object object, Class knownType, FileHandle file) {
        this.toJson(object, knownType, null, file);
    }

    public void toJson(Object object, Class knownType, Class elementType, FileHandle file) {
        Writer writer = null;
        try {
            writer = file.writer(false);
            this.toJson(object, knownType, elementType, writer);
        }
        catch (Exception ex) {
            throw new SerializationException("Error writing file: " + file, ex);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException ignored) {}
        }
    }

    public void toJson(Object object, Writer writer) {
        this.toJson(object, object == null ? null : object.getClass(), null, writer);
    }

    public void toJson(Object object, Class knownType, Writer writer) {
        this.toJson(object, knownType, null, writer);
    }

    public void toJson(Object object, Class knownType, Class elementType, Writer writer) {
        if (!(writer instanceof JsonWriter)) {
            this.writer = new JsonWriter(writer);
            this.writer.setOutputType(this.outputType);
        }
        this.writeValue(object, knownType, elementType);
    }

    public void writeFields(Object object) {
        Class<?> type = object.getClass();
        Object[] defaultValues = this.getDefaultValues(type);
        ObjectMap<String, FieldMetadata> fields = this.typeToFields.get(type);
        if (fields == null) {
            fields = this.cacheFields(type);
        }
        int i = 0;
        for (FieldMetadata metadata : fields.values()) {
            Field field = metadata.field;
            try {
                Object value = field.get(object);
                if (defaultValues != null) {
                    Object defaultValue = defaultValues[i++];
                    if (value == null && defaultValue == null || value != null && defaultValue != null && value.equals(defaultValue)) continue;
                }
                this.writer.name(field.getName());
                this.writeValue(value, field.getType(), metadata.elementType);
            }
            catch (IllegalAccessException ex) {
                throw new SerializationException("Error accessing field: " + field.getName() + " (" + type.getName() + ")", ex);
            }
            catch (SerializationException ex) {
                ex.addTrace(field + " (" + type.getName() + ")");
                throw ex;
            }
            catch (Exception runtimeEx) {
                SerializationException ex = new SerializationException(runtimeEx);
                ex.addTrace(field + " (" + type.getName() + ")");
                throw ex;
            }
        }
    }

    private Object[] getDefaultValues(Class type) {
        if (!this.usePrototypes) {
            return null;
        }
        Object[] values = this.classToDefaultValues.get(type);
        if (values == null) {
            Object object = this.newInstance(type);
            ObjectMap<String, FieldMetadata> fields = this.typeToFields.get(type);
            if (fields == null) {
                fields = this.cacheFields(type);
            }
            values = new Object[fields.size];
            this.classToDefaultValues.put(type, values);
            int i = 0;
            for (FieldMetadata metadata : fields.values()) {
                Field field = metadata.field;
                try {
                    values[i++] = field.get(object);
                }
                catch (IllegalAccessException ex) {
                    throw new SerializationException("Error accessing field: " + field.getName() + " (" + type.getName() + ")", ex);
                }
                catch (SerializationException ex) {
                    ex.addTrace(field + " (" + type.getName() + ")");
                    throw ex;
                }
                catch (RuntimeException runtimeEx) {
                    SerializationException ex = new SerializationException(runtimeEx);
                    ex.addTrace(field + " (" + type.getName() + ")");
                    throw ex;
                }
            }
        }
        return values;
    }

    public void writeField(Object object, String name) {
        this.writeField(object, name, name, null);
    }

    public void writeField(Object object, String name, Class elementType) {
        this.writeField(object, name, name, elementType);
    }

    public void writeField(Object object, String fieldName, String jsonName) {
        this.writeField(object, fieldName, jsonName, null);
    }

    public void writeField(Object object, String fieldName, String jsonName, Class elementType) {
        FieldMetadata metadata;
        Class<?> type = object.getClass();
        ObjectMap<String, FieldMetadata> fields = this.typeToFields.get(type);
        if (fields == null) {
            fields = this.cacheFields(type);
        }
        if ((metadata = fields.get(fieldName)) == null) {
            throw new SerializationException("Field not found: " + fieldName + " (" + type.getName() + ")");
        }
        Field field = metadata.field;
        if (elementType == null) {
            elementType = metadata.elementType;
        }
        try {
            this.writer.name(jsonName);
            this.writeValue(field.get(object), field.getType(), elementType);
        }
        catch (IllegalAccessException ex) {
            throw new SerializationException("Error accessing field: " + field.getName() + " (" + type.getName() + ")", ex);
        }
        catch (SerializationException ex) {
            ex.addTrace(field + " (" + type.getName() + ")");
            throw ex;
        }
        catch (Exception runtimeEx) {
            SerializationException ex = new SerializationException(runtimeEx);
            ex.addTrace(field + " (" + type.getName() + ")");
            throw ex;
        }
    }

    public void writeValue(String name, Object value) {
        try {
            this.writer.name(name);
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
        this.writeValue(value, value.getClass(), null);
    }

    public void writeValue(String name, Object value, Class knownType) {
        try {
            this.writer.name(name);
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
        this.writeValue(value, knownType, null);
    }

    public void writeValue(String name, Object value, Class knownType, Class elementType) {
        try {
            this.writer.name(name);
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
        this.writeValue(value, knownType, elementType);
    }

    public void writeValue(Object value) {
        this.writeValue(value, value.getClass(), null);
    }

    public void writeValue(Object value, Class knownType) {
        this.writeValue(value, knownType, null);
    }

    public void writeValue(Object value, Class knownType, Class elementType) {
        try {
            if (value == null) {
                this.writer.value(null);
                return;
            }
            Class<?> actualType = value.getClass();
            if (actualType.isPrimitive() || actualType == String.class || actualType == Integer.class || actualType == Boolean.class || actualType == Float.class || actualType == Long.class || actualType == Double.class || actualType == Short.class || actualType == Byte.class || actualType == Character.class) {
                this.writer.value(value);
                return;
            }
            if (value instanceof Serializable) {
                this.writeObjectStart(actualType, knownType);
                ((Serializable)value).write(this);
                this.writeObjectEnd();
                return;
            }
            Serializer serializer = this.classToSerializer.get(actualType);
            if (serializer != null) {
                serializer.write(this, value, knownType);
                return;
            }
            if (value instanceof Array) {
                if (knownType != null && actualType != knownType) {
                    throw new SerializationException("Serialization of an Array other than the known type is not supported.\nKnown type: " + knownType + "\nActual type: " + actualType);
                }
                this.writeArrayStart();
                Array array = (Array)value;
                int n = array.size;
                for (int i = 0; i < n; ++i) {
                    this.writeValue(array.get(i), elementType, null);
                }
                this.writeArrayEnd();
                return;
            }
            if (value instanceof Collection) {
                if (knownType != null && actualType != knownType) {
                    throw new SerializationException("Serialization of a Collection other than the known type is not supported.\nKnown type: " + knownType + "\nActual type: " + actualType);
                }
                this.writeArrayStart();
                for (Object item : (Collection)value) {
                    this.writeValue(item, elementType, null);
                }
                this.writeArrayEnd();
                return;
            }
            if (actualType.isArray()) {
                if (elementType == null) {
                    elementType = actualType.getComponentType();
                }
                int length = java.lang.reflect.Array.getLength(value);
                this.writeArrayStart();
                for (int i = 0; i < length; ++i) {
                    this.writeValue(java.lang.reflect.Array.get(value, i), elementType, null);
                }
                this.writeArrayEnd();
                return;
            }
            if (value instanceof ObjectMap) {
                if (knownType == null) {
                    knownType = ObjectMap.class;
                }
                this.writeObjectStart(actualType, knownType);
                for (ObjectMap.Entry entry : ((ObjectMap)value).entries()) {
                    this.writer.name(this.convertToString(entry.key));
                    this.writeValue(entry.value, elementType, null);
                }
                this.writeObjectEnd();
                return;
            }
            if (value instanceof Map) {
                if (knownType == null) {
                    knownType = ObjectMap.class;
                }
                this.writeObjectStart(actualType, knownType);
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    this.writer.name(this.convertToString(entry.getKey()));
                    this.writeValue(entry.getValue(), elementType, null);
                }
                this.writeObjectEnd();
                return;
            }
            if (actualType.isEnum()) {
                this.writer.value(value);
                return;
            }
            this.writeObjectStart(actualType, knownType);
            this.writeFields(value);
            this.writeObjectEnd();
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
    }

    public void writeObjectStart(String name) {
        try {
            this.writer.name(name);
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
        this.writeObjectStart();
    }

    public void writeObjectStart(String name, Class actualType, Class knownType) {
        try {
            this.writer.name(name);
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
        this.writeObjectStart(actualType, knownType);
    }

    public void writeObjectStart() {
        try {
            this.writer.object();
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
    }

    public void writeObjectStart(Class actualType, Class knownType) {
        try {
            this.writer.object();
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
        if (knownType == null || knownType != actualType) {
            this.writeType(actualType);
        }
    }

    public void writeObjectEnd() {
        try {
            this.writer.pop();
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
    }

    public void writeArrayStart(String name) {
        try {
            this.writer.name(name);
            this.writer.array();
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
    }

    public void writeArrayStart() {
        try {
            this.writer.array();
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
    }

    public void writeArrayEnd() {
        try {
            this.writer.pop();
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
    }

    public void writeType(Class type) {
        if (this.typeName == null) {
            return;
        }
        String className = this.classToTag.get(type);
        if (className == null) {
            className = type.getName();
        }
        try {
            this.writer.set(this.typeName, className);
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
    }

    public <T> T fromJson(Class<T> type, Reader reader) {
        return this.readValue(type, null, new JsonReader().parse(reader));
    }

    public <T> T fromJson(Class<T> type, Class elementType, Reader reader) {
        return this.readValue(type, elementType, new JsonReader().parse(reader));
    }

    public <T> T fromJson(Class<T> type, InputStream input) {
        return this.readValue(type, null, new JsonReader().parse(input));
    }

    public <T> T fromJson(Class<T> type, Class elementType, InputStream input) {
        return this.readValue(type, elementType, new JsonReader().parse(input));
    }

    public <T> T fromJson(Class<T> type, FileHandle file) {
        try {
            return this.readValue(type, null, new JsonReader().parse(file));
        }
        catch (Exception ex) {
            throw new SerializationException("Error reading file: " + file, ex);
        }
    }

    public <T> T fromJson(Class<T> type, Class elementType, FileHandle file) {
        try {
            return this.readValue(type, elementType, new JsonReader().parse(file));
        }
        catch (Exception ex) {
            throw new SerializationException("Error reading file: " + file, ex);
        }
    }

    public <T> T fromJson(Class<T> type, char[] data, int offset, int length) {
        return this.readValue(type, null, new JsonReader().parse(data, offset, length));
    }

    public <T> T fromJson(Class<T> type, Class elementType, char[] data, int offset, int length) {
        return this.readValue(type, elementType, new JsonReader().parse(data, offset, length));
    }

    public <T> T fromJson(Class<T> type, String json) {
        return this.readValue(type, null, new JsonReader().parse(json));
    }

    public <T> T fromJson(Class<T> type, Class elementType, String json) {
        return this.readValue(type, elementType, new JsonReader().parse(json));
    }

    public void readField(Object object, String name, Object jsonData) {
        this.readField(object, name, name, null, jsonData);
    }

    public void readField(Object object, String name, Class elementType, Object jsonData) {
        this.readField(object, name, name, elementType, jsonData);
    }

    public void readField(Object object, String fieldName, String jsonName, Object jsonData) {
        this.readField(object, fieldName, jsonName, null, jsonData);
    }

    public void readField(Object object, String fieldName, String jsonName, Class elementType, Object jsonData) {
        FieldMetadata metadata;
        ObjectMap jsonMap = (ObjectMap)jsonData;
        Class<?> type = object.getClass();
        ObjectMap<String, FieldMetadata> fields = this.typeToFields.get(type);
        if (fields == null) {
            fields = this.cacheFields(type);
        }
        if ((metadata = fields.get(fieldName)) == null) {
            throw new SerializationException("Field not found: " + fieldName + " (" + type.getName() + ")");
        }
        Field field = metadata.field;
        Object jsonValue = jsonMap.get(jsonName);
        if (jsonValue == null) {
            return;
        }
        if (elementType == null) {
            elementType = metadata.elementType;
        }
        try {
            field.set(object, this.readValue(field.getType(), elementType, jsonValue));
        }
        catch (IllegalAccessException ex) {
            throw new SerializationException("Error accessing field: " + field.getName() + " (" + type.getName() + ")", ex);
        }
        catch (SerializationException ex) {
            ex.addTrace(field.getName() + " (" + type.getName() + ")");
            throw ex;
        }
        catch (RuntimeException runtimeEx) {
            SerializationException ex = new SerializationException(runtimeEx);
            ex.addTrace(field.getName() + " (" + type.getName() + ")");
            throw ex;
        }
    }

    public void readFields(Object object, Object jsonData) {
        ObjectMap jsonMap = (ObjectMap)jsonData;
        Class<?> type = object.getClass();
        ObjectMap<String, FieldMetadata> fields = this.typeToFields.get(type);
        if (fields == null) {
            fields = this.cacheFields(type);
        }
        for (ObjectMap.Entry entry : jsonMap.entries()) {
            FieldMetadata metadata = fields.get((String)entry.key);
            if (!this.ignoreUnknownFields && metadata == null) {
                throw new SerializationException("Field not found: " + (String)entry.key + " (" + type.getName() + ")");
            }
            Field field = metadata.field;
            if (entry.value == null) continue;
            try {
                field.set(object, this.readValue(field.getType(), metadata.elementType, entry.value));
            }
            catch (IllegalAccessException ex) {
                throw new SerializationException("Error accessing field: " + field.getName() + " (" + type.getName() + ")", ex);
            }
            catch (SerializationException ex) {
                ex.addTrace(field.getName() + " (" + type.getName() + ")");
                throw ex;
            }
            catch (RuntimeException runtimeEx) {
                SerializationException ex = new SerializationException(runtimeEx);
                ex.addTrace(field.getName() + " (" + type.getName() + ")");
                throw ex;
            }
        }
    }

    public <T> T readValue(String name, Class<T> type, Object jsonData) {
        ObjectMap jsonMap = (ObjectMap)jsonData;
        return this.readValue(type, null, jsonMap.get(name));
    }

    public <T> T readValue(String name, Class<T> type, T defaultValue, Object jsonData) {
        ObjectMap jsonMap = (ObjectMap)jsonData;
        Object jsonValue = jsonMap.get(name);
        if (jsonValue == null) {
            return defaultValue;
        }
        return this.readValue(type, null, jsonValue);
    }

    public <T> T readValue(String name, Class<T> type, Class elementType, Object jsonData) {
        ObjectMap jsonMap = (ObjectMap)jsonData;
        return this.readValue(type, elementType, jsonMap.get(name));
    }

    public <T> T readValue(String name, Class<T> type, Class elementType, T defaultValue, Object jsonData) {
        ObjectMap jsonMap = (ObjectMap)jsonData;
        Object jsonValue = jsonMap.get(name);
        if (jsonValue == null) {
            return defaultValue;
        }
        return this.readValue(type, elementType, jsonValue);
    }

    public <T> T readValue(Class<T> type, Class elementType, T defaultValue, Object jsonData) {
        return this.readValue(type, elementType, jsonData);
    }

    public <T> T readValue(Class<T> type, Object jsonData) {
        return this.readValue(type, null, jsonData);
    }

    public <T> T readValue(Class<T> type, Class elementType, Object jsonData) {
        Serializer serializer;
        if (jsonData instanceof ObjectMap) {
            Object object;
            ObjectMap jsonMap;
            block46: {
                String className;
                jsonMap = (ObjectMap)jsonData;
                String string = className = this.typeName == null ? null : (String)jsonMap.remove(this.typeName);
                if (className != null) {
                    try {
                        type = Class.forName(className);
                    }
                    catch (ClassNotFoundException ex) {
                        type = this.tagToClass.get(className);
                        if (type != null) break block46;
                        throw new SerializationException(ex);
                    }
                }
            }
            if (type != null) {
                Serializer serializer2 = this.classToSerializer.get(type);
                if (serializer2 != null) {
                    return serializer2.read(this, jsonMap, type);
                }
                object = this.newInstance(type);
                if (object instanceof Serializable) {
                    ((Serializable)object).read(this, jsonMap);
                    return (T)object;
                }
                if (object instanceof HashMap) {
                    HashMap result = (HashMap)object;
                    for (ObjectMap.Entry entry : jsonMap.entries()) {
                        result.put(entry.key, this.readValue(elementType, null, entry.value));
                    }
                    return (T)result;
                }
            } else {
                object = new ObjectMap();
            }
            if (object instanceof ObjectMap) {
                ObjectMap result = object;
                for (ObjectMap.Entry entry : jsonMap.entries()) {
                    result.put(entry.key, this.readValue(elementType, null, entry.value));
                }
                return (T)result;
            }
            this.readFields(object, jsonMap);
            return (T)object;
        }
        if (type != null && (serializer = this.classToSerializer.get(type)) != null) {
            return serializer.read(this, jsonData, type);
        }
        if (jsonData instanceof Array) {
            Array array = (Array)jsonData;
            if (type == null || type.isAssignableFrom(Array.class)) {
                Array newArray = new Array(array.size);
                int n = array.size;
                for (int i = 0; i < n; ++i) {
                    newArray.add(this.readValue(elementType, null, array.get(i)));
                }
                return (T)newArray;
            }
            if (type.isAssignableFrom(ArrayList.class)) {
                ArrayList newArray = new ArrayList(array.size);
                int n = array.size;
                for (int i = 0; i < n; ++i) {
                    newArray.add(this.readValue(elementType, null, array.get(i)));
                }
                return (T)newArray;
            }
            if (type.isArray()) {
                Class<?> componentType = type.getComponentType();
                if (elementType == null) {
                    elementType = componentType;
                }
                Object newArray = java.lang.reflect.Array.newInstance(componentType, array.size);
                int n = array.size;
                for (int i = 0; i < n; ++i) {
                    java.lang.reflect.Array.set(newArray, i, this.readValue(elementType, null, array.get(i)));
                }
                return (T)newArray;
            }
            throw new SerializationException("Unable to convert value to required type: " + jsonData + " (" + type.getName() + ")");
        }
        if (jsonData instanceof Float) {
            Float floatValue = (Float)jsonData;
            try {
                if (type == null || type == Float.TYPE || type == Float.class) {
                    return (T)floatValue;
                }
                if (type == Integer.TYPE || type == Integer.class) {
                    return (T)Integer.valueOf(floatValue.intValue());
                }
                if (type == Long.TYPE || type == Long.class) {
                    return (T)Long.valueOf(floatValue.longValue());
                }
                if (type == Double.TYPE || type == Double.class) {
                    return (T)Double.valueOf(floatValue.doubleValue());
                }
                if (type == Short.TYPE || type == Short.class) {
                    return (T)Short.valueOf(floatValue.shortValue());
                }
                if (type == Byte.TYPE || type == Byte.class) {
                    return (T)Byte.valueOf(floatValue.byteValue());
                }
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
            jsonData = String.valueOf(jsonData);
        }
        if (jsonData instanceof Boolean) {
            jsonData = String.valueOf(jsonData);
        }
        if (jsonData instanceof String) {
            String string = (String)jsonData;
            if (type == null || type == String.class) {
                return (T)jsonData;
            }
            try {
                if (type == Integer.TYPE || type == Integer.class) {
                    return (T)Integer.valueOf(string);
                }
                if (type == Float.TYPE || type == Float.class) {
                    return (T)Float.valueOf(string);
                }
                if (type == Long.TYPE || type == Long.class) {
                    return (T)Long.valueOf(string);
                }
                if (type == Double.TYPE || type == Double.class) {
                    return (T)Double.valueOf(string);
                }
                if (type == Short.TYPE || type == Short.class) {
                    return (T)Short.valueOf(string);
                }
                if (type == Byte.TYPE || type == Byte.class) {
                    return (T)Byte.valueOf(string);
                }
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
            if (type == Boolean.TYPE || type == Boolean.class) {
                return (T)Boolean.valueOf(string);
            }
            if (type == Character.TYPE || type == Character.class) {
                return (T)Character.valueOf(string.charAt(0));
            }
            if (type.isEnum()) {
                Object[] constants = type.getEnumConstants();
                int n = constants.length;
                for (int i = 0; i < n; ++i) {
                    if (!string.equals(constants[i].toString())) continue;
                    return (T)constants[i];
                }
            }
            if (type == CharSequence.class) {
                return (T)string;
            }
            throw new SerializationException("Unable to convert value to required type: " + jsonData + " (" + type.getName() + ")");
        }
        return null;
    }

    private String convertToString(Object object) {
        if (object instanceof Class) {
            return ((Class)object).getName();
        }
        return String.valueOf(object);
    }

    private Object newInstance(Class type) {
        try {
            return type.newInstance();
        }
        catch (Exception ex) {
            try {
                Constructor constructor = type.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return constructor.newInstance(new Object[0]);
            }
            catch (SecurityException ignored) {
            }
            catch (NoSuchMethodException ignored) {
                if (type.isMemberClass() && !Modifier.isStatic(type.getModifiers())) {
                    throw new SerializationException("Class cannot be created (non-static member class): " + type.getName(), ex);
                }
                throw new SerializationException("Class cannot be created (missing no-arg constructor): " + type.getName(), ex);
            }
            catch (Exception privateConstructorException) {
                ex = privateConstructorException;
            }
            throw new SerializationException("Error constructing instance of class: " + type.getName(), ex);
        }
    }

    public String prettyPrint(Object object) {
        return this.prettyPrint(object, false);
    }

    public String prettyPrint(String json) {
        return this.prettyPrint(json, false);
    }

    public String prettyPrint(Object object, boolean fieldsOnSameLine) {
        return this.prettyPrint(this.toJson(object), fieldsOnSameLine);
    }

    public String prettyPrint(String json, boolean fieldsOnSameLine) {
        StringBuilder buffer = new StringBuilder(512);
        this.prettyPrint(new JsonReader().parse(json), buffer, 0, fieldsOnSameLine);
        return buffer.toString();
    }

    private void prettyPrint(Object object, StringBuilder buffer, int indent, boolean fieldsOnSameLine) {
        if (object instanceof ObjectMap) {
            ObjectMap map = (ObjectMap)object;
            if (map.size == 0) {
                buffer.append("{}");
            } else {
                boolean newLines = !fieldsOnSameLine || !Json.isFlat(map);
                buffer.append(newLines ? "{\n" : "{ ");
                int i = 0;
                for (ObjectMap.Entry entry : map.entries()) {
                    if (newLines) {
                        Json.indent(indent, buffer);
                    }
                    buffer.append(this.outputType.quoteName((String)entry.key));
                    buffer.append(": ");
                    this.prettyPrint(entry.value, buffer, indent + 1, fieldsOnSameLine);
                    if (i++ < map.size - 1) {
                        buffer.append(",");
                    }
                    buffer.append(newLines ? (char)'\n' : ' ');
                }
                if (newLines) {
                    Json.indent(indent - 1, buffer);
                }
                buffer.append('}');
            }
        } else if (object instanceof Array) {
            Array array = (Array)object;
            if (array.size == 0) {
                buffer.append("[]");
            } else {
                boolean newLines = !fieldsOnSameLine || !Json.isFlat(array);
                buffer.append(newLines ? "[\n" : "[ ");
                int n = array.size;
                for (int i = 0; i < n; ++i) {
                    if (newLines) {
                        Json.indent(indent, buffer);
                    }
                    this.prettyPrint(array.get(i), buffer, indent + 1, fieldsOnSameLine);
                    if (i < array.size - 1) {
                        buffer.append(",");
                    }
                    buffer.append(newLines ? (char)'\n' : ' ');
                }
                if (newLines) {
                    Json.indent(indent - 1, buffer);
                }
                buffer.append(']');
            }
        } else if (object instanceof String) {
            buffer.append(this.outputType.quoteValue((String)object));
        } else if (object instanceof Float) {
            Float floatValue = (Float)object;
            int intValue = floatValue.intValue();
            buffer.append(floatValue.floatValue() - (float)intValue == 0.0f ? Integer.valueOf(intValue) : object);
        } else if (object instanceof Boolean) {
            buffer.append(object);
        } else if (object == null) {
            buffer.append("null");
        } else {
            throw new SerializationException("Unknown object type: " + object.getClass());
        }
    }

    private static boolean isFlat(ObjectMap<?, ?> map) {
        for (ObjectMap.Entry<?, ?> entry : map.entries()) {
            if (entry.value instanceof ObjectMap) {
                return false;
            }
            if (!(entry.value instanceof Array)) continue;
            return false;
        }
        return true;
    }

    private static boolean isFlat(Array array) {
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            Object value = array.get(i);
            if (value instanceof ObjectMap) {
                return false;
            }
            if (!(value instanceof Array)) continue;
            return false;
        }
        return true;
    }

    private static void indent(int count, StringBuilder buffer) {
        for (int i = 0; i < count; ++i) {
            buffer.append('\t');
        }
    }

    public static interface Serializable {
        public void write(Json var1);

        public void read(Json var1, ObjectMap<String, Object> var2);
    }

    public static interface Serializer<T> {
        public void write(Json var1, T var2, Class var3);

        public T read(Json var1, Object var2, Class var3);
    }

    private static class FieldMetadata {
        public Field field;
        public Class elementType;

        public FieldMetadata(Field field) {
            this.field = field;
        }
    }
}

