/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui.utils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;

public class ScissorStack {
    private static Array<Rectangle> scissors = new Array();
    static Vector3 tmp = new Vector3();
    static final Rectangle viewport = new Rectangle();

    public static void pushScissors(Rectangle scissor) {
        ScissorStack.fix(scissor);
        if (ScissorStack.scissors.size == 0) {
            Gdx.gl.glEnable(3089);
        } else {
            Rectangle parent = scissors.get(ScissorStack.scissors.size - 1);
            float minX = Math.max(parent.x, scissor.x);
            float maxX = Math.min(parent.x + parent.width, scissor.x + scissor.width);
            scissor.x = minX;
            scissor.width = Math.max(1.0f, maxX - minX);
            float minY = Math.max(parent.y, scissor.y);
            float maxY = Math.min(parent.y + parent.height, scissor.y + scissor.height);
            scissor.y = minY;
            scissor.height = Math.max(1.0f, maxY - minY);
        }
        scissors.add(scissor);
        Gdx.gl.glScissor((int)scissor.x, (int)scissor.y, (int)scissor.width, (int)scissor.height);
    }

    public static void popScissors() {
        scissors.pop();
        if (ScissorStack.scissors.size == 0) {
            Gdx.gl.glDisable(3089);
        } else {
            Rectangle scissor = scissors.peek();
            Gdx.gl.glScissor((int)scissor.x, (int)scissor.y, (int)scissor.width, (int)scissor.height);
        }
    }

    private static void fix(Rectangle rect) {
        if (rect.width < 0.0f) {
            rect.width = -rect.width;
            rect.x -= rect.width;
        }
        if (rect.height < 0.0f) {
            rect.height = -rect.height;
            rect.y -= rect.height;
        }
    }

    public static void calculateScissors(Camera camera, Matrix4 batchTransform, Rectangle area, Rectangle scissor) {
        tmp.set(area.x, area.y, 0.0f);
        tmp.mul(batchTransform);
        camera.project(tmp);
        scissor.x = ScissorStack.tmp.x;
        scissor.y = ScissorStack.tmp.y;
        tmp.set(area.x + area.width, area.y + area.height, 0.0f);
        tmp.mul(batchTransform);
        camera.project(tmp);
        scissor.width = ScissorStack.tmp.x - scissor.x;
        scissor.height = ScissorStack.tmp.y - scissor.y;
    }

    public static Rectangle getViewport() {
        if (ScissorStack.scissors.size == 0) {
            viewport.set(0.0f, 0.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
            return viewport;
        }
        Rectangle scissor = scissors.peek();
        viewport.set(scissor);
        return viewport;
    }

    public static void toWindowCoordinates(Camera camera, Matrix4 transformMatrix, Vector2 point) {
        tmp.set(point.x, point.y, 0.0f);
        tmp.mul(transformMatrix);
        camera.project(tmp);
        ScissorStack.tmp.y = (float)Gdx.graphics.getHeight() - ScissorStack.tmp.y;
        point.x = ScissorStack.tmp.x;
        point.y = ScissorStack.tmp.y;
    }
}

