/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui.tablelayout;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.glutils.ImmediateModeRenderer;
import com.badlogic.gdx.graphics.glutils.ImmediateModeRenderer10;
import com.badlogic.gdx.graphics.glutils.ImmediateModeRenderer20;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Layout;
import com.badlogic.gdx.scenes.scene2d.actors.Image;
import com.badlogic.gdx.scenes.scene2d.ui.tablelayout.LibgdxToolkit;
import com.badlogic.gdx.scenes.scene2d.ui.tablelayout.Table;
import com.badlogic.gdx.utils.Array;
import com.esotericsoftware.tablelayout.BaseTableLayout;
import com.esotericsoftware.tablelayout.Cell;
import java.util.List;

public class TableLayout
extends BaseTableLayout<Actor, Table, TableLayout, LibgdxToolkit> {
    public TextureAtlas atlas;
    boolean needsLayout = true;
    Array<LibgdxToolkit.DebugRect> debugRects;
    private ImmediateModeRenderer debugRenderer;

    public TableLayout() {
        super(LibgdxToolkit.instance);
    }

    public TableLayout(LibgdxToolkit toolkit) {
        super(toolkit);
    }

    public Actor register(Actor actor) {
        if (actor.name == null) {
            throw new IllegalArgumentException("Actor must have a name: " + actor.getClass());
        }
        return this.register(actor.name, actor);
    }

    public Actor registerImage(String name) {
        return this.register(new Image(name, this.atlas.findRegion(name)));
    }

    @Override
    public Actor getWidget(String name) {
        Actor actor = (Actor)super.getWidget(name);
        if (actor == null) {
            actor = ((Table)this.getTable()).findActor(name);
        }
        return actor;
    }

    @Override
    public void layout() {
        if (!this.needsLayout) {
            return;
        }
        this.needsLayout = false;
        Table table = (Table)this.getTable();
        this.setLayoutSize(0, 0, (int)table.width, (int)table.height);
        super.layout();
        List<Cell> cells = this.getCells();
        int n = cells.size();
        for (int i = 0; i < n; ++i) {
            Cell c = cells.get(i);
            if (c.getIgnore()) continue;
            Actor actor = (Actor)c.getWidget();
            actor.x = c.getWidgetX();
            int widgetHeight = c.getWidgetHeight();
            actor.y = table.height - (float)c.getWidgetY() - (float)widgetHeight;
            actor.width = c.getWidgetWidth();
            actor.height = widgetHeight;
            if (!(actor instanceof Layout)) continue;
            Layout layout = (Layout)((Object)actor);
            layout.invalidate();
            layout.layout();
        }
    }

    @Override
    public void invalidate() {
        this.needsLayout = true;
        ((Table)this.getTable()).sizeInvalid = true;
    }

    @Override
    public void invalidateHierarchy() {
        this.invalidate();
        Group parent = ((Table)this.getTable()).parent;
        while (parent != null) {
            if (parent instanceof Layout) {
                ((Layout)((Object)parent)).invalidate();
            }
            parent = parent.parent;
        }
    }

    public void drawDebug(SpriteBatch batch) {
        if (this.getDebug() == 0 || this.debugRects == null) {
            return;
        }
        if (this.debugRenderer == null) {
            this.debugRenderer = Gdx.graphics.isGL20Available() ? new ImmediateModeRenderer20(64, false, true, 0) : new ImmediateModeRenderer10(64);
        }
        Table table = (Table)this.getTable();
        Group parent = table.parent;
        float x = table.x;
        float y = 0.0f;
        while (parent != null) {
            if (parent instanceof Group) {
                x += parent.x;
                y += parent.y;
            }
            parent = parent.parent;
        }
        y = table.y + table.height - y;
        int viewHeight = Gdx.graphics.getHeight();
        this.debugRenderer.begin(batch.getProjectionMatrix(), 1);
        int n = this.debugRects.size;
        for (int i = 0; i < n; ++i) {
            LibgdxToolkit.DebugRect rect = this.debugRects.get(i);
            float x1 = x + rect.x;
            float y1 = y - rect.y - rect.height;
            float x2 = x1 + rect.width;
            float y2 = y1 + rect.height;
            float r = (rect.type & 4) != 0 ? 1.0f : 0.0f;
            float g = (rect.type & 8) != 0 ? 1.0f : 0.0f;
            float b = (rect.type & 2) != 0 ? 1.0f : 0.0f;
            this.debugRenderer.color(r, g, b, 1.0f);
            this.debugRenderer.vertex(x1, y1, 0.0f);
            this.debugRenderer.color(r, g, b, 1.0f);
            this.debugRenderer.vertex(x1, y2, 0.0f);
            this.debugRenderer.color(r, g, b, 1.0f);
            this.debugRenderer.vertex(x1, y2, 0.0f);
            this.debugRenderer.color(r, g, b, 1.0f);
            this.debugRenderer.vertex(x2, y2, 0.0f);
            this.debugRenderer.color(r, g, b, 1.0f);
            this.debugRenderer.vertex(x2, y2, 0.0f);
            this.debugRenderer.color(r, g, b, 1.0f);
            this.debugRenderer.vertex(x2, y1, 0.0f);
            this.debugRenderer.color(r, g, b, 1.0f);
            this.debugRenderer.vertex(x2, y1, 0.0f);
            this.debugRenderer.color(r, g, b, 1.0f);
            this.debugRenderer.vertex(x1, y1, 0.0f);
            if (this.debugRenderer.getNumVertices() != 64) continue;
            this.debugRenderer.end();
            this.debugRenderer.begin(batch.getProjectionMatrix(), 1);
        }
        this.debugRenderer.end();
    }
}

