/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui.tablelayout;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Layout;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.ClickListener;
import com.badlogic.gdx.scenes.scene2d.ui.tablelayout.TableLayout;
import com.badlogic.gdx.scenes.scene2d.ui.utils.ScissorStack;
import com.esotericsoftware.tablelayout.Cell;
import java.util.List;

public class Table
extends Group
implements Layout {
    private final TableLayout layout;
    boolean sizeInvalid = true;
    private ClickListener listener;
    NinePatch backgroundPatch;
    private Stage stage;
    private final Rectangle tableBounds = new Rectangle();
    private final Rectangle scissors = new Rectangle();
    public boolean isPressed;

    public Table() {
        this(new TableLayout(), null);
    }

    public Table(TableLayout layout) {
        this(layout, null);
    }

    public Table(String name) {
        this(new TableLayout(), name);
    }

    public Table(TableLayout layout, String name) {
        super(name);
        this.transform = false;
        this.layout = layout;
        layout.setTable(this);
    }

    @Override
    public void draw(SpriteBatch batch, float parentAlpha) {
        if (!this.visible) {
            return;
        }
        if (this.layout.needsLayout) {
            this.layout.layout();
        }
        batch.setColor(this.color.r, this.color.g, this.color.b, this.color.a * parentAlpha);
        if (this.backgroundPatch != null) {
            this.backgroundPatch.draw(batch, this.x, this.y, this.width, this.height);
        }
        if (this.stage != null) {
            this.applyTransform(batch);
            this.calculateScissors(batch.getTransformMatrix());
            ScissorStack.pushScissors(this.scissors);
            super.drawChildren(batch, parentAlpha);
            this.resetTransform(batch);
            ScissorStack.popScissors();
        } else {
            super.draw(batch, parentAlpha);
        }
    }

    private void calculateScissors(Matrix4 transform) {
        this.tableBounds.x = 0.0f;
        this.tableBounds.y = 0.0f;
        this.tableBounds.width = this.width;
        this.tableBounds.height = this.height;
        if (this.backgroundPatch != null) {
            this.tableBounds.x += this.backgroundPatch.getLeftWidth();
            this.tableBounds.y += this.backgroundPatch.getBottomHeight();
            this.tableBounds.width -= this.backgroundPatch.getLeftWidth() + this.backgroundPatch.getRightWidth();
            this.tableBounds.height -= this.backgroundPatch.getTopHeight() + this.backgroundPatch.getBottomHeight();
        }
        ScissorStack.calculateScissors(this.stage.getCamera(), transform, this.tableBounds, this.scissors);
    }

    private void computeSize() {
        if (!this.sizeInvalid) {
            return;
        }
        this.layout.setLayoutSize(0, 0, 0, 0);
        this.layout.invalidate();
        this.layout.layout();
        this.layout.invalidate();
        this.sizeInvalid = false;
    }

    @Override
    public float getPrefWidth() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.layout.getPrefWidth();
    }

    @Override
    public float getPrefHeight() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.layout.getPrefHeight();
    }

    @Override
    public float getMinWidth() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.layout.getMinWidth();
    }

    @Override
    public float getMinHeight() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.layout.getMinHeight();
    }

    @Override
    public float getMaxWidth() {
        return 0.0f;
    }

    @Override
    public float getMaxHeight() {
        return 0.0f;
    }

    public void setBackground(NinePatch background) {
        this.backgroundPatch = background;
        if (background != null) {
            this.padBottom((int)background.getBottomHeight() + 1);
            this.padTop((int)background.getTopHeight() + 1);
            this.padLeft((int)background.getLeftWidth() + 1);
            this.padRight((int)background.getRightWidth() + 1);
        }
    }

    public void enableClipping(Stage stage) {
        this.stage = stage;
        this.transform = true;
        this.invalidate();
    }

    public void setClickListener(ClickListener listener) {
        this.listener = listener;
    }

    @Override
    public boolean touchDown(float x, float y, int pointer) {
        if (super.touchDown(x, y, pointer)) {
            return true;
        }
        if (pointer != 0) {
            return false;
        }
        if (this.listener == null) {
            return false;
        }
        this.isPressed = true;
        return true;
    }

    @Override
    public void touchUp(float x, float y, int pointer) {
        if (this.hit(x, y) != null) {
            this.click();
        }
        this.isPressed = false;
    }

    public void click() {
        if (this.listener != null) {
            this.listener.click(this);
        }
    }

    @Override
    public Actor hit(float x, float y) {
        Actor child = super.hit(x, y);
        if (child != null) {
            return child;
        }
        return x > 0.0f && x < this.width && y > 0.0f && y < this.height ? this : null;
    }

    public TableLayout getTableLayout() {
        return this.layout;
    }

    @Override
    public void clear() {
        super.clear();
        this.layout.clear();
    }

    public Actor register(String name, Actor widget) {
        return this.layout.register(name, widget);
    }

    public Cell add(Actor actor) {
        return this.layout.add(actor);
    }

    public Cell stack(Actor ... actor) {
        return this.layout.stack(actor);
    }

    public Cell row() {
        return this.layout.row();
    }

    public void parse(FileHandle tableDescriptionFile) {
        this.layout.parse(tableDescriptionFile.readString());
    }

    public void parse(String tableDescription) {
        this.layout.parse(tableDescription);
    }

    public Cell columnDefaults(int column) {
        return this.layout.columnDefaults(column);
    }

    public Cell defaults() {
        return this.layout.defaults();
    }

    @Override
    public void layout() {
        this.layout.layout();
    }

    @Override
    public void invalidate() {
        this.layout.invalidate();
    }

    public void invalidateHierarchy() {
        this.layout.invalidateHierarchy();
    }

    public void reset() {
        this.layout.reset();
    }

    public Actor getWidget(String name) {
        return this.layout.getWidget(name);
    }

    public List<Actor> getWidgets() {
        return this.layout.getWidgets();
    }

    public List<Actor> getWidgets(String namePrefix) {
        return this.layout.getWidgets(namePrefix);
    }

    public Cell getCell(Actor actor) {
        return this.layout.getCell(actor);
    }

    public Cell getCell(String name) {
        return this.layout.getCell(name);
    }

    public List<Cell> getAllCells() {
        return this.layout.getAllCells();
    }

    public List<Cell> getAllCells(String namePrefix) {
        return this.layout.getAllCells(namePrefix);
    }

    public List<Cell> getCells() {
        return this.layout.getCells();
    }

    public void setActor(String name, Actor actor) {
        this.layout.setWidget(name, actor);
    }

    public Table size(String width, String height) {
        this.layout.size(width, height);
        return this;
    }

    public Table width(String width) {
        this.layout.width(width);
        return this;
    }

    public Table height(String height) {
        this.layout.height(height);
        return this;
    }

    public Table size(int width, int height) {
        this.layout.size(width, height);
        return this;
    }

    public Table width(int width) {
        this.layout.width(width);
        return this;
    }

    public Table height(int height) {
        this.layout.height(height);
        return this;
    }

    public Table pad(String pad) {
        this.layout.pad(pad);
        return this;
    }

    public Table pad(String top, String left, String bottom, String right) {
        this.layout.pad(top, left, bottom, right);
        return this;
    }

    public Table padTop(String padTop) {
        this.layout.padTop(padTop);
        return this;
    }

    public Table padLeft(String padLeft) {
        this.layout.padLeft(padLeft);
        return this;
    }

    public Table padBottom(String padBottom) {
        this.layout.padBottom(padBottom);
        return this;
    }

    public Table padRight(String padRight) {
        this.layout.padRight(padRight);
        return this;
    }

    public Table pad(int pad) {
        this.layout.pad(pad);
        return this;
    }

    public Table pad(int top, int left, int bottom, int right) {
        this.layout.pad(top, left, bottom, right);
        return this;
    }

    public Table padTop(int padTop) {
        this.layout.padTop(padTop);
        return this;
    }

    public Table padLeft(int padLeft) {
        this.layout.padLeft(padLeft);
        return this;
    }

    public Table padBottom(int padBottom) {
        this.layout.padBottom(padBottom);
        return this;
    }

    public Table padRight(int padRight) {
        this.layout.padRight(padRight);
        return this;
    }

    public Table align(int align) {
        this.layout.align(align);
        return this;
    }

    public Table align(String value) {
        this.layout.align(value);
        return this;
    }

    public Table center() {
        this.layout.center();
        return this;
    }

    public Table top() {
        this.layout.top();
        return this;
    }

    public Table left() {
        this.layout.left();
        return this;
    }

    public Table bottom() {
        this.layout.bottom();
        return this;
    }

    public Table right() {
        this.layout.right();
        return this;
    }

    public Table debug() {
        this.layout.debug();
        return this;
    }

    public Table debug(int debug) {
        this.layout.debug(debug);
        return this;
    }

    public Table debug(String value) {
        this.layout.debug(value);
        return this;
    }

    public int getDebug() {
        return this.layout.getDebug();
    }

    public String getHeight() {
        return this.layout.getHeight();
    }

    public String getPadTop() {
        return this.layout.getPadTop();
    }

    public String getPadLeft() {
        return this.layout.getPadLeft();
    }

    public String getPadBottom() {
        return this.layout.getPadBottom();
    }

    public String getPadRight() {
        return this.layout.getPadRight();
    }

    public int getAlign() {
        return this.layout.getAlign();
    }

    public static void drawDebug(Stage stage) {
        Table.drawDebug(stage.getActors(), stage.getSpriteBatch());
    }

    private static void drawDebug(List<Actor> actors, SpriteBatch batch) {
        int n = actors.size();
        for (int i = 0; i < n; ++i) {
            Actor actor = actors.get(i);
            if (actor instanceof Table) {
                ((Table)actor).layout.drawDebug(batch);
            }
            if (!(actor instanceof Group)) continue;
            Table.drawDebug(((Group)actor).getActors(), batch);
        }
    }
}

