/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui.tablelayout;

import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Layout;
import com.badlogic.gdx.scenes.scene2d.actors.Image;
import com.badlogic.gdx.scenes.scene2d.actors.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.tablelayout.Table;
import com.badlogic.gdx.scenes.scene2d.ui.tablelayout.TableLayout;
import com.badlogic.gdx.utils.Array;
import com.esotericsoftware.tablelayout.Toolkit;
import java.util.HashMap;
import java.util.List;

public class LibgdxToolkit
extends Toolkit<Actor, Table, TableLayout> {
    public static LibgdxToolkit instance;
    public static BitmapFont defaultFont;
    private static HashMap<String, BitmapFont> fonts;

    @Override
    public Actor wrap(Object object) {
        if (object instanceof String) {
            if (defaultFont == null) {
                throw new IllegalStateException("No default font has been set.");
            }
            return new Label(null, defaultFont, (String)object);
        }
        if (object == null) {
            Group group = new Group();
            group.transform = false;
            return group;
        }
        return (Actor)super.wrap(object);
    }

    @Override
    public Actor newWidget(TableLayout layout, String className) {
        TextureAtlas.AtlasRegion region;
        if (layout.atlas != null && (region = layout.atlas.findRegion(className)) != null) {
            return new Image(className, region);
        }
        return (Actor)super.newWidget(layout, className);
    }

    @Override
    public TableLayout getLayout(Table table) {
        return table.getTableLayout();
    }

    @Override
    public Actor newStack() {
        return new Stack();
    }

    @Override
    public void setProperty(TableLayout layout, Actor object, String name, List<String> values) {
        if (object instanceof Label) {
            Label label = (Label)object;
            String value = values.get(0);
            if (name.equals("font")) {
                label.setFont(LibgdxToolkit.getFont(value));
                return;
            }
        }
        super.setProperty(layout, object, name, values);
    }

    @Override
    public void addChild(Actor parent, Actor child, String layoutString) {
        if (child.parent != null) {
            child.remove();
        }
        ((Group)parent).addActor(child);
    }

    @Override
    public void removeChild(Actor parent, Actor child) {
        ((Group)parent).removeActor(child);
    }

    @Override
    public int getMinWidth(Actor actor) {
        if (actor instanceof Layout) {
            return (int)((Layout)((Object)actor)).getMinWidth();
        }
        return (int)actor.width;
    }

    @Override
    public int getMinHeight(Actor actor) {
        if (actor instanceof Layout) {
            return (int)((Layout)((Object)actor)).getMinHeight();
        }
        return (int)actor.height;
    }

    @Override
    public int getPrefWidth(Actor actor) {
        if (actor instanceof Layout) {
            return (int)((Layout)((Object)actor)).getPrefWidth();
        }
        return (int)actor.width;
    }

    @Override
    public int getPrefHeight(Actor actor) {
        if (actor instanceof Layout) {
            return (int)((Layout)((Object)actor)).getPrefHeight();
        }
        return (int)actor.height;
    }

    @Override
    public int getMaxWidth(Actor actor) {
        if (actor instanceof Layout) {
            return (int)((Layout)((Object)actor)).getMaxWidth();
        }
        return 0;
    }

    @Override
    public int getMaxHeight(Actor actor) {
        if (actor instanceof Layout) {
            return (int)((Layout)((Object)actor)).getMaxHeight();
        }
        return 0;
    }

    @Override
    public void clearDebugRectangles(TableLayout layout) {
        if (layout.debugRects != null) {
            layout.debugRects.clear();
        }
    }

    @Override
    public void addDebugRectangle(TableLayout layout, int type, int x, int y, int w, int h) {
        if (layout.debugRects == null) {
            layout.debugRects = new Array();
        }
        layout.debugRects.add(new DebugRect(type, x, y, w, h));
    }

    public static void registerFont(String name, BitmapFont font) {
        fonts.put(name, font);
        if (defaultFont == null) {
            defaultFont = font;
        }
    }

    public static BitmapFont getFont(String name) {
        BitmapFont font = fonts.get(name);
        if (font == null) {
            throw new IllegalArgumentException("Font not found: " + name);
        }
        return font;
    }

    static {
        LibgdxToolkit.addClassPrefix("com.badlogic.gdx.scenes.scene2d.");
        LibgdxToolkit.addClassPrefix("com.badlogic.gdx.scenes.scene2d.ui.");
        LibgdxToolkit.addClassPrefix("com.badlogic.gdx.scenes.scene2d.actors.");
        instance = new LibgdxToolkit();
        fonts = new HashMap();
    }

    static class DebugRect
    extends Rectangle {
        final int type;

        public DebugRect(int type, int x, int y, int width, int height) {
            super(x, y, width, height);
            this.type = type;
        }
    }
}

