/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.tablelayout.Table;
import com.badlogic.gdx.scenes.scene2d.ui.tablelayout.TableLayout;
import com.badlogic.gdx.scenes.scene2d.ui.utils.ScissorStack;

public class Window
extends Table {
    WindowStyle style;
    String title;
    final Stage stage;
    final Rectangle widgetBounds = new Rectangle();
    final Rectangle titleBounds = new Rectangle();
    final BitmapFont.TextBounds textBounds = new BitmapFont.TextBounds();
    final Rectangle scissors = new Rectangle();
    boolean move = false;
    boolean isMovable = true;
    final Vector2 initial = new Vector2();
    boolean isModal = false;

    public Window(String title, Stage stage, Skin skin) {
        this(null, title, stage, skin.getStyle(WindowStyle.class), 0, 0);
    }

    public Window(String title, Stage stage, WindowStyle style) {
        this(null, title, stage, style, 0, 0);
    }

    public Window(String name, String title, Stage stage, WindowStyle style, int prefWidth, int prefHeight) {
        super(name);
        this.stage = stage;
        this.title = title;
        this.width = prefWidth;
        this.height = prefHeight;
        this.setStyle(style);
        this.transform = true;
        NinePatch background = style.background;
        TableLayout layout = this.getTableLayout();
        layout.padBottom(Integer.toString((int)background.getBottomHeight() + 1));
        layout.padTop(Integer.toString((int)background.getTopHeight() + 1));
        layout.padLeft(Integer.toString((int)background.getLeftWidth() + 1));
        layout.padRight(Integer.toString((int)background.getRightWidth() + 1));
    }

    public void setStyle(WindowStyle style) {
        this.style = style;
    }

    private void calculateBoundsAndScissors(Matrix4 transform) {
        NinePatch background = this.style.background;
        BitmapFont titleFont = this.style.titleFont;
        this.widgetBounds.x = background.getLeftWidth();
        this.widgetBounds.y = background.getBottomHeight();
        this.widgetBounds.width = this.width - background.getLeftWidth() - background.getRightWidth();
        this.widgetBounds.height = this.height - background.getTopHeight() - background.getBottomHeight();
        ScissorStack.calculateScissors(this.stage.getCamera(), transform, this.widgetBounds, this.scissors);
        this.titleBounds.x = 0.0f;
        this.titleBounds.y = this.height - background.getTopHeight();
        this.titleBounds.width = this.width;
        this.titleBounds.height = background.getTopHeight();
        this.textBounds.set(titleFont.getBounds(this.title));
        this.textBounds.height -= titleFont.getDescent();
    }

    @Override
    public void draw(SpriteBatch batch, float parentAlpha) {
        NinePatch backgroundPatch = this.style.background;
        BitmapFont titleFont = this.style.titleFont;
        Color titleFontColor = this.style.titleFontColor;
        this.layout();
        this.applyTransform(batch);
        this.calculateBoundsAndScissors(batch.getTransformMatrix());
        batch.setColor(this.color.r, this.color.g, this.color.b, this.color.a * parentAlpha);
        backgroundPatch.draw(batch, 0.0f, 0.0f, this.width, this.height);
        float textY = this.height - (float)((int)(backgroundPatch.getTopHeight() / 2.0f)) + (float)((int)(this.textBounds.height / 2.0f));
        titleFont.setColor(titleFontColor.r, titleFontColor.g, titleFontColor.b, titleFontColor.a * parentAlpha);
        titleFont.drawMultiLine(batch, this.title, (int)(this.width / 2.0f), textY, 0.0f, BitmapFont.HAlignment.CENTER);
        batch.flush();
        ScissorStack.pushScissors(this.scissors);
        super.drawChildren(batch, parentAlpha);
        ScissorStack.popScissors();
        this.resetTransform(batch);
    }

    @Override
    public boolean touchDown(float x, float y, int pointer) {
        if (pointer != 0) {
            return false;
        }
        if (this.parent.getActors().size() > 1) {
            this.parent.swapActor(this, this.parent.getActors().get(this.parent.getActors().size() - 1));
        }
        if (this.titleBounds.contains(x, y)) {
            if (this.isMovable) {
                this.move = true;
            }
            this.initial.set(x, y);
        } else {
            super.touchDown(x, y, pointer);
        }
        return true;
    }

    @Override
    public void touchUp(float x, float y, int pointer) {
        this.move = false;
        if (this.parent.focusedActor[0] != this) {
            super.touchUp(x, y, pointer);
        }
    }

    @Override
    public void touchDragged(float x, float y, int pointer) {
        if (this.move) {
            this.x += x - this.initial.x;
            this.y += y - this.initial.y;
            return;
        }
        if (this.parent.focusedActor[0] != this) {
            super.touchDragged(x, y, pointer);
        }
    }

    @Override
    public Actor hit(float x, float y) {
        return x > 0.0f && x < this.width && y > 0.0f && y < this.height || this.isModal ? this : null;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setMovable(boolean isMovable) {
        this.isMovable = isMovable;
    }

    public boolean isMovable() {
        return this.isMovable;
    }

    public void setModal(boolean isModal) {
        this.isModal = isModal;
    }

    public boolean isModal() {
        return this.isModal;
    }

    public static class WindowStyle {
        public NinePatch background;
        public BitmapFont titleFont;
        public Color titleFontColor = new Color(1.0f, 1.0f, 1.0f, 1.0f);

        public WindowStyle() {
        }

        public WindowStyle(BitmapFont titleFont, Color titleFontColor, NinePatch backgroundPatch) {
            this.background = backgroundPatch;
            this.titleFont = titleFont;
            this.titleFontColor.set(titleFontColor);
        }
    }
}

