/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.ui.utils.Clipboard;
import com.badlogic.gdx.utils.FloatArray;

public class TextField
extends Widget {
    TextFieldStyle style;
    Clipboard clipboard;
    final Rectangle fieldBounds = new Rectangle();
    final BitmapFont.TextBounds textBounds = new BitmapFont.TextBounds();
    final Rectangle scissor = new Rectangle();
    TextFieldListener listener;
    String text = "";
    int cursor = 0;
    float renderOffset = 0.0f;
    float textOffset = 0.0f;
    int visibleTextStart = 0;
    int visibleTextEnd = 0;
    final StringBuilder builder = new StringBuilder();
    final FloatArray glyphAdvances = new FloatArray();
    final FloatArray glyphPositions = new FloatArray();
    float blinkTime = 0.42f;
    long lastBlink = System.nanoTime();
    boolean cursorOn = true;
    boolean hasSelection = false;
    int selectionStart = 0;
    float selectionX = 0.0f;
    float selectionWidth = 0.0f;
    OnscreenKeyboard keyboard = new DefaultOnscreenKeyboard();

    public TextField(Skin skin) {
        this("", skin.getStyle(TextFieldStyle.class), null);
    }

    public TextField(String text, Skin skin) {
        this(text, skin.getStyle(TextFieldStyle.class), null);
    }

    public TextField(TextFieldStyle style) {
        this("", style, null);
    }

    public TextField(String text, TextFieldStyle style) {
        this(text, style, null);
    }

    public TextField(String text, TextFieldStyle style, String name) {
        super(name);
        this.setStyle(style);
        this.clipboard = Clipboard.getDefaultClipboard();
        this.setText(text);
    }

    public void setStyle(TextFieldStyle style) {
        this.style = style;
    }

    @Override
    public void layout() {
    }

    private void blink() {
        long time = System.nanoTime();
        if ((float)(time - this.lastBlink) / 1.0E9f > this.blinkTime) {
            this.cursorOn = !this.cursorOn;
            this.lastBlink = time;
        }
    }

    private void calculateOffsets() {
        NinePatch background = this.style.background;
        float position = this.glyphPositions.get(this.cursor);
        float distance = position - Math.abs(this.renderOffset);
        float visibleWidth = this.width - background.getLeftWidth() - background.getRightWidth();
        if (distance <= 0.0f) {
            this.renderOffset = this.cursor > 0 ? -this.glyphPositions.get(this.cursor - 1) : 0.0f;
        } else if (distance > visibleWidth) {
            this.renderOffset -= distance - visibleWidth;
        }
        this.visibleTextStart = 0;
        this.textOffset = 0.0f;
        float start = Math.abs(this.renderOffset);
        int len = this.glyphPositions.size;
        float startPos = 0.0f;
        for (int i = 0; i < len; ++i) {
            if (!(this.glyphPositions.items[i] >= start)) continue;
            this.visibleTextStart = i;
            startPos = this.glyphPositions.items[i];
            this.textOffset = this.glyphPositions.items[this.visibleTextStart] - start;
            break;
        }
        this.visibleTextEnd = Math.min(this.text.length(), this.cursor + 1);
        while (this.visibleTextEnd <= this.text.length() && !(this.glyphPositions.items[this.visibleTextEnd] - startPos > visibleWidth)) {
            ++this.visibleTextEnd;
        }
        this.visibleTextEnd = Math.max(0, this.visibleTextEnd - 1);
        if (this.hasSelection) {
            int minIndex = Math.min(this.cursor, this.selectionStart);
            int maxIndex = Math.max(this.cursor, this.selectionStart);
            float minX = Math.max(this.glyphPositions.get(minIndex), this.glyphPositions.get(this.visibleTextStart));
            float maxX = Math.min(this.glyphPositions.get(maxIndex), this.glyphPositions.get(this.visibleTextEnd));
            this.selectionX = minX;
            this.selectionWidth = maxX - minX;
        }
    }

    @Override
    public void draw(SpriteBatch batch, float parentAlpha) {
        BitmapFont font = this.style.font;
        Color fontColor = this.style.fontColor;
        NinePatch background = this.style.background;
        TextureRegion selection = this.style.selection;
        NinePatch cursorPatch = this.style.cursor;
        batch.setColor(this.color.r, this.color.g, this.color.b, this.color.a * parentAlpha);
        background.draw(batch, this.x, this.y, this.width, this.height);
        float textY = (float)((int)(this.height / 2.0f) + (int)(this.textBounds.height / 2.0f)) + font.getDescent() / 2.0f;
        font.setColor(fontColor.r, fontColor.g, fontColor.b, fontColor.a * parentAlpha);
        this.calculateOffsets();
        if (this.hasSelection) {
            batch.draw(selection, this.x + this.selectionX + background.getLeftWidth() + this.renderOffset, this.y + textY - this.textBounds.height - font.getDescent() / 2.0f, this.selectionWidth, this.textBounds.height);
        }
        font.draw(batch, this.text, this.x + background.getLeftWidth() + this.textOffset, this.y + textY, this.visibleTextStart, this.visibleTextEnd);
        if (this.parent.keyboardFocusedActor == this) {
            this.blink();
            if (this.cursorOn) {
                cursorPatch.draw(batch, this.x + background.getLeftWidth() + this.glyphPositions.get(this.cursor) + this.renderOffset - 1.0f, this.y + textY - this.textBounds.height - font.getDescent(), cursorPatch.getTotalWidth(), this.textBounds.height + font.getDescent() / 2.0f);
            }
        }
    }

    @Override
    public boolean touchDown(float x, float y, int pointer) {
        if (pointer != 0) {
            return false;
        }
        this.parent.keyboardFocus(this);
        this.keyboard.show(true);
        x -= this.renderOffset;
        for (int i = 0; i < this.glyphPositions.size; ++i) {
            float pos = this.glyphPositions.items[i];
            if (!(pos > x)) continue;
            this.cursor = Math.max(0, i - 1);
            return true;
        }
        this.cursor = Math.max(0, this.glyphPositions.size - 1);
        return true;
    }

    @Override
    public void touchUp(float x, float y, int pointer) {
    }

    @Override
    public void touchDragged(float x, float y, int pointer) {
    }

    @Override
    public boolean keyDown(int keycode) {
        BitmapFont font = this.style.font;
        if (this.parent.keyboardFocusedActor == this) {
            if (Gdx.input.isKeyPressed(129) || Gdx.input.isKeyPressed(130)) {
                String content;
                if (keycode == 50 && (content = this.clipboard.getContents()) != null) {
                    StringBuilder builder = new StringBuilder();
                    for (int i = 0; i < content.length(); ++i) {
                        char c = content.charAt(i);
                        if (!font.containsCharacter(c)) continue;
                        builder.append(c);
                    }
                    content = builder.toString();
                    this.text = this.text.substring(0, this.cursor) + content + this.text.substring(this.cursor, this.text.length());
                    this.cursor += content.length();
                    font.computeGlyphAdvancesAndPositions(this.text, this.glyphAdvances, this.glyphPositions);
                }
                if (keycode == 31 && this.hasSelection) {
                    int minIndex = Math.min(this.cursor, this.selectionStart);
                    int maxIndex = Math.max(this.cursor, this.selectionStart);
                    this.clipboard.setContents(this.text.substring(minIndex, maxIndex));
                }
            } else if (Gdx.input.isKeyPressed(59) || Gdx.input.isKeyPressed(60)) {
                if (keycode == 21) {
                    if (!this.hasSelection) {
                        this.selectionStart = this.cursor;
                        this.hasSelection = true;
                    }
                    --this.cursor;
                }
                if (keycode == 22) {
                    if (!this.hasSelection) {
                        this.selectionStart = this.cursor;
                        this.hasSelection = true;
                    }
                    ++this.cursor;
                }
                if (keycode == 3) {
                    if (!this.hasSelection) {
                        this.selectionStart = this.cursor;
                        this.hasSelection = true;
                    }
                    this.cursor = 0;
                }
                if (keycode == 132) {
                    if (!this.hasSelection) {
                        this.selectionStart = this.cursor;
                        this.hasSelection = true;
                    }
                    this.cursor = this.text.length();
                }
                this.cursor = Math.max(0, this.cursor);
                this.cursor = Math.min(this.text.length(), this.cursor);
            } else {
                if (keycode == 21) {
                    --this.cursor;
                    this.hasSelection = false;
                }
                if (keycode == 22) {
                    ++this.cursor;
                    this.hasSelection = false;
                }
                if (keycode == 3) {
                    this.cursor = 0;
                    this.hasSelection = false;
                }
                if (keycode == 132) {
                    this.cursor = this.text.length();
                    this.hasSelection = false;
                }
                this.cursor = Math.max(0, this.cursor);
                this.cursor = Math.min(this.text.length(), this.cursor);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean keyTyped(char character) {
        BitmapFont font = this.style.font;
        if (this.parent.keyboardFocusedActor == this) {
            int maxIndex;
            int minIndex;
            if (character == '\b' && (this.cursor > 0 || this.hasSelection)) {
                if (!this.hasSelection) {
                    this.text = this.text.substring(0, this.cursor - 1) + this.text.substring(this.cursor);
                    --this.cursor;
                    font.computeGlyphAdvancesAndPositions(this.text, this.glyphAdvances, this.glyphPositions);
                } else {
                    minIndex = Math.min(this.cursor, this.selectionStart);
                    maxIndex = Math.max(this.cursor, this.selectionStart);
                    this.text = (minIndex > 0 ? this.text.substring(0, minIndex) : "") + (maxIndex < this.text.length() ? this.text.substring(maxIndex, this.text.length()) : "");
                    this.cursor = minIndex;
                    font.computeGlyphAdvancesAndPositions(this.text, this.glyphAdvances, this.glyphPositions);
                    this.hasSelection = false;
                }
            }
            if (character == '\u007f' && (this.cursor < this.text.length() || this.hasSelection)) {
                if (!this.hasSelection) {
                    this.text = this.text.substring(0, this.cursor) + this.text.substring(this.cursor + 1);
                    font.computeGlyphAdvancesAndPositions(this.text, this.glyphAdvances, this.glyphPositions);
                } else {
                    minIndex = Math.min(this.cursor, this.selectionStart);
                    maxIndex = Math.max(this.cursor, this.selectionStart);
                    this.text = (minIndex > 0 ? this.text.substring(0, minIndex) : "") + (maxIndex < this.text.length() ? this.text.substring(maxIndex, this.text.length()) : "");
                    this.cursor = minIndex;
                    font.computeGlyphAdvancesAndPositions(this.text, this.glyphAdvances, this.glyphPositions);
                    this.hasSelection = false;
                }
            }
            if (font.containsCharacter(character)) {
                if (!this.hasSelection) {
                    this.text = this.text.substring(0, this.cursor) + character + this.text.substring(this.cursor, this.text.length());
                    ++this.cursor;
                    font.computeGlyphAdvancesAndPositions(this.text, this.glyphAdvances, this.glyphPositions);
                } else {
                    minIndex = Math.min(this.cursor, this.selectionStart);
                    maxIndex = Math.max(this.cursor, this.selectionStart);
                    this.text = (minIndex > 0 ? this.text.substring(0, minIndex) : "") + (maxIndex < this.text.length() ? this.text.substring(maxIndex, this.text.length()) : "");
                    this.cursor = minIndex;
                    this.text = this.text.substring(0, this.cursor) + character + this.text.substring(this.cursor, this.text.length());
                    ++this.cursor;
                    font.computeGlyphAdvancesAndPositions(this.text, this.glyphAdvances, this.glyphPositions);
                    this.hasSelection = false;
                }
            }
            if (this.listener != null) {
                this.listener.keyTyped(this, character);
            }
            return true;
        }
        return false;
    }

    @Override
    public Actor hit(float x, float y) {
        return x > 0.0f && x < this.width && y > 0.0f && y < this.height ? this : null;
    }

    public void setTextFieldListener(TextFieldListener listener) {
        this.listener = listener;
    }

    public void setText(String text) {
        if (text == null) {
            throw new IllegalArgumentException("text must not be null");
        }
        BitmapFont font = this.style.font;
        this.text = text;
        this.cursor = 0;
        this.hasSelection = false;
        font.computeGlyphAdvancesAndPositions(text, this.glyphAdvances, this.glyphPositions);
        this.textBounds.set(font.getBounds(text));
        this.textBounds.height -= font.getDescent() * 2.0f;
        font.computeGlyphAdvancesAndPositions(text, this.glyphAdvances, this.glyphPositions);
    }

    public String getText() {
        return this.text;
    }

    @Override
    public float getPrefWidth() {
        return 150.0f;
    }

    @Override
    public float getPrefHeight() {
        NinePatch background = this.style.background;
        return background.getBottomHeight() + background.getTopHeight() + this.textBounds.height;
    }

    public OnscreenKeyboard getOnscreenKeyboard() {
        return this.keyboard;
    }

    public void setOnscreenKeyboard(OnscreenKeyboard keyboard) {
        this.keyboard = keyboard;
    }

    public void setClipboard(Clipboard clipboard) {
        this.clipboard = clipboard;
    }

    public static class DefaultOnscreenKeyboard
    implements OnscreenKeyboard {
        @Override
        public void show(boolean visible) {
            Gdx.input.setOnscreenKeyboardVisible(visible);
        }
    }

    public static interface OnscreenKeyboard {
        public void show(boolean var1);
    }

    public static interface TextFieldListener {
        public void keyTyped(TextField var1, char var2);
    }

    public static class TextFieldStyle {
        public NinePatch background;
        public BitmapFont font;
        public Color fontColor;
        public NinePatch cursor;
        public TextureRegion selection;

        public TextFieldStyle() {
        }

        public TextFieldStyle(BitmapFont font, Color fontColor, NinePatch cursor, TextureRegion selection, NinePatch background) {
            this.background = background;
            this.cursor = cursor;
            this.font = font;
            this.fontColor = fontColor;
            this.selection = selection;
        }
    }
}

