/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Layout;
import com.badlogic.gdx.scenes.scene2d.ui.tablelayout.LibgdxToolkit;

public class Stack
extends Group
implements Layout {
    private boolean needsLayout = true;

    public Stack() {
        this(null);
    }

    public Stack(String name) {
        super(name);
        this.transform = false;
    }

    @Override
    public void layout() {
        if (!this.needsLayout) {
            return;
        }
        this.needsLayout = false;
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            Actor actor = (Actor)this.children.get(i);
            actor.x = 0.0f;
            actor.y = 0.0f;
            actor.width = this.width;
            actor.height = this.height;
            if (!(actor instanceof Layout)) continue;
            Layout layout = (Layout)((Object)actor);
            layout.invalidate();
            layout.layout();
        }
    }

    @Override
    public void draw(SpriteBatch batch, float parentAlpha) {
        if (this.needsLayout) {
            this.layout();
        }
        super.draw(batch, parentAlpha);
    }

    @Override
    public void invalidate() {
        this.needsLayout = true;
    }

    @Override
    public float getPrefWidth() {
        float width = 0.0f;
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            width = Math.max(width, (float)LibgdxToolkit.instance.getPrefWidth((Actor)this.children.get(i)));
        }
        return width * this.scaleX;
    }

    @Override
    public float getPrefHeight() {
        float height = 0.0f;
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            height = Math.max(height, (float)LibgdxToolkit.instance.getPrefHeight((Actor)this.children.get(i)));
        }
        return height * this.scaleY;
    }

    @Override
    public float getMaxWidth() {
        float width = 0.0f;
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            width = Math.max(width, (float)LibgdxToolkit.instance.getMaxWidth((Actor)this.children.get(i)));
        }
        return width * this.scaleX;
    }

    @Override
    public float getMaxHeight() {
        float height = 0.0f;
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            height = Math.max(height, (float)LibgdxToolkit.instance.getMaxHeight((Actor)this.children.get(i)));
        }
        return height * this.scaleY;
    }

    @Override
    public float getMinWidth() {
        float width = 0.0f;
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            width = Math.max(width, (float)LibgdxToolkit.instance.getMinWidth((Actor)this.children.get(i)));
        }
        return width * this.scaleX;
    }

    @Override
    public float getMinHeight() {
        float height = 0.0f;
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            height = Math.max(height, (float)LibgdxToolkit.instance.getMinHeight((Actor)this.children.get(i)));
        }
        return height * this.scaleY;
    }
}

