/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Layout;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.utils.ScissorStack;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class SplitPane
extends Group
implements Layout {
    SplitPaneStyle style;
    boolean invalidated = false;
    boolean vertical;
    float splitAmount = 0.5f;
    float minAmount = 0.0f;
    float maxAmount = 1.0f;
    float oldSplitAmount = 0.0f;
    Stage stage;
    Actor firstWidget;
    Actor secondWidget;
    Rectangle firstWidgetBounds = new Rectangle();
    Rectangle secondWidgetBounds = new Rectangle();
    Rectangle handleBounds = new Rectangle();
    Rectangle[] scissors = new Rectangle[]{new Rectangle(), new Rectangle()};
    boolean touchDrag = false;
    Vector2 lastPoint = new Vector2();
    Vector2 handlePos = new Vector2();

    public SplitPane(Actor firstWidget, Actor secondWidget, boolean vertical, Stage stage, Skin skin) {
        this(firstWidget, secondWidget, vertical, stage, skin.getStyle(SplitPaneStyle.class), null);
    }

    public SplitPane(Actor firstWidget, Actor secondWidget, boolean vertical, Stage stage, SplitPaneStyle style) {
        this(firstWidget, secondWidget, vertical, stage, style, null);
    }

    public SplitPane(Actor firstWidget, Actor secondWidget, boolean vertical, Stage stage, SplitPaneStyle style, String name) {
        super(name);
        this.stage = stage;
        this.setStyle(style);
        this.firstWidget = firstWidget;
        this.secondWidget = secondWidget;
        this.vertical = vertical;
        this.addActor(firstWidget);
        this.addActor(secondWidget);
    }

    public void setStyle(SplitPaneStyle style) {
        this.style = style;
    }

    @Override
    public void layout() {
        Layout layout;
        if (!this.invalidated) {
            return;
        }
        this.invalidated = false;
        if (this.firstWidget instanceof Layout) {
            layout = (Layout)((Object)this.firstWidget);
            layout.layout();
            this.firstWidget.width = layout.getPrefWidth();
            this.firstWidget.height = layout.getPrefHeight();
        }
        if (this.secondWidget instanceof Layout) {
            layout = (Layout)((Object)this.secondWidget);
            layout.layout();
            this.secondWidget.width = layout.getPrefWidth();
            this.secondWidget.height = layout.getPrefHeight();
        }
    }

    @Override
    public void invalidate() {
        if (this.firstWidget instanceof Layout) {
            ((Layout)((Object)this.firstWidget)).invalidate();
        }
        if (this.secondWidget instanceof Layout) {
            ((Layout)((Object)this.secondWidget)).invalidate();
        }
        this.invalidated = true;
    }

    @Override
    public float getPrefWidth() {
        return 150.0f;
    }

    @Override
    public float getPrefHeight() {
        return 150.0f;
    }

    @Override
    public float getMinWidth() {
        return 0.0f;
    }

    @Override
    public float getMinHeight() {
        return 0.0f;
    }

    @Override
    public float getMaxWidth() {
        return 0.0f;
    }

    @Override
    public float getMaxHeight() {
        return 0.0f;
    }

    private void calculateBoundsAndPositions(Matrix4 transform) {
        if (this.oldSplitAmount != this.splitAmount) {
            this.oldSplitAmount = this.splitAmount;
            this.invalidate();
        }
        if (!this.vertical) {
            this.calculateHorizBoundsAndPositions();
        } else {
            this.calculateVertBoundsAndPositions();
        }
        boolean layoutFirst = false;
        boolean layoutSecond = false;
        if (this.firstWidget.width != this.firstWidgetBounds.width || this.firstWidget.height != this.firstWidgetBounds.height) {
            layoutFirst = true;
        }
        if (this.secondWidget.width != this.secondWidgetBounds.width || this.secondWidget.height != this.secondWidgetBounds.height) {
            layoutSecond = true;
        }
        this.firstWidget.x = this.firstWidgetBounds.x;
        this.firstWidget.y = this.firstWidgetBounds.y;
        this.firstWidget.width = this.firstWidgetBounds.width;
        this.firstWidget.height = this.firstWidgetBounds.height;
        this.secondWidget.x = this.secondWidgetBounds.x;
        this.secondWidget.y = this.secondWidgetBounds.y;
        this.secondWidget.width = this.secondWidgetBounds.width;
        this.secondWidget.height = this.secondWidgetBounds.height;
        if (layoutFirst && this.firstWidget instanceof Layout) {
            ((Layout)((Object)this.firstWidget)).invalidate();
        }
        if (layoutSecond && this.secondWidget instanceof Layout) {
            ((Layout)((Object)this.secondWidget)).invalidate();
        }
        ScissorStack.calculateScissors(this.stage.getCamera(), transform, this.firstWidgetBounds, this.scissors[0]);
        ScissorStack.calculateScissors(this.stage.getCamera(), transform, this.secondWidgetBounds, this.scissors[1]);
    }

    private void calculateHorizBoundsAndPositions() {
        NinePatch handle = this.style.handle;
        float availWidth = this.width - handle.getTotalWidth();
        float leftAreaWidth = (int)(availWidth * this.splitAmount);
        float rightAreaWidth = availWidth - leftAreaWidth;
        float handleWidth = handle.getTotalWidth();
        this.firstWidgetBounds.set(0.0f, 0.0f, leftAreaWidth, this.height);
        this.secondWidgetBounds.set(leftAreaWidth + handleWidth, 0.0f, rightAreaWidth, this.height);
        this.handleBounds.set(leftAreaWidth, 0.0f, handleWidth, this.height);
    }

    private void calculateVertBoundsAndPositions() {
        NinePatch handle = this.style.handle;
        float availHeight = this.height - handle.getTotalHeight();
        float topAreaHeight = (int)(availHeight * this.splitAmount);
        float bottomAreaHeight = availHeight - topAreaHeight;
        float handleHeight = handle.getTotalHeight();
        this.firstWidgetBounds.set(0.0f, this.height - topAreaHeight, this.width, topAreaHeight);
        this.secondWidgetBounds.set(0.0f, 0.0f, this.width, bottomAreaHeight);
        this.handleBounds.set(0.0f, bottomAreaHeight, this.width, handleHeight);
    }

    @Override
    public void draw(SpriteBatch batch, float parentAlpha) {
        NinePatch handle = this.style.handle;
        this.applyTransform(batch);
        this.calculateBoundsAndPositions(batch.getTransformMatrix());
        for (int i = 0; i < this.children.size(); ++i) {
            ScissorStack.pushScissors(this.scissors[i]);
            this.drawChild((Actor)this.children.get(i), batch, parentAlpha);
            ScissorStack.popScissors();
        }
        batch.setColor(this.color.r, this.color.g, this.color.b, this.color.a);
        handle.draw(batch, this.handleBounds.x, this.handleBounds.y, this.handleBounds.width, this.handleBounds.height);
        if (this.invalidated) {
            this.layout();
        }
        this.resetTransform(batch);
    }

    @Override
    public boolean touchDown(float x, float y, int pointer) {
        if (pointer != 0) {
            return false;
        }
        if (this.handleBounds.contains(x, y)) {
            this.touchDrag = true;
            this.lastPoint.set(x, y);
            this.handlePos.set(this.handleBounds.x, this.handleBounds.y);
            return true;
        }
        return super.touchDown(x, y, pointer);
    }

    @Override
    public void touchUp(float x, float y, int pointer) {
        if (this.touchDrag) {
            this.touchDrag = false;
            return;
        }
        super.touchUp(x, y, pointer);
    }

    @Override
    public void touchDragged(float x, float y, int pointer) {
        NinePatch handle = this.style.handle;
        if (this.touchDrag) {
            if (!this.vertical) {
                float dragX;
                float delta = x - this.lastPoint.x;
                float availWidth = this.width - handle.getTotalWidth();
                this.handlePos.x = dragX = this.handlePos.x + delta;
                dragX = Math.max(0.0f, dragX);
                dragX = Math.min(availWidth, dragX);
                this.splitAmount = dragX / availWidth;
                if (this.splitAmount < this.minAmount) {
                    this.splitAmount = this.minAmount;
                }
                if (this.splitAmount > this.maxAmount) {
                    this.splitAmount = this.maxAmount;
                }
                this.invalidate();
                this.lastPoint.set(x, y);
            } else {
                float dragY;
                float delta = y - this.lastPoint.y;
                float availHeight = this.height - handle.getTotalHeight();
                this.handlePos.y = dragY = this.handlePos.y + delta;
                dragY = Math.max(0.0f, dragY);
                dragY = Math.min(availHeight, dragY);
                this.splitAmount = 1.0f - dragY / availHeight;
                if (this.splitAmount < this.minAmount) {
                    this.splitAmount = this.minAmount;
                }
                if (this.splitAmount > this.maxAmount) {
                    this.splitAmount = this.maxAmount;
                }
                this.invalidate();
                this.lastPoint.set(x, y);
            }
        } else {
            super.touchDragged(x, y, pointer);
        }
    }

    @Override
    public Actor hit(float x, float y) {
        return x > 0.0f && x < this.width && y > 0.0f && y < this.height ? this : null;
    }

    public void setSplitAmount(float split) {
        this.splitAmount = Math.max(Math.min(this.maxAmount, split), this.minAmount);
        this.invalidate();
    }

    public float getSplit() {
        return this.splitAmount;
    }

    public void setMinSplitAmount(float minAmount) {
        if (minAmount < 0.0f) {
            throw new GdxRuntimeException("minAmount has to be >= 0");
        }
        if (minAmount >= this.maxAmount) {
            throw new GdxRuntimeException("minAmount has to be < maxAmount");
        }
        this.minAmount = minAmount;
    }

    public void setMaxSplitAmount(float maxAmount) {
        if (maxAmount > 1.0f) {
            throw new GdxRuntimeException("maxAmount has to be >= 0");
        }
        if (maxAmount <= this.minAmount) {
            throw new GdxRuntimeException("maxAmount has to be > minAmount");
        }
        this.maxAmount = maxAmount;
    }

    public void setWidgets(Actor firstWidget, Actor secondWidget) {
        if (firstWidget == null) {
            throw new IllegalArgumentException("firstWidget must not be null");
        }
        if (secondWidget == null) {
            throw new IllegalArgumentException("secondWidget must not be null");
        }
        this.removeActor(this.firstWidget);
        this.removeActor(this.secondWidget);
        this.firstWidget = firstWidget;
        this.secondWidget = secondWidget;
        this.addActor(firstWidget);
        this.addActor(secondWidget);
        this.invalidate();
    }

    public static class SplitPaneStyle {
        public NinePatch handle;

        public SplitPaneStyle() {
        }

        public SplitPaneStyle(NinePatch handle) {
            this.handle = handle;
        }
    }
}

