/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;

public class Slider
extends Widget {
    SliderStyle style;
    float min;
    float max;
    float steps;
    float value;
    float sliderPos;
    ValueChangedListener listener = null;

    public Slider(float min, float max, float steps, Skin skin) {
        this(min, max, steps, skin.getStyle(SliderStyle.class), null);
    }

    public Slider(float min, float max, float steps, SliderStyle style) {
        this(min, max, steps, style, null);
    }

    public Slider(float min, float max, float steps, SliderStyle style, String name) {
        super(name);
        this.setStyle(style);
        if (min > max) {
            throw new IllegalArgumentException("min must be > max");
        }
        if (steps < 0.0f) {
            throw new IllegalArgumentException("unit must be > 0");
        }
        this.min = min;
        this.max = max;
        this.steps = steps;
        this.value = min;
    }

    public void setStyle(SliderStyle style) {
        this.style = style;
    }

    @Override
    public void layout() {
    }

    @Override
    public void draw(SpriteBatch batch, float parentAlpha) {
        TextureRegion knob = this.style.knob;
        NinePatch slider = this.style.slider;
        batch.setColor(this.color.r, this.color.g, this.color.b, this.color.a * parentAlpha);
        this.sliderPos = (this.value - this.min) / (this.max - this.min) * (this.width - (float)knob.getRegionWidth());
        this.sliderPos = Math.max(0.0f, this.sliderPos);
        this.sliderPos = Math.min(this.width - (float)knob.getRegionWidth(), this.sliderPos);
        float maxHeight = Math.max((float)knob.getRegionHeight(), slider.getTotalHeight());
        slider.draw(batch, this.x, this.y + (float)((int)((maxHeight - slider.getTotalHeight()) * 0.5f)), this.width, slider.getTotalHeight());
        batch.draw(knob, this.x + this.sliderPos, this.y + (float)((int)((maxHeight - (float)knob.getRegionHeight()) * 0.5f)));
    }

    @Override
    public boolean touchDown(float x, float y, int pointer) {
        if (pointer != 0) {
            return false;
        }
        this.calculateSliderPosAndValue(x);
        return true;
    }

    @Override
    public void touchUp(float x, float y, int pointer) {
        this.calculateSliderPosAndValue(x);
    }

    @Override
    public void touchDragged(float x, float y, int pointer) {
        this.calculateSliderPosAndValue(x);
    }

    private void calculateSliderPosAndValue(float x) {
        TextureRegion knob = this.style.knob;
        this.sliderPos = x - (float)(knob.getRegionWidth() / 2);
        this.sliderPos = Math.max(0.0f, this.sliderPos);
        this.sliderPos = Math.min(this.width - (float)knob.getRegionWidth(), this.sliderPos);
        this.value = this.min + (this.max - this.min) * (this.sliderPos / (this.width - (float)knob.getRegionWidth()));
        if (this.listener != null) {
            this.listener.changed(this, this.getValue());
        }
    }

    @Override
    public Actor hit(float x, float y) {
        return x > 0.0f && x < this.width && y > 0.0f && y < this.height ? this : null;
    }

    public Slider setValueChangedListener(ValueChangedListener listener) {
        this.listener = listener;
        return this;
    }

    public float getValue() {
        return (float)Math.floor(this.value / this.steps) * this.steps;
    }

    public void setValue(float value) {
        if (value < this.min || value > this.max) {
            throw new IllegalArgumentException("value must be >= min && <= max");
        }
        this.value = value;
        if (this.listener != null) {
            this.listener.changed(this, this.getValue());
        }
    }

    public void setRange(float min, float max) {
        if (min >= max) {
            throw new IllegalArgumentException("min must be < max");
        }
        this.min = min;
        this.max = max;
        this.value = min;
        if (this.listener != null) {
            this.listener.changed(this, this.getValue());
        }
    }

    @Override
    public float getPrefWidth() {
        return 140.0f;
    }

    @Override
    public float getPrefHeight() {
        return Math.max((float)this.style.knob.getRegionHeight(), this.style.slider.getTotalHeight());
    }

    public static interface ValueChangedListener {
        public void changed(Slider var1, float var2);
    }

    public static class SliderStyle {
        NinePatch slider;
        TextureRegion knob;

        public SliderStyle() {
        }

        public SliderStyle(NinePatch sliderPatch, TextureRegion knobRegion) {
            this.slider = sliderPatch;
            this.knob = knobRegion;
        }
    }
}

