/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.SerializationException;
import java.io.IOException;
import java.io.Writer;

public class Skin
implements Disposable {
    ObjectMap<Class, ObjectMap<String, Object>> styles = new ObjectMap();
    final SkinData data;

    public Skin() {
        this.data = new SkinData();
    }

    public Skin(FileHandle skinFile, FileHandle textureFile) {
        this.data = new SkinData();
        this.data.texture = new Texture(textureFile);
        try {
            this.getJsonLoader(skinFile).fromJson(Skin.class, skinFile);
        }
        catch (SerializationException ex) {
            throw new SerializationException("Error reading file: " + skinFile, ex);
        }
    }

    public Skin(FileHandle skinFile, SkinData data) {
        this.data = data;
        data.texture.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        try {
            this.getJsonLoader(skinFile).fromJson(Skin.class, skinFile);
        }
        catch (SerializationException ex) {
            throw new SerializationException("Error reading file: " + skinFile, ex);
        }
    }

    public <T> void addResource(String name, T resource) {
        if (resource == null) {
            throw new IllegalArgumentException("resource cannot be null.");
        }
        ObjectMap<String, Object> typeResources = this.data.resources.get(resource.getClass());
        if (typeResources == null) {
            typeResources = new ObjectMap();
            this.data.resources.put(resource.getClass(), typeResources);
        }
        typeResources.put(name, resource);
    }

    public <T> T getResource(String name, Class<T> type) {
        ObjectMap<String, Object> typeResources = this.data.resources.get(type);
        if (typeResources == null) {
            throw new GdxRuntimeException("No resources registered with type: " + type.getName());
        }
        Object resource = typeResources.get(name);
        if (resource == null) {
            throw new GdxRuntimeException("No " + type.getName() + " resource registered with name: " + name);
        }
        return (T)resource;
    }

    public <T> void addStyle(String name, T style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        ObjectMap<String, Object> typeStyles = this.styles.get(style.getClass());
        if (typeStyles == null) {
            typeStyles = new ObjectMap();
            this.styles.put(style.getClass(), typeStyles);
        }
        typeStyles.put(name, style);
    }

    public <T> T getStyle(Class<T> type) {
        return this.getStyle("default", type);
    }

    public <T> T getStyle(String name, Class<T> type) {
        ObjectMap<String, Object> typeStyles = this.styles.get(type);
        if (typeStyles == null) {
            throw new GdxRuntimeException("No styles registered with type: " + type.getName());
        }
        Object style = typeStyles.get(name);
        if (style == null) {
            throw new GdxRuntimeException("No " + type.getName() + " style registered with name: " + name);
        }
        return (T)style;
    }

    @Override
    public void dispose() {
        this.data.texture.dispose();
        for (ObjectMap<String, Object> object : this.data.resources.values()) {
            if (!(object instanceof Disposable)) continue;
            ((Disposable)((Object)object)).dispose();
        }
    }

    public void setTexture(Texture texture) {
        this.data.texture = texture;
    }

    public Texture getTexture() {
        return this.data.texture;
    }

    public void save(FileHandle skinFile) {
        String text = this.getJsonLoader(null).prettyPrint(this, true);
        Writer writer = skinFile.writer(false);
        try {
            writer.write(text);
            writer.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    protected Json getJsonLoader(final FileHandle skinFile) {
        final Skin skin = this;
        Json json = new Json();
        json.setTypeName(null);
        json.setUsePrototypes(false);
        json.setSerializer(Skin.class, new Json.Serializer<Skin>(){

            @Override
            public void write(Json json, Skin skin2, Class valueType) {
                json.writeObjectStart();
                json.writeValue("resources", skin2.data.resources);
                for (ObjectMap.Entry<Class, ObjectMap<String, Object>> entry : Skin.this.data.resources.entries()) {
                    class AliasSerializer
                    implements Json.Serializer {
                        final ObjectMap<String, ?> map;
                        final /* synthetic */ Skin this$0;

                        public AliasSerializer(Skin skin, ObjectMap<String, ?> map) {
                            this.this$0 = skin;
                            this.map = map;
                        }

                        public void write(Json json, Object object, Class valueType) {
                            for (ObjectMap.Entry<String, ?> entry : this.map.entries()) {
                                if (!entry.value.equals(object)) continue;
                                json.writeValue(entry.key);
                                return;
                            }
                            throw new SerializationException(object.getClass().getSimpleName() + " not found: " + object);
                        }

                        public Object read(Json json, Object jsonData, Class type) {
                            String name = (String)jsonData;
                            Object object = this.map.get(name);
                            if (object == null) {
                                ObjectMap<String, Object> regions = this.this$0.data.resources.get(TextureRegion.class);
                                if (regions != null && (object = regions.get(name)) != null) {
                                    object = new NinePatch((TextureRegion)object);
                                }
                                if (object == null) {
                                    throw new SerializationException("Skin has a " + type.getSimpleName() + " that could not be found in the resources: " + jsonData);
                                }
                            }
                            return object;
                        }
                    }
                    json.setSerializer((Class)entry.key, new AliasSerializer(Skin.this, (ObjectMap)entry.value));
                }
                json.writeField(skin2, "styles");
                json.writeObjectEnd();
            }

            @Override
            public Skin read(Json json, Object jsonData, Class ignored) {
                ObjectMap map = (ObjectMap)jsonData;
                this.readTypeMap(json, (ObjectMap)map.get("resources"), true);
                for (ObjectMap.Entry<Class, ObjectMap<String, Object>> entry : Skin.this.data.resources.entries()) {
                    json.setSerializer((Class)entry.key, new AliasSerializer(Skin.this, (ObjectMap)entry.value));
                }
                this.readTypeMap(json, (ObjectMap)map.get("styles"), false);
                return skin;
            }

            private void readTypeMap(Json json, ObjectMap<String, ObjectMap> typeToValueMap, boolean isResource) {
                if (typeToValueMap == null) {
                    throw new SerializationException("Skin file is missing a \"" + (isResource ? "resources" : "styles") + "\" section.");
                }
                for (ObjectMap.Entry<String, ObjectMap> entry : typeToValueMap.entries()) {
                    Class<?> type;
                    try {
                        type = Class.forName((String)entry.key);
                    }
                    catch (ClassNotFoundException ex) {
                        throw new SerializationException(ex);
                    }
                    ObjectMap valueMap = (ObjectMap)entry.value;
                    for (ObjectMap.Entry valueEntry : valueMap.entries()) {
                        try {
                            if (isResource) {
                                Skin.this.addResource((String)valueEntry.key, json.readValue(type, valueEntry.value));
                                continue;
                            }
                            Skin.this.addStyle((String)valueEntry.key, json.readValue(type, valueEntry.value));
                        }
                        catch (Exception ex) {
                            throw new SerializationException("Error reading " + type.getSimpleName() + ": " + (String)valueEntry.key, ex);
                        }
                    }
                }
            }
        });
        json.setSerializer(TextureRegion.class, new Json.Serializer<TextureRegion>(){

            @Override
            public void write(Json json, TextureRegion region, Class valueType) {
                json.writeObjectStart();
                json.writeValue("x", region.getRegionX());
                json.writeValue("y", region.getRegionY());
                json.writeValue("width", region.getRegionWidth());
                json.writeValue("height", region.getRegionHeight());
                json.writeObjectEnd();
            }

            @Override
            public TextureRegion read(Json json, Object jsonData, Class type) {
                int x = json.readValue("x", Integer.TYPE, jsonData);
                int y = json.readValue("y", Integer.TYPE, jsonData);
                int width = json.readValue("width", Integer.TYPE, jsonData);
                int height = json.readValue("height", Integer.TYPE, jsonData);
                return new TextureRegion(skin.data.texture, x, y, width, height);
            }
        });
        json.setSerializer(BitmapFont.class, new Json.Serializer<BitmapFont>(){

            @Override
            public void write(Json json, BitmapFont font, Class valueType) {
                json.writeValue(font.getData().getFontFile().toString().replace('\\', '/'));
            }

            @Override
            public BitmapFont read(Json json, Object jsonData, Class type) {
                String path = json.readValue(String.class, jsonData);
                FileHandle file = skinFile.parent().child(path);
                if (!file.exists()) {
                    file = Gdx.files.internal(path);
                }
                return new BitmapFont(file, false);
            }
        });
        json.setSerializer(NinePatch.class, new Json.Serializer<NinePatch>(){

            @Override
            public void write(Json json, NinePatch ninePatch, Class valueType) {
                json.writeValue(ninePatch.getPatches());
            }

            @Override
            public NinePatch read(Json json, Object jsonData, Class type) {
                return new NinePatch(json.readValue(TextureRegion[].class, jsonData));
            }
        });
        return json;
    }

    public static class SkinData {
        public ObjectMap<Class, ObjectMap<String, Object>> resources = new ObjectMap();
        public transient Texture texture;
    }
}

