/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Layout;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.utils.ScissorStack;

public class ScrollPane
extends Group
implements Layout {
    final ScrollPaneStyle style;
    Actor widget;
    Stage stage;
    Rectangle hScrollBounds = new Rectangle();
    Rectangle vScrollBounds = new Rectangle();
    Rectangle hScrollKnobBounds = new Rectangle();
    Rectangle vScrollKnobBounds = new Rectangle();
    Rectangle widgetAreaBounds = new Rectangle();
    Rectangle scissorBounds = new Rectangle();
    float hScrollAmount = 0.0f;
    float vScrollAmount = 0.0f;
    boolean hasHScroll = false;
    boolean hasVScroll = false;
    boolean touchScrollH = false;
    boolean touchScrollV = false;
    Vector2 lastPoint = new Vector2();
    Vector3 tmp = new Vector3();
    float handlePos = 0.0f;

    public ScrollPane(Actor widget, Stage stage, Skin skin) {
        this(widget, stage, skin.getStyle(ScrollPaneStyle.class), null);
    }

    public ScrollPane(Actor widget, Stage stage, ScrollPaneStyle style) {
        this(widget, stage, style, null);
    }

    public ScrollPane(Actor widget, Stage stage, ScrollPaneStyle style, String name) {
        super(name);
        this.widget = widget;
        this.stage = stage;
        this.style = style;
        this.addActor(widget);
        this.layout();
    }

    private void calculateBoundsAndPositions(Matrix4 batchTransform) {
        float widgetHeight;
        float widgetWidth;
        Layout layout;
        NinePatch background = this.style.background;
        NinePatch hScrollKnob = this.style.hScrollKnob;
        NinePatch vScrollKnob = this.style.vScrollKnob;
        float areaWidth = this.width - background.getLeftWidth() - background.getRightWidth();
        float areaHeight = this.height - background.getTopHeight() - background.getBottomHeight();
        if (this.widget instanceof Layout) {
            layout = (Layout)((Object)this.widget);
            widgetWidth = layout.getPrefWidth();
            widgetHeight = layout.getPrefHeight();
        } else {
            widgetWidth = this.widget.width;
            widgetHeight = this.widget.height;
        }
        this.hasHScroll = false;
        this.hasVScroll = false;
        if (widgetWidth > areaWidth) {
            this.hasHScroll = true;
        }
        if (widgetHeight > areaHeight) {
            this.hasVScroll = true;
        }
        if (this.hasVScroll && widgetWidth > areaWidth - vScrollKnob.getTotalWidth()) {
            this.hasHScroll = true;
            areaWidth -= vScrollKnob.getTotalWidth();
        }
        if (this.hasHScroll && widgetHeight > areaHeight - hScrollKnob.getTotalHeight()) {
            this.hasVScroll = true;
            areaHeight -= hScrollKnob.getTotalHeight();
        }
        widgetWidth = Math.max(areaWidth, widgetWidth);
        widgetHeight = Math.max(areaHeight, widgetHeight);
        if (this.widget.width != widgetWidth || this.widget.height != widgetHeight) {
            this.widget.width = widgetWidth;
            this.widget.height = widgetHeight;
            if (this.widget instanceof Layout) {
                layout = (Layout)((Object)this.widget);
                layout.invalidate();
                layout.layout();
            }
        }
        if (this.hasHScroll) {
            this.hScrollBounds.set(background.getLeftWidth(), background.getBottomHeight(), areaWidth, hScrollKnob.getTotalHeight());
            this.hScrollKnobBounds.width = Math.max(hScrollKnob.getTotalWidth(), (float)((int)(this.hScrollBounds.width * areaWidth / this.widget.width)));
            this.hScrollKnobBounds.height = hScrollKnob.getTotalHeight();
            this.hScrollKnobBounds.x = this.hScrollBounds.x + (float)((int)((this.hScrollBounds.width - this.hScrollKnobBounds.width) * this.hScrollAmount));
            this.hScrollKnobBounds.y = this.hScrollBounds.y;
        }
        if (this.hasVScroll) {
            this.vScrollBounds.set(this.width - background.getRightWidth() - vScrollKnob.getTotalWidth(), this.height - background.getTopHeight() - areaHeight, vScrollKnob.getTotalWidth(), areaHeight);
            this.vScrollKnobBounds.width = vScrollKnob.getTotalWidth();
            this.vScrollKnobBounds.height = Math.max(vScrollKnob.getTotalHeight(), (float)((int)(this.vScrollBounds.height * areaHeight / this.widget.height)));
            this.vScrollKnobBounds.x = this.vScrollBounds.x;
            this.vScrollKnobBounds.y = this.vScrollBounds.y + (float)((int)((this.vScrollBounds.height - this.vScrollKnobBounds.height) * (1.0f - this.vScrollAmount)));
        }
        this.widgetAreaBounds.set(background.getLeftWidth(), background.getBottomHeight() + (this.hasHScroll ? hScrollKnob.getTotalHeight() : 0.0f), areaWidth, areaHeight);
        this.widget.y = this.widgetAreaBounds.y - (float)(!this.hasVScroll ? (int)(this.widget.height - areaHeight) : 0) - (float)(this.hasVScroll ? (int)((this.widget.height - areaHeight) * (1.0f - this.vScrollAmount)) : 0);
        this.widget.x = this.widgetAreaBounds.x - (float)(this.hasHScroll ? (int)((this.widget.width - areaWidth) * this.hScrollAmount) : 0);
        ScissorStack.calculateScissors(this.stage.getCamera(), batchTransform, this.widgetAreaBounds, this.scissorBounds);
    }

    @Override
    public void draw(SpriteBatch batch, float parentAlpha) {
        NinePatch background = this.style.background;
        NinePatch hScrollKnob = this.style.hScrollKnob;
        NinePatch hScroll = this.style.hScroll;
        NinePatch vScrollKnob = this.style.vScrollKnob;
        NinePatch vScroll = this.style.vScroll;
        this.applyTransform(batch);
        this.calculateBoundsAndPositions(batch.getTransformMatrix());
        batch.setColor(this.color.r, this.color.g, this.color.b, this.color.a * parentAlpha);
        background.draw(batch, 0.0f, 0.0f, this.width, this.height);
        batch.flush();
        ScissorStack.pushScissors(this.scissorBounds);
        this.drawChildren(batch, parentAlpha);
        ScissorStack.popScissors();
        batch.setColor(this.color.r, this.color.g, this.color.b, this.color.a * parentAlpha);
        if (this.hasHScroll) {
            hScroll.draw(batch, this.hScrollBounds.x, this.hScrollBounds.y, this.hScrollBounds.width, this.hScrollBounds.height);
            hScrollKnob.draw(batch, this.hScrollKnobBounds.x, this.hScrollKnobBounds.y, this.hScrollKnobBounds.width, this.hScrollKnobBounds.height);
        }
        if (this.hasVScroll) {
            vScroll.draw(batch, this.vScrollBounds.x, this.vScrollBounds.y, this.vScrollBounds.width, this.vScrollBounds.height);
            vScrollKnob.draw(batch, this.vScrollKnobBounds.x, this.vScrollKnobBounds.y, this.vScrollKnobBounds.width, this.vScrollKnobBounds.height);
        }
        this.resetTransform(batch);
    }

    @Override
    public void layout() {
    }

    @Override
    public void invalidate() {
    }

    @Override
    public float getPrefWidth() {
        return 150.0f;
    }

    @Override
    public float getPrefHeight() {
        return 150.0f;
    }

    @Override
    public float getMinWidth() {
        return 0.0f;
    }

    @Override
    public float getMinHeight() {
        return 0.0f;
    }

    @Override
    public float getMaxWidth() {
        return 0.0f;
    }

    @Override
    public float getMaxHeight() {
        return 0.0f;
    }

    @Override
    public boolean touchDown(float x, float y, int pointer) {
        if (pointer != 0) {
            return false;
        }
        if (this.hasHScroll && this.hScrollBounds.contains(x, y)) {
            if (this.hScrollKnobBounds.contains(x, y)) {
                this.lastPoint.set(x, y);
                this.handlePos = this.hScrollKnobBounds.x;
                this.touchScrollH = true;
            } else {
                this.hScrollAmount = x < this.hScrollKnobBounds.x ? Math.max(0.0f, this.hScrollAmount - 0.1f) : Math.min(1.0f, this.hScrollAmount + 0.1f);
            }
            return true;
        }
        if (this.hasVScroll && this.vScrollBounds.contains(x, y)) {
            if (this.vScrollKnobBounds.contains(x, y)) {
                this.lastPoint.set(x, y);
                this.handlePos = this.vScrollKnobBounds.y;
                this.touchScrollV = true;
            } else {
                this.vScrollAmount = y < this.vScrollKnobBounds.y ? Math.min(1.0f, this.vScrollAmount + 0.1f) : Math.max(0.0f, this.vScrollAmount - 0.1f);
            }
            return true;
        }
        if (this.widgetAreaBounds.contains(x, y)) {
            return super.touchDown(x, y, pointer);
        }
        return false;
    }

    @Override
    public void touchUp(float x, float y, int pointer) {
        if (this.touchScrollH || this.touchScrollV) {
            this.touchScrollH = false;
            this.touchScrollV = false;
            return;
        }
        if (this.focusedActor[pointer] != null) {
            super.touchUp(x, y, pointer);
        }
    }

    @Override
    public void touchDragged(float x, float y, int pointer) {
        if (this.touchScrollH) {
            float scrollH;
            float delta = x - this.lastPoint.x;
            this.handlePos = scrollH = this.handlePos + delta;
            scrollH = Math.max(this.hScrollBounds.x, scrollH);
            scrollH = Math.min(this.hScrollBounds.x + this.hScrollBounds.width - this.hScrollKnobBounds.width, scrollH);
            this.hScrollAmount = (scrollH - this.hScrollBounds.x) / (this.hScrollBounds.width - this.hScrollKnobBounds.width);
            this.lastPoint.set(x, y);
        } else if (this.touchScrollV) {
            float scrollV;
            float delta = y - this.lastPoint.y;
            this.handlePos = scrollV = this.handlePos + delta;
            scrollV = Math.max(this.vScrollBounds.y, scrollV);
            scrollV = Math.min(this.vScrollBounds.y + this.vScrollBounds.height - this.vScrollKnobBounds.height, scrollV);
            this.vScrollAmount = 1.0f - (scrollV - this.vScrollBounds.y) / (this.vScrollBounds.height - this.vScrollKnobBounds.height);
            this.lastPoint.set(x, y);
        } else {
            super.touchDragged(x, y, pointer);
        }
    }

    @Override
    public Actor hit(float x, float y) {
        return x > 0.0f && x < this.width && y > 0.0f && y < this.height ? this : null;
    }

    public void setVScrollAmount(float vScrollAmount) {
        this.vScrollAmount = vScrollAmount;
    }

    public void setHScrollAmount(float hScrollAmount) {
        this.hScrollAmount = hScrollAmount;
    }

    public void setWidget(Actor widget) {
        if (widget == null) {
            throw new IllegalArgumentException("widget must not be null");
        }
        this.removeActor(this.widget);
        this.widget = widget;
        this.addActor(widget);
        this.invalidate();
    }

    public static class ScrollPaneStyle {
        public NinePatch background;
        public NinePatch hScroll;
        public NinePatch hScrollKnob;
        public NinePatch vScroll;
        public NinePatch vScrollKnob;

        public ScrollPaneStyle() {
        }

        public ScrollPaneStyle(NinePatch backgroundPatch, NinePatch hScroll, NinePatch hScrollKnob, NinePatch vScroll, NinePatch vScrollKnob) {
            this.background = backgroundPatch;
            this.hScroll = hScroll;
            this.hScrollKnob = hScrollKnob;
            this.vScroll = vScroll;
            this.vScrollKnob = vScrollKnob;
        }
    }
}

