/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class List
extends Widget {
    ListStyle style;
    String[] items;
    float itemHeight = 0.0f;
    float textOffsetX = 0.0f;
    float textOffsetY = 0.0f;
    int selected = 0;
    SelectionListener listener;
    private float prefWidth;
    private float prefHeight;

    public List(String[] items, Skin skin) {
        this(items, skin.getStyle(ListStyle.class), null);
    }

    public List(String[] items, ListStyle style) {
        this(items, style, null);
    }

    public List(String[] items, ListStyle style, String name) {
        super(name);
        this.setStyle(style);
        this.setItems(items);
        this.layout();
    }

    public void setStyle(ListStyle style) {
        this.style = style;
        if (this.items != null) {
            this.setItems(this.items);
        }
    }

    @Override
    public void layout() {
    }

    @Override
    public void draw(SpriteBatch batch, float parentAlpha) {
        BitmapFont font = this.style.font;
        NinePatch selectedPatch = this.style.selectedPatch;
        Color fontColorSelected = this.style.fontColorSelected;
        Color fontColorUnselected = this.style.fontColorUnselected;
        batch.setColor(this.color.r, this.color.g, this.color.b, this.color.a * parentAlpha);
        float posY = this.height;
        for (int i = 0; i < this.items.length; ++i) {
            if (this.selected == i) {
                selectedPatch.draw(batch, this.x, this.y + posY - this.itemHeight, Math.max(this.prefWidth, this.width), this.itemHeight);
                font.setColor(fontColorSelected.r, fontColorSelected.g, fontColorSelected.b, fontColorSelected.a * parentAlpha);
            } else {
                font.setColor(fontColorUnselected.r, fontColorUnselected.g, fontColorUnselected.b, fontColorUnselected.a * parentAlpha);
            }
            font.draw(batch, this.items[i], this.x + this.textOffsetX, this.y + posY - this.textOffsetY);
            posY -= this.itemHeight;
        }
    }

    @Override
    public boolean touchDown(float x, float y, int pointer) {
        if (pointer != 0) {
            return false;
        }
        this.selected = (int)((this.height - y) / this.itemHeight);
        this.selected = Math.max(0, this.selected);
        this.selected = Math.min(this.items.length - 1, this.selected);
        if (this.listener != null) {
            this.listener.selected(this, this.selected, this.items[this.selected]);
        }
        return true;
    }

    @Override
    public void touchUp(float x, float y, int pointer) {
    }

    @Override
    public void touchDragged(float x, float y, int pointer) {
    }

    @Override
    public Actor hit(float x, float y) {
        return x >= 0.0f && x < this.width && y >= 0.0f && y < this.height ? this : null;
    }

    public int getSelectedIndex() {
        return this.selected;
    }

    public void setSelectedIndex(int index) {
        this.selected = index;
    }

    public String getSelection() {
        if (this.items.length == 0) {
            return null;
        }
        return this.items[this.selected];
    }

    public void setSelection(int index) {
        if (index < 0 || index >= this.items.length) {
            throw new GdxRuntimeException("Index must be > 0 and < #items");
        }
        this.selected = index;
    }

    public int setSelection(String item) {
        this.selected = -1;
        int n = this.items.length;
        for (int i = 0; i < n; ++i) {
            if (!this.items[i].equals(item)) continue;
            this.selected = i;
            break;
        }
        return this.selected;
    }

    public void setItems(String[] items) {
        if (items == null) {
            throw new IllegalArgumentException("items cannot be null.");
        }
        this.items = items;
        this.selected = 0;
        BitmapFont font = this.style.font;
        NinePatch selectedPatch = this.style.selectedPatch;
        this.prefWidth = 0.0f;
        this.prefHeight = 0.0f;
        for (int i = 0; i < items.length; ++i) {
            String item = items[i];
            BitmapFont.TextBounds bounds = font.getBounds(item);
            this.prefWidth = Math.max(bounds.width, this.prefWidth);
        }
        this.itemHeight = font.getCapHeight() - font.getDescent() * 2.0f;
        this.itemHeight += selectedPatch.getTopHeight() + selectedPatch.getBottomHeight();
        this.prefWidth += selectedPatch.getLeftWidth() + selectedPatch.getRightWidth();
        this.prefHeight = (float)items.length * this.itemHeight;
        this.textOffsetX = selectedPatch.getLeftWidth();
        this.textOffsetY = selectedPatch.getTopHeight() - font.getDescent();
    }

    public String[] getItems() {
        return this.items;
    }

    @Override
    public float getPrefWidth() {
        return this.prefWidth;
    }

    @Override
    public float getPrefHeight() {
        return this.prefHeight;
    }

    public void setSelectionListener(SelectionListener listener) {
        this.listener = listener;
    }

    public static interface SelectionListener {
        public void selected(List var1, int var2, String var3);
    }

    public static class ListStyle {
        public BitmapFont font;
        public Color fontColorSelected = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        public Color fontColorUnselected = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        public NinePatch selectedPatch;

        private ListStyle() {
        }

        public ListStyle(BitmapFont font, Color fontColorSelected, Color fontColorUnselected, NinePatch selectedPatch) {
            this.font = font;
            this.fontColorSelected.set(fontColorSelected);
            this.fontColorUnselected.set(this.fontColorUnselected);
            this.selectedPatch = selectedPatch;
        }
    }
}

