/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.BitmapFontCache;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;

public class Label
extends Widget {
    LabelStyle style;
    BitmapFontCache cache;
    String text;
    private float prefWidth;
    private float prefHeight;

    public Label(String text, Skin skin) {
        this(text, skin.getStyle(LabelStyle.class), null);
    }

    public Label(String text, LabelStyle style) {
        this(text, style, null);
    }

    public Label(String text, LabelStyle style, String name) {
        super(name);
        this.text = text;
        this.setStyle(style);
        this.touchable = false;
    }

    public void setStyle(LabelStyle style) {
        this.style = style;
        this.cache = new BitmapFontCache(style.font);
        this.cache.setColor(style.fontColor);
        this.setText(this.text);
    }

    public void setText(String text) {
        this.text = text;
        BitmapFont.TextBounds bounds = this.style.font.getMultiLineBounds(text);
        this.cache.setMultiLineText(text, 0.0f, bounds.height);
        this.prefWidth = bounds.width;
        this.prefHeight = bounds.height - this.style.font.getDescent() * 2.0f;
    }

    public String getText() {
        return this.text;
    }

    public void setColor(float color) {
        this.cache.setColor(color);
    }

    public void setColor(Color tint) {
        this.cache.setColor(tint);
    }

    public void setColor(float r, float g, float b, float a) {
        this.cache.setColor(r, g, b, a);
    }

    public Color getColor() {
        return this.cache.getColor();
    }

    @Override
    public void layout() {
    }

    @Override
    public void draw(SpriteBatch batch, float parentAlpha) {
        this.cache.setColor(this.color);
        this.cache.setPosition(this.x, this.y - this.style.font.getDescent());
        this.cache.draw(batch, parentAlpha);
    }

    @Override
    public boolean touchDown(float x, float y, int pointer) {
        return false;
    }

    @Override
    public void touchUp(float x, float y, int pointer) {
    }

    @Override
    public void touchDragged(float x, float y, int pointer) {
    }

    @Override
    public Actor hit(float x, float y) {
        return null;
    }

    @Override
    public float getPrefWidth() {
        return this.prefWidth;
    }

    @Override
    public float getPrefHeight() {
        return this.prefHeight;
    }

    public static class LabelStyle {
        public BitmapFont font;
        public Color fontColor;

        public LabelStyle() {
        }

        public LabelStyle(BitmapFont font, Color fontColor) {
            this.font = font;
            this.fontColor = fontColor;
        }
    }
}

