/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;

public class Image
extends Widget {
    private TextureRegion region;
    private NinePatch patch;
    private final Scaling scaling;
    private int align = 1;
    private float imageX;
    private float imageY;
    private float imageWidth;
    private float imageHeight;

    public Image(TextureRegion region) {
        this(region, Scaling.none, null);
    }

    public Image(TextureRegion region, Scaling scaling) {
        this(region, scaling, null);
    }

    public Image(TextureRegion region, Scaling scaling, int align) {
        this(region, scaling, align, null);
    }

    public Image(TextureRegion region, Scaling scaling, String name) {
        this(region, scaling, 1, null);
    }

    public Image(TextureRegion region, Scaling scaling, int align, String name) {
        this.setRegion(region);
        this.scaling = scaling;
        this.align = align;
    }

    public Image(NinePatch patch) {
        this(patch, Scaling.none, null);
    }

    public Image(NinePatch patch, Scaling scaling) {
        this(patch, scaling, null);
    }

    public Image(NinePatch patch, Scaling scaling, int align) {
        this(patch, scaling, align, null);
    }

    public Image(NinePatch patch, Scaling scaling, String name) {
        this(patch, scaling, 1, null);
    }

    public Image(NinePatch patch, Scaling scaling, int align, String name) {
        this.setPatch(patch);
        this.scaling = scaling;
        this.align = align;
    }

    @Override
    public void layout() {
        float regionHeight;
        float regionWidth;
        if (!this.invalidated) {
            return;
        }
        this.invalidated = false;
        if (this.patch != null) {
            regionWidth = this.patch.getTotalWidth();
            regionHeight = this.patch.getTotalHeight();
        } else if (this.region != null) {
            regionWidth = this.region.getRegionWidth();
            regionHeight = this.region.getRegionHeight();
        } else {
            return;
        }
        switch (this.scaling) {
            case fill: {
                float widgetRatio = this.height / this.width;
                float regionRatio = regionHeight / regionWidth;
                float scale = regionRatio > widgetRatio ? this.width / regionWidth : this.height / regionHeight;
                this.imageWidth = regionWidth * scale;
                this.imageHeight = regionHeight * scale;
                break;
            }
            case fit: {
                float widgetRatio = this.height / this.width;
                float regionRatio = regionHeight / regionWidth;
                float scale = regionRatio < widgetRatio ? this.width / regionWidth : this.height / regionHeight;
                this.imageWidth = regionWidth * scale;
                this.imageHeight = regionHeight * scale;
                break;
            }
            case stretch: {
                this.imageWidth = this.width;
                this.imageHeight = this.height;
                break;
            }
            case stretchX: {
                this.imageWidth = this.width;
                this.imageHeight = regionHeight;
                break;
            }
            case stretchY: {
                this.imageWidth = regionWidth;
                this.imageHeight = this.height;
                break;
            }
            case none: {
                this.imageWidth = regionWidth;
                this.imageHeight = regionHeight;
            }
        }
        this.imageX = (this.align & 8) != 0 ? 0.0f : ((this.align & 0x10) != 0 ? (float)((int)(this.width - this.imageWidth)) : (float)((int)(this.width / 2.0f - this.imageWidth / 2.0f)));
        this.imageY = (this.align & 2) != 0 ? (float)((int)(this.height - this.imageHeight)) : ((this.align & 4) != 0 ? 0.0f : (float)((int)(this.height / 2.0f - this.imageHeight / 2.0f)));
    }

    @Override
    public void draw(SpriteBatch batch, float parentAlpha) {
        if (this.invalidated) {
            this.layout();
        }
        batch.setColor(this.color.r, this.color.g, this.color.b, this.color.a * parentAlpha);
        if (this.patch != null) {
            this.patch.draw(batch, this.x + this.imageX, this.y + this.imageY, this.imageWidth, this.imageHeight);
        } else if (this.region != null) {
            batch.draw(this.region, this.x + this.imageX, this.y + this.imageY, this.imageWidth, this.imageHeight);
        }
    }

    public void setRegion(TextureRegion region) {
        this.region = region;
        this.patch = null;
        this.invalidate();
    }

    public void setPatch(NinePatch patch) {
        this.patch = patch;
        this.region = null;
        this.invalidate();
    }

    @Override
    public float getMinWidth() {
        return 0.0f;
    }

    @Override
    public float getMinHeight() {
        return 0.0f;
    }

    @Override
    public float getPrefWidth() {
        return this.region.getRegionWidth();
    }

    @Override
    public float getPrefHeight() {
        return this.region.getRegionHeight();
    }

    @Override
    public boolean touchDown(float x, float y, int pointer) {
        return false;
    }

    @Override
    public void touchUp(float x, float y, int pointer) {
    }

    @Override
    public void touchDragged(float x, float y, int pointer) {
    }

    public static enum Scaling {
        fill,
        fit,
        stretch,
        stretchX,
        stretchY,
        none;

    }
}

