/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.input.GestureDetector;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Layout;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.utils.ScissorStack;

public class FlickScrollPane
extends Group
implements Layout {
    private final Stage stage;
    private Actor widget;
    protected boolean needsLayout;
    private final Rectangle widgetAreaBounds = new Rectangle();
    private final Rectangle scissorBounds = new Rectangle();
    private GestureDetector gestureDetector;
    private boolean scrollX;
    private boolean scrollY;
    float amountX;
    float amountY;
    private float maxX;
    private float maxY;
    float velocityX;
    float velocityY;
    float flingTimer;
    public boolean bounces = true;
    public float flingTime = 1.0f;
    public float bounceDistance = 50.0f;
    public float bounceSpeedMin = 30.0f;
    public float bounceSpeedMax = 200.0f;
    public boolean emptySpaceOnlyScroll;
    public boolean forceScrollX;
    public boolean forceScrollY;
    public boolean clamp = true;

    public FlickScrollPane(Actor widget, Stage stage) {
        this(widget, stage, null);
    }

    public FlickScrollPane(Actor widget, Stage stage, String name) {
        super(name);
        this.stage = stage;
        this.widget = widget;
        if (widget != null) {
            this.addActor(widget);
        }
        this.gestureDetector = new GestureDetector(new GestureDetector.GestureListener(){

            @Override
            public boolean pan(int x, int y, int deltaX, int deltaY) {
                FlickScrollPane.this.amountX -= (float)deltaX;
                FlickScrollPane.this.amountY += (float)deltaY;
                FlickScrollPane.this.clamp();
                return false;
            }

            @Override
            public boolean fling(float x, float y) {
                if (Math.abs(x) > 150.0f) {
                    FlickScrollPane.this.flingTimer = FlickScrollPane.this.flingTime;
                    FlickScrollPane.this.velocityX = x;
                }
                if (Math.abs(y) > 150.0f) {
                    FlickScrollPane.this.flingTimer = FlickScrollPane.this.flingTime;
                    FlickScrollPane.this.velocityY = -y;
                }
                return FlickScrollPane.this.flingTimer > 0.0f;
            }

            @Override
            public boolean touchDown(int x, int y, int pointer) {
                FlickScrollPane.this.flingTimer = 0.0f;
                return true;
            }

            @Override
            public boolean zoom(float originalDistance, float currentDistance) {
                return false;
            }

            @Override
            public boolean tap(int x, int y, int count) {
                return FlickScrollPane.this.tap(x, y);
            }

            @Override
            public boolean longPress(int x, int y) {
                return false;
            }
        });
    }

    boolean tap(int x, int y) {
        this.focus(null, 0);
        if (!super.touchDown(x, y, 0)) {
            return false;
        }
        Actor actor = this.focusedActor[0];
        this.toLocalCoordinates(actor, this.point);
        actor.touchUp(this.point.x, this.point.y, 0);
        return true;
    }

    public void toLocalCoordinates(Actor actor, Vector2 point) {
        if (actor.parent == this) {
            return;
        }
        this.toLocalCoordinates(actor.parent, point);
        Group.toChildCoordinates(actor, point.x, point.y, point);
    }

    void clamp() {
        if (!this.clamp) {
            return;
        }
        if (this.bounces) {
            this.amountX = Math.max(-this.bounceDistance, this.amountX);
            this.amountX = Math.min(this.maxX + this.bounceDistance, this.amountX);
            this.amountY = Math.max(-this.bounceDistance, this.amountY);
            this.amountY = Math.min(this.maxY + this.bounceDistance, this.amountY);
        } else {
            this.amountX = Math.max(0.0f, this.amountX);
            this.amountX = Math.min(this.maxX, this.amountX);
            this.amountY = Math.max(0.0f, this.amountY);
            this.amountY = Math.min(this.maxY, this.amountY);
        }
    }

    @Override
    public void act(float delta) {
        if (this.flingTimer > 0.0f) {
            float alpha = this.flingTimer / this.flingTime;
            alpha = alpha * alpha * alpha;
            this.amountX -= this.velocityX * alpha * delta;
            this.amountY -= this.velocityY * alpha * delta;
            this.clamp();
            if (this.amountX == -this.bounceDistance) {
                this.velocityX = 0.0f;
            }
            if (this.amountX >= this.maxX + this.bounceDistance) {
                this.velocityX = 0.0f;
            }
            if (this.amountY == -this.bounceDistance) {
                this.velocityY = 0.0f;
            }
            if (this.amountY >= this.maxY + this.bounceDistance) {
                this.velocityY = 0.0f;
            }
            this.flingTimer -= delta;
        }
        if (this.bounces && !this.gestureDetector.isPanning()) {
            if (this.amountX < 0.0f) {
                this.amountX += (this.bounceSpeedMin + (this.bounceSpeedMax - this.bounceSpeedMin) * -this.amountX / this.bounceDistance) * delta;
                if (this.amountX > 0.0f) {
                    this.amountX = 0.0f;
                }
            } else if (this.amountX > this.maxX) {
                this.amountX -= (this.bounceSpeedMin + (this.bounceSpeedMax - this.bounceSpeedMin) * -(this.maxX - this.amountX) / this.bounceDistance) * delta;
                if (this.amountX < this.maxX) {
                    this.amountX = this.maxX;
                }
            }
            if (this.amountY < 0.0f) {
                this.amountY += (this.bounceSpeedMin + (this.bounceSpeedMax - this.bounceSpeedMin) * -this.amountY / this.bounceDistance) * delta;
                if (this.amountY > 0.0f) {
                    this.amountY = 0.0f;
                }
            } else if (this.amountY > this.maxY) {
                this.amountY -= (this.bounceSpeedMin + (this.bounceSpeedMax - this.bounceSpeedMin) * -(this.maxY - this.amountY) / this.bounceDistance) * delta;
                if (this.amountY < this.maxY) {
                    this.amountY = this.maxY;
                }
            }
        }
    }

    private void calculateBoundsAndPositions(Matrix4 batchTransform) {
        float widgetHeight;
        float widgetWidth;
        if (this.widget instanceof Layout) {
            Layout layout = (Layout)((Object)this.widget);
            widgetWidth = layout.getPrefWidth();
            widgetHeight = layout.getPrefHeight();
        } else {
            widgetWidth = this.widget.width;
            widgetHeight = this.widget.height;
        }
        this.scrollX = widgetWidth > this.width || this.forceScrollX;
        this.scrollY = widgetHeight > this.height || this.forceScrollY;
        widgetWidth = Math.max(this.width, widgetWidth);
        widgetHeight = Math.max(this.height, widgetHeight);
        if (this.widget.width != widgetWidth || this.widget.height != widgetHeight) {
            this.widget.width = widgetWidth;
            this.widget.height = widgetHeight;
            this.needsLayout = true;
        }
        this.widgetAreaBounds.set(0.0f, 0.0f, this.width, this.height);
        this.maxX = this.widget.width - this.width;
        this.maxY = this.widget.height - this.height;
        this.widget.y = (float)((int)(this.scrollY ? this.amountY : this.maxY)) - this.widget.height + this.height;
        this.widget.x = -((int)(this.scrollX ? this.amountX : 0.0f));
        ScissorStack.calculateScissors(this.stage.getCamera(), batchTransform, this.widgetAreaBounds, this.scissorBounds);
    }

    @Override
    public void draw(SpriteBatch batch, float parentAlpha) {
        if (this.widget == null) {
            return;
        }
        this.applyTransform(batch);
        this.calculateBoundsAndPositions(batch.getTransformMatrix());
        if (this.needsLayout) {
            this.layout();
        }
        ScissorStack.pushScissors(this.scissorBounds);
        this.drawChildren(batch, parentAlpha);
        ScissorStack.popScissors();
        this.resetTransform(batch);
    }

    @Override
    public void layout() {
        if (!this.needsLayout) {
            return;
        }
        this.needsLayout = false;
        if (this.widget instanceof Layout) {
            Layout layout = (Layout)((Object)this.widget);
            layout.invalidate();
            layout.layout();
        }
    }

    @Override
    public void invalidate() {
        this.needsLayout = true;
    }

    @Override
    public boolean touchDown(float x, float y, int pointer) {
        if (pointer != 0) {
            return false;
        }
        if (this.emptySpaceOnlyScroll && super.touchDown(x, y, pointer)) {
            return true;
        }
        return this.gestureDetector.touchDown((int)x, (int)y, pointer, 0);
    }

    @Override
    public void touchUp(float x, float y, int pointer) {
        this.clamp();
        this.gestureDetector.touchUp((int)x, (int)y, pointer, 0);
        if (this.focusedActor[pointer] != null) {
            super.touchUp(x, y, pointer);
        }
    }

    @Override
    public void touchDragged(float x, float y, int pointer) {
        this.gestureDetector.touchDragged((int)x, (int)y, pointer);
        super.touchDragged(x, y, pointer);
    }

    @Override
    public Actor hit(float x, float y) {
        return x > 0.0f && x < this.width && y > 0.0f && y < this.height ? this : null;
    }

    public void setScrollX(float pixels) {
        this.amountX = pixels;
    }

    public float getScrollX() {
        return this.amountX;
    }

    public void setScrollY(float pixels) {
        this.amountY = pixels;
    }

    public float getScrollY() {
        return this.amountY;
    }

    public void setWidget(Actor widget) {
        if (this.widget != null) {
            this.removeActor(this.widget);
        }
        this.widget = widget;
        if (widget != null) {
            this.addActor(widget);
        }
    }

    public Actor getWidget() {
        return this.widget;
    }

    public boolean isPanning() {
        return this.gestureDetector.isPanning();
    }

    public float getVelocityX() {
        if (this.flingTimer <= 0.0f) {
            return 0.0f;
        }
        float alpha = this.flingTimer / this.flingTime;
        alpha = alpha * alpha * alpha;
        return this.velocityX * alpha * alpha * alpha;
    }

    public float getVelocityY() {
        return this.velocityY;
    }

    @Override
    public float getPrefWidth() {
        return 150.0f;
    }

    @Override
    public float getPrefHeight() {
        return 150.0f;
    }

    @Override
    public float getMinWidth() {
        return 0.0f;
    }

    @Override
    public float getMinHeight() {
        return 0.0f;
    }

    @Override
    public float getMaxWidth() {
        return 0.0f;
    }

    @Override
    public float getMaxHeight() {
        return 0.0f;
    }
}

