/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.ui.utils.ScissorStack;

public class ComboBox
extends Widget {
    final Stage stage;
    ComboBoxStyle style;
    String[] items;
    int selection = 0;
    final BitmapFont.TextBounds bounds = new BitmapFont.TextBounds();
    final Vector2 screenCoords = new Vector2();
    ComboList list = null;
    SelectionListener listener;
    private float prefWidth;
    private float prefHeight;
    Vector2 stageCoords = new Vector2();

    public ComboBox(String[] items, Stage stage, Skin skin) {
        this(items, stage, skin.getStyle(ComboBoxStyle.class), null);
    }

    public ComboBox(String[] items, Stage stage, ComboBoxStyle style) {
        this(items, stage, style, null);
    }

    public ComboBox(String[] items, Stage stage, ComboBoxStyle style, String name) {
        super(name);
        this.setStyle(style);
        this.setItems(items);
        this.stage = stage;
        this.layout();
    }

    public void setStyle(ComboBoxStyle style) {
        this.style = style;
        if (this.items != null) {
            this.setItems(this.items);
        }
    }

    public void setItems(String[] items) {
        if (items == null) {
            throw new IllegalArgumentException("items cannot be null.");
        }
        this.items = items;
        NinePatch background = this.style.background;
        BitmapFont font = this.style.font;
        this.prefHeight = Math.max(background.getTopHeight() + background.getBottomHeight() + font.getCapHeight() - font.getDescent() * 2.0f, background.getTotalHeight());
        float max = 0.0f;
        for (int i = 0; i < items.length; ++i) {
            max = Math.max(font.getBounds((CharSequence)items[i]).width, max);
        }
        this.width = this.prefWidth = background.getLeftWidth() + background.getRightWidth() + max;
        this.height = this.prefHeight;
    }

    @Override
    public void layout() {
    }

    @Override
    public void draw(SpriteBatch batch, float parentAlpha) {
        NinePatch background = this.style.background;
        BitmapFont font = this.style.font;
        Color fontColor = this.style.fontColor;
        batch.setColor(this.color.r, this.color.g, this.color.b, this.color.a * parentAlpha);
        background.draw(batch, this.x, this.y, this.width, this.height);
        if (this.items.length > 0) {
            float availableWidth = this.width - background.getLeftWidth() - background.getRightWidth();
            int numGlyphs = font.computeVisibleGlyphs(this.items[this.selection], 0, this.items[this.selection].length(), availableWidth);
            this.bounds.set(font.getBounds(this.items[this.selection]));
            float textY = (int)(this.height / 2.0f) + (int)(this.bounds.height / 2.0f);
            font.setColor(fontColor.r, fontColor.g, fontColor.b, fontColor.a * parentAlpha);
            font.draw(batch, this.items[this.selection], this.x + background.getLeftWidth(), this.y + textY, 0, numGlyphs);
        }
        ScissorStack.toWindowCoordinates(this.stage.getCamera(), batch.getTransformMatrix(), this.screenCoords.set(this.x, this.y));
    }

    @Override
    public boolean touchDown(float x, float y, int pointer) {
        if (pointer != 0) {
            return false;
        }
        if (this.list != null) {
            this.stage.removeActor(this.list);
        }
        this.stage.toStageCoordinates((int)this.screenCoords.x, (int)this.screenCoords.y, this.stageCoords);
        this.list = new ComboList(this.name + "-list", this.stageCoords.x, this.stageCoords.y);
        this.stage.addActor(this.list);
        return true;
    }

    @Override
    public void touchUp(float x, float y, int pointer) {
        this.stage.getRoot().focus(this.list, pointer);
    }

    @Override
    public void touchDragged(float x, float y, int pointer) {
    }

    public void setSelectionListener(SelectionListener listener) {
        this.listener = listener;
    }

    public void setSelection(int selection) {
        this.selection = selection;
    }

    public int getSelectionIndex() {
        return this.selection;
    }

    public String getSelection() {
        return this.items[this.selection];
    }

    @Override
    public float getPrefWidth() {
        return this.prefWidth;
    }

    @Override
    public float getPrefHeight() {
        return this.prefHeight;
    }

    protected class ComboList
    extends Actor {
        Vector2 oldScreenCoords;
        float itemHeight;
        float textOffsetX;
        float textOffsetY;
        int selected;

        public ComboList(String name, float x, float y) {
            super(name);
            this.oldScreenCoords = new Vector2();
            this.itemHeight = 0.0f;
            this.textOffsetX = 0.0f;
            this.textOffsetY = 0.0f;
            this.selected = ComboBox.this.selection;
            this.x = x;
            this.y = y;
            this.width = ComboBox.this.width;
            this.height = 100.0f;
            this.oldScreenCoords.set(ComboBox.this.screenCoords);
            ComboBox.this.stage.getRoot().focus(this, 0);
            this.layout();
        }

        private void layout() {
            BitmapFont font = ComboBox.this.style.font;
            NinePatch listSelection = ComboBox.this.style.listSelection;
            float prefWidth = 0.0f;
            float prefHeight = 0.0f;
            for (int i = 0; i < ComboBox.this.items.length; ++i) {
                String item = ComboBox.this.items[i];
                BitmapFont.TextBounds bounds = font.getBounds(item);
                prefWidth = Math.max(bounds.width, prefWidth);
            }
            this.itemHeight = font.getCapHeight() + -font.getDescent() * 2.0f;
            this.itemHeight += listSelection.getTopHeight() + listSelection.getBottomHeight();
            this.itemHeight *= ComboBox.this.parent.scaleY;
            prefHeight = (float)ComboBox.this.items.length * this.itemHeight;
            this.textOffsetX = listSelection.getLeftWidth();
            this.textOffsetY = listSelection.getTopHeight() + -font.getDescent();
            this.width = Math.max(prefWidth += listSelection.getLeftWidth() + listSelection.getRightWidth(), ComboBox.this.width);
            this.width *= ComboBox.this.parent.scaleX;
            this.height = prefHeight;
            this.y -= this.height;
        }

        @Override
        public void draw(SpriteBatch batch, float parentAlpha) {
            NinePatch listBackground = ComboBox.this.style.listBackground;
            NinePatch listSelection = ComboBox.this.style.listSelection;
            BitmapFont font = ComboBox.this.style.font;
            Color fontColor = ComboBox.this.style.fontColor;
            batch.setColor(this.color.r, this.color.g, this.color.b, this.color.a * parentAlpha);
            listBackground.draw(batch, this.x, this.y, this.width, this.height);
            float posY = this.height;
            for (int i = 0; i < ComboBox.this.items.length; ++i) {
                if (this.selected == i) {
                    listSelection.draw(batch, this.x, this.y + posY - this.itemHeight, this.width, this.itemHeight);
                }
                font.setColor(fontColor.r, fontColor.g, fontColor.b, fontColor.a * parentAlpha);
                font.setScale(ComboBox.this.parent.scaleX, ComboBox.this.parent.scaleY);
                font.draw(batch, ComboBox.this.items[i], this.x + this.textOffsetX, this.y + posY - this.textOffsetY);
                font.setScale(1.0f, 1.0f);
                posY -= this.itemHeight;
            }
        }

        @Override
        public boolean touchDown(float x, float y, int pointer) {
            if (pointer != 0 || this.hit(x, y) == null) {
                return false;
            }
            this.selected = (int)((this.height - y) / this.itemHeight);
            this.selected = Math.max(0, this.selected);
            ComboBox.this.selection = this.selected = Math.min(ComboBox.this.items.length - 1, this.selected);
            if (ComboBox.this.items.length > 0 && ComboBox.this.listener != null) {
                ComboBox.this.listener.selected(ComboBox.this, this.selected, ComboBox.this.items[this.selected]);
            }
            return true;
        }

        @Override
        public void touchUp(float x, float y, int pointer) {
            ComboBox.this.stage.removeActor(this);
        }

        @Override
        public void touchDragged(float x, float y, int pointer) {
        }

        @Override
        public boolean touchMoved(float x, float y) {
            if (this.hit(x, y) != null) {
                this.selected = (int)((this.height - y) / this.itemHeight);
                this.selected = Math.max(0, this.selected);
                this.selected = Math.min(ComboBox.this.items.length - 1, this.selected);
            }
            return true;
        }

        @Override
        public Actor hit(float x, float y) {
            return x > 0.0f && x < this.width && y > 0.0f && y < this.height ? this : null;
        }

        @Override
        public void act(float delta) {
            if (ComboBox.this.screenCoords.x != this.oldScreenCoords.x || ComboBox.this.screenCoords.y != this.oldScreenCoords.y) {
                ComboBox.this.stage.removeActor(this);
            }
        }
    }

    public static interface SelectionListener {
        public void selected(ComboBox var1, int var2, String var3);
    }

    public static class ComboBoxStyle {
        public NinePatch background;
        public NinePatch listBackground;
        public NinePatch listSelection;
        public BitmapFont font;
        public Color fontColor = new Color(1.0f, 1.0f, 1.0f, 1.0f);

        public ComboBoxStyle() {
        }

        public ComboBoxStyle(BitmapFont font, Color fontColor, NinePatch background, NinePatch listBackground, NinePatch listSelection) {
            this.background = background;
            this.listBackground = listBackground;
            this.listSelection = listSelection;
            this.font = font;
            this.fontColor.set(fontColor);
        }
    }
}

