/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;

public class CheckBox
extends Button {
    private Image image;

    public CheckBox(String text, CheckBoxStyle style) {
        this(text, style, null);
    }

    public CheckBox(String text, Skin skin) {
        this(text, skin.getStyle(CheckBoxStyle.class), null);
    }

    public CheckBox(String text, CheckBoxStyle style, String name) {
        super(style, name);
        this.image = new Image(style.checkboxOff);
        this.add(this.image);
        this.add(new Label(text, style));
    }

    @Override
    public void click() {
        super.click();
        this.image.setRegion(this.isChecked ? ((CheckBoxStyle)this.style).checkboxOn : ((CheckBoxStyle)this.style).checkboxOff);
    }

    public static class CheckBoxStyle
    extends Button.ButtonStyle {
        public TextureRegion checkboxOn;
        public TextureRegion checkboxOff;

        public CheckBoxStyle() {
        }

        public CheckBoxStyle(TextureRegion checkboxOff, TextureRegion checkboxOn, BitmapFont font, Color fontColor) {
            this.checkboxOff = checkboxOff;
            this.checkboxOn = checkboxOn;
            this.font = font;
            this.fontColor = fontColor;
        }
    }
}

