/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.ClickListener;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.tablelayout.Table;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class Button
extends Table {
    public ButtonStyle style;
    public boolean isChecked;
    ClickListener listener;

    public Button(Skin skin) {
        this(skin.getStyle(ButtonStyle.class), null);
    }

    public Button(ButtonStyle style) {
        this(style, null);
    }

    public Button(Actor child, Skin skin) {
        this(child, skin.getStyle(ButtonStyle.class));
    }

    public Button(Actor child, ButtonStyle style) {
        this(style, null);
        this.add(child);
    }

    public Button(String text, Skin skin) {
        this(skin.getStyle(ButtonStyle.class), null);
        this.setText(text);
    }

    public Button(String text, ButtonStyle style) {
        this(style, null);
        this.setText(text);
    }

    public Button(String text, ButtonStyle style, String name) {
        this(style, name);
        this.setText(text);
    }

    public Button(ButtonStyle style, String name) {
        super(name);
        this.setStyle(style);
        super.setClickListener(new ClickListener(){

            @Override
            public void click(Actor actor) {
                boolean bl = Button.this.isChecked = !Button.this.isChecked;
                if (Button.this.listener != null) {
                    Button.this.listener.click(actor);
                }
            }
        });
    }

    public void setStyle(ButtonStyle style) {
        this.style = style;
        this.setBackground(this.isPressed ? style.down : style.up);
    }

    @Override
    public void setClickListener(ClickListener listener) {
        this.listener = listener;
    }

    public void setText(String text) {
        if (this.children.isEmpty()) {
            this.add(new Label(text, this.style));
            return;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            Actor child = (Actor)this.children.get(i);
            if (!(child instanceof Label)) continue;
            ((Label)child).setText(text);
            return;
        }
        throw new GdxRuntimeException("No child label was found.");
    }

    public String getText() {
        for (int i = 0; i < this.children.size(); ++i) {
            Actor child = (Actor)this.children.get(i);
            if (!(child instanceof Label)) continue;
            return ((Label)child).getText();
        }
        throw new GdxRuntimeException("No child label was found.");
    }

    @Override
    public void draw(SpriteBatch batch, float parentAlpha) {
        Actor child;
        int i;
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        if (this.isPressed) {
            this.setBackground(this.style.down == null ? this.style.up : this.style.down);
            offsetX = this.style.pressedOffsetX;
            offsetY = this.style.pressedOffsetY;
        } else {
            if (this.style.checked == null) {
                this.setBackground(this.style.up);
            } else {
                this.setBackground(this.isChecked ? this.style.checked : this.style.up);
            }
            offsetX = this.style.unpressedOffsetX;
            offsetY = this.style.unpressedOffsetY;
        }
        for (i = 0; i < this.children.size(); ++i) {
            child = (Actor)this.children.get(i);
            child.x += offsetX;
            child.y += offsetY;
        }
        super.draw(batch, parentAlpha);
        for (i = 0; i < this.children.size(); ++i) {
            child = (Actor)this.children.get(i);
            child.x -= offsetX;
            child.y -= offsetY;
        }
    }

    public static class ButtonStyle
    extends Label.LabelStyle {
        public NinePatch down;
        public NinePatch up;
        public NinePatch checked;
        public float pressedOffsetX;
        public float pressedOffsetY;
        public float unpressedOffsetX;
        public float unpressedOffsetY;

        public ButtonStyle() {
        }

        public ButtonStyle(NinePatch down, NinePatch up, NinePatch checked, float pressedOffsetX, float pressedOffsetY, float unpressedOffsetX, float unpressedOffsetY, BitmapFont font, Color fontColor) {
            super(font, fontColor);
            this.down = down;
            this.up = up;
            this.checked = checked;
            this.pressedOffsetX = pressedOffsetX;
            this.pressedOffsetY = pressedOffsetY;
            this.unpressedOffsetX = unpressedOffsetX;
            this.unpressedOffsetY = unpressedOffsetY;
        }
    }
}

