/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.actors;

import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.BitmapFontCache;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Layout;

public class Label
extends Actor
implements Layout {
    public BitmapFontCache cache;
    public VAlignment valign = VAlignment.BOTTOM;
    public String text;
    public final BitmapFont.TextBounds bounds = new BitmapFont.TextBounds();
    private WrapType wrapType;
    private BitmapFont.HAlignment halign;
    private float lastWidth = -1.0f;

    public Label(String name, BitmapFont font) {
        super(name);
        this.cache = new BitmapFontCache(font);
    }

    public Label(String name, BitmapFont font, String text) {
        this(name, font);
        this.setText(text);
    }

    public void setText(String text) {
        this.text = text;
        this.wrapType = WrapType.singleLine;
        this.bounds.set(this.cache.setText(text, 0.0f, this.cache.getFont().isFlipped() ? 0.0f : this.cache.getFont().getCapHeight()));
        this.width = this.bounds.width;
        this.height = this.bounds.height;
    }

    public void setMultiLineText(String text) {
        this.text = text;
        this.wrapType = WrapType.multiLine;
        this.bounds.set(this.cache.getFont().getMultiLineBounds(text));
        this.cache.setMultiLineText(text, 0.0f, this.cache.getFont().isFlipped() ? 0.0f : this.bounds.height);
        this.width = this.bounds.width;
        this.height = this.bounds.height;
    }

    public void setWrappedText(String text, BitmapFont.HAlignment halign) {
        this.text = text;
        this.halign = halign;
        this.wrapType = WrapType.wrapped;
        this.bounds.set(this.cache.getFont().getWrappedBounds(text, this.width));
        this.cache.setWrappedText(text, 0.0f, this.cache.getFont().isFlipped() ? 0.0f : this.bounds.height, this.width, halign);
    }

    public void setFont(BitmapFont font) {
        this.cache = new BitmapFontCache(font);
        switch (this.wrapType) {
            case singleLine: {
                this.setText(this.text);
                break;
            }
            case multiLine: {
                this.setMultiLineText(this.text);
                break;
            }
            case wrapped: {
                this.setWrappedText(this.text, this.halign);
            }
        }
    }

    @Override
    public void draw(SpriteBatch batch, float parentAlpha) {
        this.cache.setColor(this.color.r, this.color.g, this.color.b, this.color.a * parentAlpha);
        switch (this.valign) {
            case TOP: {
                if (this.cache.getFont().isFlipped()) {
                    this.cache.setPosition(this.x, this.y);
                    break;
                }
                this.cache.setPosition(this.x, this.y + this.height - this.bounds.height);
                break;
            }
            case CENTER: {
                this.cache.setPosition(this.x, this.y + (this.height - this.bounds.height) / 2.0f);
                break;
            }
            case BOTTOM: {
                if (this.cache.getFont().isFlipped()) {
                    this.cache.setPosition(this.x, this.y + this.height - this.bounds.height);
                    break;
                }
                this.cache.setPosition(this.x, this.y);
            }
        }
        this.cache.draw(batch);
    }

    @Override
    public boolean touchDown(float x, float y, int pointer) {
        if (!this.touchable) {
            return false;
        }
        return x > 0.0f && y > 0.0f && x < this.width && y < this.height;
    }

    @Override
    public void touchUp(float x, float y, int pointer) {
    }

    @Override
    public void touchDragged(float x, float y, int pointer) {
    }

    @Override
    public Actor hit(float x, float y) {
        return x > 0.0f && y > 0.0f && x < this.width && y < this.height ? this : null;
    }

    @Override
    public void layout() {
        if (this.wrapType == WrapType.wrapped && this.lastWidth != this.width) {
            this.setWrappedText(this.text, this.halign);
        }
        this.lastWidth = this.width;
    }

    @Override
    public void invalidate() {
        this.lastWidth = -1.0f;
    }

    @Override
    public float getPrefWidth() {
        switch (this.wrapType) {
            case singleLine: {
                return this.cache.getFont().getBounds((CharSequence)this.text).width * this.scaleX;
            }
            case multiLine: {
                return this.cache.getFont().getMultiLineBounds((CharSequence)this.text).width * this.scaleX;
            }
        }
        return 0.0f;
    }

    @Override
    public float getPrefHeight() {
        switch (this.wrapType) {
            case singleLine: {
                return this.cache.getFont().getBounds((CharSequence)this.text).height * this.scaleY;
            }
            case multiLine: {
                return this.cache.getFont().getMultiLineBounds((CharSequence)this.text).height * this.scaleY;
            }
        }
        return 0.0f;
    }

    @Override
    public float getMinWidth() {
        return 0.0f;
    }

    @Override
    public float getMinHeight() {
        return 0.0f;
    }

    @Override
    public float getMaxWidth() {
        return 0.0f;
    }

    @Override
    public float getMaxHeight() {
        return 0.0f;
    }

    private static enum WrapType {
        singleLine,
        multiLine,
        wrapped;

    }

    public static enum VAlignment {
        TOP,
        CENTER,
        BOTTOM;

    }
}

