/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.actions;

import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.actions.ActionResetingPool;

public class Delay
extends Action {
    static final ActionResetingPool<Delay> pool = new ActionResetingPool<Delay>(4, 100){

        @Override
        protected Delay newObject() {
            return new Delay();
        }
    };
    protected float taken;
    protected float duration;
    protected Action action;

    public static Delay $(Action action, float duration) {
        Delay delay = (Delay)pool.obtain();
        delay.duration = duration;
        delay.action = action;
        return delay;
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public void setTarget(Actor actor) {
        this.action.setTarget(actor);
        this.taken = 0.0f;
    }

    @Override
    public void act(float delta) {
        this.taken += delta;
        if (this.taken > this.duration) {
            this.callActionCompletedListener();
            this.action.act(delta);
            if (this.action.isDone()) {
                this.action.callActionCompletedListener();
            }
        }
    }

    @Override
    public boolean isDone() {
        return this.taken > this.duration && this.action.isDone();
    }

    @Override
    public void finish() {
        pool.free(this);
        this.action.finish();
        super.finish();
    }

    @Override
    public Action copy() {
        return Delay.$(this.action.copy(), this.duration);
    }

    @Override
    public Actor getTarget() {
        return this.action.getTarget();
    }
}

