/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.utils.Disposable;
import java.util.List;

public class Stage
extends InputAdapter
implements Disposable {
    protected float width;
    protected float height;
    protected float centerX;
    protected float centerY;
    protected boolean stretch;
    protected final Group root;
    protected final SpriteBatch batch;
    protected Camera camera;
    final Vector2 point = new Vector2();
    final Vector2 coords = new Vector2();
    final Vector3 tmp = new Vector3();

    public Stage(float width, float height, boolean stretch) {
        this.width = width;
        this.height = height;
        this.stretch = stretch;
        this.root = new Group("root");
        this.batch = new SpriteBatch();
        this.camera = new OrthographicCamera();
        this.setViewport(width, height, stretch);
    }

    public void setViewport(float width, float height, boolean stretch) {
        if (!stretch) {
            if (width > height && width / (float)Gdx.graphics.getWidth() <= height / (float)Gdx.graphics.getHeight()) {
                float toDeviceSpace = (float)Gdx.graphics.getHeight() / height;
                float toViewportSpace = height / (float)Gdx.graphics.getHeight();
                float deviceWidth = width * toDeviceSpace;
                this.width = width + ((float)Gdx.graphics.getWidth() - deviceWidth) * toViewportSpace;
                this.height = height;
            } else {
                float toDeviceSpace = (float)Gdx.graphics.getWidth() / width;
                float toViewportSpace = width / (float)Gdx.graphics.getWidth();
                float deviceHeight = height * toDeviceSpace;
                this.height = height + ((float)Gdx.graphics.getHeight() - deviceHeight) * toViewportSpace;
                this.width = width;
            }
        } else {
            this.width = width;
            this.height = height;
        }
        this.stretch = stretch;
        this.centerX = this.width / 2.0f;
        this.centerY = this.height / 2.0f;
        this.camera.position.set(this.centerX, this.centerY, 0.0f);
        this.camera.viewportWidth = this.width;
        this.camera.viewportHeight = this.height;
    }

    public float width() {
        return this.width;
    }

    public float height() {
        return this.height;
    }

    public int left() {
        return 0;
    }

    public float right() {
        return this.width - 1.0f;
    }

    public float top() {
        return this.height - 1.0f;
    }

    public float bottom() {
        return 0.0f;
    }

    public float centerX() {
        return this.centerX;
    }

    public float centerY() {
        return this.centerY;
    }

    public boolean isStretched() {
        return this.stretch;
    }

    public Actor findActor(String name) {
        return this.root.findActor(name);
    }

    public List<Actor> getActors() {
        return this.root.getActors();
    }

    public List<Group> getGroups() {
        return this.root.getGroups();
    }

    @Override
    public boolean touchDown(int x, int y, int pointer, int button) {
        this.toStageCoordinates(x, y, this.coords);
        Group.toChildCoordinates(this.root, this.coords.x, this.coords.y, this.point);
        return this.root.touchDown(this.point.x, this.point.y, pointer);
    }

    @Override
    public boolean touchUp(int x, int y, int pointer, int button) {
        Actor actor = this.root.focusedActor[pointer];
        if (actor == null) {
            return false;
        }
        this.toStageCoordinates(x, y, this.coords);
        Group.toChildCoordinates(this.root, this.coords.x, this.coords.y, this.point);
        this.root.touchUp(this.point.x, this.point.y, pointer);
        return true;
    }

    @Override
    public boolean touchDragged(int x, int y, int pointer) {
        boolean foundFocusedActor = false;
        int n = this.root.focusedActor.length;
        for (int i = 0; i < n; ++i) {
            if (this.root.focusedActor[i] == null) continue;
            foundFocusedActor = true;
            break;
        }
        if (!foundFocusedActor) {
            return false;
        }
        this.toStageCoordinates(x, y, this.coords);
        Group.toChildCoordinates(this.root, this.coords.x, this.coords.y, this.point);
        this.root.touchDragged(this.point.x, this.point.y, pointer);
        return true;
    }

    @Override
    public boolean touchMoved(int x, int y) {
        this.toStageCoordinates(x, y, this.coords);
        Group.toChildCoordinates(this.root, this.coords.x, this.coords.y, this.point);
        return this.root.touchMoved(this.point.x, this.point.y);
    }

    @Override
    public boolean scrolled(int amount) {
        return this.root.scrolled(amount);
    }

    @Override
    public boolean keyDown(int keycode) {
        return this.root.keyDown(keycode);
    }

    @Override
    public boolean keyUp(int keycode) {
        return this.root.keyUp(keycode);
    }

    @Override
    public boolean keyTyped(char character) {
        return this.root.keyTyped(character);
    }

    public void act(float delta) {
        this.root.act(delta);
    }

    public void draw() {
        this.camera.update();
        this.batch.setProjectionMatrix(this.camera.combined);
        this.batch.begin();
        this.root.draw(this.batch, 1.0f);
        this.batch.end();
    }

    @Override
    public void dispose() {
        this.batch.dispose();
    }

    public void addActor(Actor actor) {
        this.root.addActor(actor);
    }

    public String graphToString() {
        StringBuilder buffer = new StringBuilder();
        this.graphToString(buffer, this.root, 0);
        return buffer.toString();
    }

    private void graphToString(StringBuilder buffer, Actor actor, int level) {
        for (int i = 0; i < level; ++i) {
            buffer.append(' ');
        }
        buffer.append(actor);
        buffer.append("\n");
        if (actor instanceof Group) {
            Group group = (Group)actor;
            for (int i = 0; i < group.getActors().size(); ++i) {
                this.graphToString(buffer, group.getActors().get(i), level + 1);
            }
        }
    }

    public Group getRoot() {
        return this.root;
    }

    public SpriteBatch getSpriteBatch() {
        return this.batch;
    }

    public Camera getCamera() {
        return this.camera;
    }

    public void setCamera(Camera camera) {
        this.camera = camera;
    }

    public Actor getLastTouchedChild() {
        return this.root.lastTouchedChild;
    }

    public Actor hit(float x, float y) {
        Group.toChildCoordinates(this.root, x, y, this.point);
        return this.root.hit(this.point.x, this.point.y);
    }

    public void toStageCoordinates(int x, int y, Vector2 out) {
        this.camera.unproject(this.tmp.set(x, y, 0.0f));
        out.x = this.tmp.x;
        out.y = this.tmp.y;
    }

    public void clear() {
        this.root.clear();
    }

    public void removeActor(Actor actor) {
        this.root.removeActorRecursive(actor);
    }

    public void unfocusAll() {
        this.root.unfocusAll();
    }
}

