/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.utils.ObjectMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class Group
extends Actor {
    public static Texture debugTexture;
    public static boolean debug;
    protected final List<Actor> children;
    protected final List<Actor> immutableChildren;
    protected final List<Group> groups;
    protected final List<Group> immutableGroups;
    protected final ObjectMap<String, Actor> namesToActors;
    protected final Matrix3 localTransform = new Matrix3();
    protected final Matrix3 worldTransform = new Matrix3();
    protected final Matrix4 batchTransform = new Matrix4();
    protected final Matrix4 oldBatchTransform = new Matrix4();
    public boolean transform = true;
    public Actor lastTouchedChild;
    public Actor[] focusedActor = new Actor[20];
    public Actor keyboardFocusedActor = null;
    public Actor scrollFocusedActor = null;
    protected final Vector2 point = new Vector2();

    public Group() {
        this(null);
    }

    public Group(String name) {
        super(name);
        this.children = new ArrayList<Actor>();
        this.immutableChildren = Collections.unmodifiableList(this.children);
        this.groups = new ArrayList<Group>();
        this.immutableGroups = Collections.unmodifiableList(this.groups);
        this.namesToActors = new ObjectMap();
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        for (int i = 0; i < this.children.size(); ++i) {
            Actor child = this.children.get(i);
            child.act(delta);
            if (!child.isMarkedToRemove()) continue;
            child.markToRemove(false);
            this.removeActor(child);
            --i;
        }
    }

    @Override
    public void draw(SpriteBatch batch, float parentAlpha) {
        if (!this.visible) {
            return;
        }
        if (debug && debugTexture != null && this.parent != null) {
            batch.draw(debugTexture, this.x, this.y, this.originX, this.originY, this.width == 0.0f ? 200.0f : this.width, this.height == 0.0f ? 200.0f : this.height, this.scaleX, this.scaleY, this.rotation, 0, 0, debugTexture.getWidth(), debugTexture.getHeight(), false, false);
        }
        if (this.transform) {
            this.applyTransform(batch);
        }
        this.drawChildren(batch, parentAlpha);
        if (this.transform) {
            this.resetTransform(batch);
        }
    }

    protected void drawChildren(SpriteBatch batch, float parentAlpha) {
        parentAlpha *= this.color.a;
        if (this.transform) {
            for (int i = 0; i < this.children.size(); ++i) {
                Actor child = this.children.get(i);
                if (!child.visible) continue;
                child.draw(batch, parentAlpha);
            }
        } else {
            for (int i = 0; i < this.children.size(); ++i) {
                Actor child = this.children.get(i);
                if (!child.visible) continue;
                child.x += this.x;
                child.y += this.y;
                child.draw(batch, parentAlpha);
                child.x -= this.x;
                child.y -= this.y;
            }
        }
        if (this.transform) {
            batch.flush();
        }
    }

    protected void drawChild(Actor child, SpriteBatch batch, float parentAlpha) {
        if (child.visible) {
            child.draw(batch, parentAlpha * this.color.a);
        }
        if (this.transform) {
            batch.flush();
        }
    }

    protected void applyTransform(SpriteBatch batch) {
        Matrix4 newBatchTransform = this.updateTransform();
        batch.end();
        this.oldBatchTransform.set(batch.getTransformMatrix());
        batch.setTransformMatrix(newBatchTransform);
        batch.begin();
    }

    protected Matrix4 updateTransform() {
        Matrix3 temp = this.worldTransform;
        if (this.originX != 0.0f || this.originY != 0.0f) {
            this.localTransform.setToTranslation(this.originX, this.originY);
        } else {
            this.localTransform.idt();
        }
        if (this.rotation != 0.0f) {
            this.localTransform.mul(temp.setToRotation(this.rotation));
        }
        if (this.scaleX != 1.0f || this.scaleY != 1.0f) {
            this.localTransform.mul(temp.setToScaling(this.scaleX, this.scaleY));
        }
        if (this.originX != 0.0f || this.originY != 0.0f) {
            this.localTransform.mul(temp.setToTranslation(-this.originX, -this.originY));
        }
        this.localTransform.trn(this.x, this.y);
        Group parentGroup = this.parent;
        while (parentGroup != null && !parentGroup.transform) {
            parentGroup = parentGroup.parent;
        }
        if (parentGroup != null) {
            this.worldTransform.set(parentGroup.worldTransform);
            this.worldTransform.mul(this.localTransform);
        } else {
            this.worldTransform.set(this.localTransform);
        }
        this.batchTransform.set(this.worldTransform);
        return this.batchTransform;
    }

    protected void resetTransform(SpriteBatch batch) {
        batch.end();
        batch.setTransformMatrix(this.oldBatchTransform);
        batch.begin();
    }

    @Override
    public boolean touchDown(float x, float y, int pointer) {
        int len;
        if (!this.touchable) {
            return false;
        }
        if (debug) {
            Gdx.app.log("Group", this.name + ": " + x + ", " + y);
        }
        if (this.focusedActor[pointer] != null) {
            this.point.x = x;
            this.point.y = y;
            this.focusedActor[pointer].toLocalCoordinates(this.point);
            this.focusedActor[pointer].touchDown(this.point.x, this.point.y, pointer);
            return true;
        }
        for (int i = len = this.children.size() - 1; i >= 0; --i) {
            Actor child = this.children.get(i);
            if (!child.touchable) continue;
            Group.toChildCoordinates(child, x, y, this.point);
            if (child.hit(this.point.x, this.point.y) == null || !child.touchDown(this.point.x, this.point.y, pointer)) continue;
            if (this.focusedActor[pointer] == null) {
                this.focus(child, pointer);
            }
            this.lastTouchedChild = child instanceof Group ? ((Group)child).lastTouchedChild : child;
            return true;
        }
        return false;
    }

    @Override
    public void touchUp(float x, float y, int pointer) {
        if (!this.touchable) {
            return;
        }
        this.point.x = x;
        this.point.y = y;
        Actor actor = this.focusedActor[pointer];
        if (actor != this) {
            actor.toLocalCoordinates(this.point);
            actor.touchUp(this.point.x, this.point.y, pointer);
        }
        if (this.focusedActor[pointer] == actor && actor != null) {
            actor.parent.focus(null, pointer);
        }
    }

    @Override
    public boolean touchMoved(float x, float y) {
        int len;
        if (!this.touchable) {
            return false;
        }
        for (int i = len = this.children.size() - 1; i >= 0; --i) {
            Actor child = this.children.get(i);
            if (!child.touchable) continue;
            Group.toChildCoordinates(child, x, y, this.point);
            if (!child.touchMoved(this.point.x, this.point.y)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void touchDragged(float x, float y, int pointer) {
        if (this.focusedActor[pointer] != null) {
            if (!this.touchable) {
                return;
            }
            this.point.x = x;
            this.point.y = y;
            this.focusedActor[pointer].toLocalCoordinates(this.point);
            this.focusedActor[pointer].touchDragged(this.point.x, this.point.y, pointer);
        }
    }

    @Override
    public boolean scrolled(int amount) {
        if (this.scrollFocusedActor != null) {
            this.scrollFocusedActor.scrolled(amount);
        }
        return false;
    }

    @Override
    public boolean keyDown(int keycode) {
        if (this.keyboardFocusedActor != null) {
            return this.keyboardFocusedActor.keyDown(keycode);
        }
        return false;
    }

    @Override
    public boolean keyUp(int keycode) {
        if (this.keyboardFocusedActor != null) {
            return this.keyboardFocusedActor.keyUp(keycode);
        }
        return false;
    }

    @Override
    public boolean keyTyped(char character) {
        if (this.keyboardFocusedActor != null) {
            return this.keyboardFocusedActor.keyTyped(character);
        }
        return false;
    }

    @Override
    public Actor hit(float x, float y) {
        int len;
        for (int i = len = this.children.size() - 1; i >= 0; --i) {
            Actor child = this.children.get(i);
            Group.toChildCoordinates(child, x, y, this.point);
            Actor hit = child.hit(this.point.x, this.point.y);
            if (hit == null) continue;
            return hit;
        }
        return null;
    }

    public void addActor(Actor actor) {
        this.children.add(actor);
        if (actor instanceof Group) {
            this.groups.add((Group)actor);
        }
        if (actor.name != null) {
            this.namesToActors.put(actor.name, actor);
        }
        actor.parent = this;
    }

    public void addActorAt(int index, Actor actor) {
        this.children.add(index, actor);
        if (actor instanceof Group) {
            this.groups.add((Group)actor);
        }
        if (actor.name != null) {
            this.namesToActors.put(actor.name, actor);
        }
        actor.parent = this;
    }

    public void addActorBefore(Actor actorBefore, Actor actor) {
        int index = this.children.indexOf(actorBefore);
        this.children.add(index, actor);
        if (actor instanceof Group) {
            this.groups.add((Group)actor);
        }
        if (actor.name != null) {
            this.namesToActors.put(actor.name, actor);
        }
        actor.parent = this;
    }

    public void addActorAfter(Actor actorAfter, Actor actor) {
        int index = this.children.indexOf(actorAfter);
        if (index == this.children.size()) {
            this.children.add(actor);
        } else {
            this.children.add(index + 1, actor);
        }
        if (actor instanceof Group) {
            this.groups.add((Group)actor);
        }
        if (actor.name != null) {
            this.namesToActors.put(actor.name, actor);
        }
        actor.parent = this;
    }

    public void removeActor(Actor actor) {
        this.children.remove(actor);
        if (actor instanceof Group) {
            this.groups.remove((Group)actor);
        }
        if (actor.name != null) {
            this.namesToActors.remove(actor.name);
        }
        this.unfocusAll(actor);
    }

    public void removeActorRecursive(Actor actor) {
        if (this.children.remove(actor)) {
            if (actor instanceof Group) {
                this.groups.remove((Group)actor);
            }
            if (actor.name != null) {
                this.namesToActors.remove(actor.name);
            }
            this.unfocusAll(actor);
            return;
        }
        for (int i = 0; i < this.groups.size(); ++i) {
            this.groups.get(i).removeActorRecursive(actor);
        }
    }

    public Actor findActor(String name) {
        Actor actor = this.namesToActors.get(name);
        if (actor == null) {
            int len = this.groups.size();
            for (int i = 0; i < len; ++i) {
                actor = this.groups.get(i).findActor(name);
                if (actor == null) continue;
                return actor;
            }
        }
        return actor;
    }

    public boolean swapActor(int first, int second) {
        int maxIndex = this.children.size();
        if (first < 0 || first >= maxIndex) {
            return false;
        }
        if (second < 0 || second >= maxIndex) {
            return false;
        }
        Collections.swap(this.children, first, second);
        return true;
    }

    public boolean swapActor(Actor first, Actor second) {
        int firstIndex = this.children.indexOf(first);
        int secondIndex = this.children.indexOf(second);
        if (firstIndex == -1 || secondIndex == -1) {
            return false;
        }
        Collections.swap(this.children, firstIndex, secondIndex);
        return true;
    }

    public List<Actor> getActors() {
        return this.immutableChildren;
    }

    public List<Group> getGroups() {
        return this.immutableGroups;
    }

    public void focus(Actor actor, int pointer) {
        Actor existingActor = this.focusedActor[pointer];
        if (existingActor != null) {
            this.focusedActor[pointer] = null;
            if (existingActor.parent != this) {
                existingActor.parent.focus(null, pointer);
            }
        }
        if (debug) {
            Gdx.app.log("Group", "focus: " + (actor == null ? "null" : actor.name));
        }
        this.focusedActor[pointer] = actor;
        if (this.parent != null) {
            this.parent.focus(actor, pointer);
        }
    }

    public void keyboardFocus(Actor actor) {
        this.keyboardFocusedActor = actor;
        if (this.parent != null) {
            this.parent.keyboardFocus(actor);
        }
    }

    public void scrollFocus(Actor actor) {
        this.scrollFocusedActor = actor;
        if (this.parent != null) {
            this.parent.scrollFocus(actor);
        }
    }

    public void clear() {
        this.children.clear();
        this.groups.clear();
        this.namesToActors.clear();
    }

    public void sortChildren(Comparator<Actor> comparator) {
        Collections.sort(this.children, comparator);
    }

    public void unfocusAll() {
        int i;
        for (i = 0; i < this.focusedActor.length; ++i) {
            this.focusedActor[i] = null;
        }
        for (i = 0; i < this.groups.size(); ++i) {
            this.groups.get(i).unfocusAll();
        }
        this.keyboardFocusedActor = null;
        this.scrollFocusedActor = null;
    }

    public void unfocusAll(Actor actor) {
        for (int i = 0; i < this.focusedActor.length; ++i) {
            if (this.focusedActor[i] != actor) continue;
            this.focus(null, i);
        }
        if (this.keyboardFocusedActor == actor) {
            this.keyboardFocus(null);
        }
        if (this.scrollFocusedActor == actor) {
            this.scrollFocus(null);
        }
    }

    public static void toChildCoordinates(Actor child, float x, float y, Vector2 out) {
        if (child.rotation == 0.0f) {
            if (child.scaleX == 1.0f && child.scaleY == 1.0f) {
                out.x = x - child.x;
                out.y = y - child.y;
            } else if (child.originX == 0.0f && child.originY == 0.0f) {
                out.x = (x - child.x) / child.scaleX;
                out.y = (y - child.y) / child.scaleY;
            } else {
                out.x = (x - child.x - child.originX) / child.scaleX + child.originX;
                out.y = (y - child.y - child.originY) / child.scaleY + child.originY;
            }
        } else {
            float cos = (float)Math.cos(child.rotation * ((float)Math.PI / 180));
            float sin = (float)Math.sin(child.rotation * ((float)Math.PI / 180));
            if (child.scaleX == 1.0f && child.scaleY == 1.0f) {
                if (child.originX == 0.0f && child.originY == 0.0f) {
                    float tox = x - child.x;
                    float toy = y - child.y;
                    out.x = tox * cos + toy * sin;
                    out.y = tox * -sin + toy * cos;
                } else {
                    float worldOriginX = child.x + child.originX;
                    float worldOriginY = child.y + child.originY;
                    float fx = -child.originX;
                    float fy = -child.originY;
                    float x1 = cos * fx - sin * fy;
                    float y1 = sin * fx + cos * fy;
                    float tox = x - (x1 += worldOriginX);
                    float toy = y - (y1 += worldOriginY);
                    out.x = tox * cos + toy * sin;
                    out.y = tox * -sin + toy * cos;
                }
            } else if (child.originX == 0.0f && child.originY == 0.0f) {
                float tox = x - child.x;
                float toy = y - child.y;
                out.x = tox * cos + toy * sin;
                out.y = tox * -sin + toy * cos;
                out.x /= child.scaleX;
                out.y /= child.scaleY;
            } else {
                float srefX = child.originX * child.scaleX;
                float srefY = child.originY * child.scaleY;
                float worldOriginX = child.x + child.originX;
                float worldOriginY = child.y + child.originY;
                float fx = -srefX;
                float fy = -srefY;
                float x1 = cos * fx - sin * fy;
                float y1 = sin * fx + cos * fy;
                float tox = x - (x1 += worldOriginX);
                float toy = y - (y1 += worldOriginY);
                out.x = tox * cos + toy * sin;
                out.y = tox * -sin + toy * cos;
                out.x /= child.scaleX;
                out.y /= child.scaleY;
            }
        }
    }

    public static void enableDebugging(String debugTextureFile) {
        debugTexture = new Texture(Gdx.files.internal(debugTextureFile), false);
        debug = true;
    }

    public static void disableDebugging() {
        if (debugTexture != null) {
            debugTexture.dispose();
        }
        debug = false;
    }

    static {
        debug = false;
    }
}

