/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.utils.PooledLinkedList;

public abstract class Actor {
    public Group parent;
    public final String name;
    public boolean touchable = true;
    public boolean visible = true;
    public float x;
    public float y;
    public float width;
    public float height;
    public float originX;
    public float originY;
    public float scaleX = 1.0f;
    public float scaleY = 1.0f;
    public float rotation;
    public final Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    protected PooledLinkedList<Action> actions = new PooledLinkedList(10);
    private boolean toRemove;

    public Actor() {
        this.name = null;
    }

    public Actor(String name) {
        this.name = name;
    }

    public abstract void draw(SpriteBatch var1, float var2);

    public abstract boolean touchDown(float var1, float var2, int var3);

    public abstract void touchUp(float var1, float var2, int var3);

    public abstract void touchDragged(float var1, float var2, int var3);

    public boolean touchMoved(float x, float y) {
        return false;
    }

    public boolean scrolled(int amount) {
        return false;
    }

    public boolean keyDown(int keycode) {
        return false;
    }

    public boolean keyUp(int keycode) {
        return false;
    }

    public boolean keyTyped(char character) {
        return false;
    }

    public abstract Actor hit(float var1, float var2);

    public void toLocalCoordinates(Vector2 point) {
        if (this.parent == null) {
            return;
        }
        this.parent.toLocalCoordinates(point);
        Group.toChildCoordinates(this, point.x, point.y, point);
    }

    public void remove() {
        this.parent.removeActor(this);
    }

    public void act(float delta) {
        Action action;
        this.actions.iter();
        while ((action = this.actions.next()) != null) {
            action.act(delta);
            if (!action.isDone()) continue;
            action.finish();
            this.actions.remove();
        }
    }

    public void action(Action action) {
        action.setTarget(this);
        this.actions.add(action);
    }

    public void clearActions() {
        this.actions.clear();
    }

    public String toString() {
        return this.name + ": [x=" + this.x + ", y=" + this.y + ", refX=" + this.originX + ", refY=" + this.originY + ", width=" + this.width + ", height=" + this.height + "]";
    }

    public void markToRemove(boolean remove) {
        this.toRemove = remove;
    }

    public boolean isMarkedToRemove() {
        return this.toRemove;
    }
}

