/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.box2d;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.ChainShape;
import com.badlogic.gdx.physics.box2d.CircleShape;
import com.badlogic.gdx.physics.box2d.Contact;
import com.badlogic.gdx.physics.box2d.EdgeShape;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.Joint;
import com.badlogic.gdx.physics.box2d.JointDef;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import com.badlogic.gdx.physics.box2d.Shape;
import com.badlogic.gdx.physics.box2d.Transform;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.physics.box2d.WorldManifold;
import com.badlogic.gdx.physics.box2d.joints.PulleyJoint;
import java.util.ArrayList;
import java.util.Iterator;

public class Box2DDebugRenderer {
    protected ShapeRenderer renderer;
    public SpriteBatch batch;
    private static Vector2[] vertices = new Vector2[1000];
    private static Vector2 mLower;
    private static Vector2 mUpper;
    private boolean mDrawBodies;
    private boolean mDrawJoints;
    private boolean mDrawAABBs;
    private final Color SHAPE_NOT_ACTIVE = new Color(0.5f, 0.5f, 0.3f, 1.0f);
    private final Color SHAPE_STATIC = new Color(0.5f, 0.9f, 0.5f, 1.0f);
    private final Color SHAPE_KINEMATIC = new Color(0.5f, 0.5f, 0.9f, 1.0f);
    private final Color SHAPE_NOT_AWAKE = new Color(0.6f, 0.6f, 0.6f, 1.0f);
    private final Color SHAPE_AWAKE = new Color(0.9f, 0.7f, 0.7f, 1.0f);
    private final Color JOINT_COLOR = new Color(0.5f, 0.8f, 0.8f, 1.0f);
    private final Color AABB_COLOR = new Color(1.0f, 0.0f, 1.0f, 1.0f);
    private static Vector2 t;
    private static Vector2 axis;
    private final Vector2 f = new Vector2();
    private final Vector2 v = new Vector2();
    private final Vector2 lv = new Vector2();

    public Box2DDebugRenderer() {
        this(true, true, false);
    }

    public Box2DDebugRenderer(boolean drawBodies, boolean drawJoints, boolean drawAABBs) {
        this.renderer = new ShapeRenderer();
        this.batch = new SpriteBatch();
        mLower = new Vector2();
        mUpper = new Vector2();
        for (int i = 0; i < vertices.length; ++i) {
            Box2DDebugRenderer.vertices[i] = new Vector2();
        }
        this.mDrawBodies = drawBodies;
        this.mDrawJoints = drawJoints;
        this.mDrawAABBs = drawAABBs;
    }

    public void render(World world, Matrix4 projMatrix) {
        this.renderer.setProjectionMatrix(projMatrix);
        this.renderBodies(world);
    }

    private void renderBodies(World world) {
        Iterator<Object> iter;
        this.renderer.begin(ShapeRenderer.ShapeType.Line);
        if (this.mDrawBodies || this.mDrawAABBs) {
            iter = world.getBodies();
            while (iter.hasNext()) {
                Body body = iter.next();
                Transform transform = body.getTransform();
                int len = body.getFixtureList().size();
                ArrayList<Fixture> fixtures = body.getFixtureList();
                for (int i = 0; i < len; ++i) {
                    Fixture fixture = (Fixture)fixtures.get(i);
                    if (this.mDrawBodies) {
                        if (!body.isActive()) {
                            this.drawShape(fixture, transform, this.SHAPE_NOT_ACTIVE);
                        } else if (body.getType() == BodyDef.BodyType.StaticBody) {
                            this.drawShape(fixture, transform, this.SHAPE_STATIC);
                        } else if (body.getType() == BodyDef.BodyType.KinematicBody) {
                            this.drawShape(fixture, transform, this.SHAPE_KINEMATIC);
                        } else if (!body.isAwake()) {
                            this.drawShape(fixture, transform, this.SHAPE_NOT_AWAKE);
                        } else {
                            this.drawShape(fixture, transform, this.SHAPE_AWAKE);
                        }
                    }
                    if (!this.mDrawAABBs) continue;
                    this.drawAABB(fixture, transform);
                }
            }
        }
        if (this.mDrawJoints) {
            iter = world.getJoints();
            while (iter.hasNext()) {
                Joint joint = (Joint)iter.next();
                this.drawJoint(joint);
            }
        }
        this.renderer.end();
        if (Gdx.gl10 != null) {
            Gdx.gl10.glPointSize(3.0f);
        }
        this.renderer.begin(ShapeRenderer.ShapeType.Point);
        int len = world.getContactList().size();
        for (int i = 0; i < len; ++i) {
            this.drawContact(world.getContactList().get(i));
        }
        this.renderer.end();
        if (Gdx.gl10 != null) {
            Gdx.gl10.glPointSize(1.0f);
        }
    }

    private void drawAABB(Fixture fixture, Transform transform) {
        if (fixture.getType() == Shape.Type.Circle) {
            CircleShape shape = (CircleShape)fixture.getShape();
            float radius = shape.getRadius();
            vertices[0].set(shape.getPosition());
            vertices[0].rotate(transform.getRotation()).add(transform.getPosition());
            mLower.set(Box2DDebugRenderer.vertices[0].x - radius, Box2DDebugRenderer.vertices[0].y - radius);
            mUpper.set(Box2DDebugRenderer.vertices[0].x + radius, Box2DDebugRenderer.vertices[0].y + radius);
            vertices[0].set(Box2DDebugRenderer.mLower.x, Box2DDebugRenderer.mLower.y);
            vertices[1].set(Box2DDebugRenderer.mUpper.x, Box2DDebugRenderer.mLower.y);
            vertices[2].set(Box2DDebugRenderer.mUpper.x, Box2DDebugRenderer.mUpper.y);
            vertices[3].set(Box2DDebugRenderer.mLower.x, Box2DDebugRenderer.mUpper.y);
            this.drawSolidPolygon(vertices, 4, this.AABB_COLOR);
        } else if (fixture.getType() == Shape.Type.Polygon) {
            PolygonShape shape = (PolygonShape)fixture.getShape();
            int vertexCount = shape.getVertexCount();
            shape.getVertex(0, vertices[0]);
            mLower.set(transform.mul(vertices[0]));
            mUpper.set(mLower);
            for (int i = 1; i < vertexCount; ++i) {
                shape.getVertex(i, vertices[i]);
                transform.mul(vertices[i]);
                Box2DDebugRenderer.mLower.x = Math.min(Box2DDebugRenderer.mLower.x, Box2DDebugRenderer.vertices[i].x);
                Box2DDebugRenderer.mLower.y = Math.min(Box2DDebugRenderer.mLower.y, Box2DDebugRenderer.vertices[i].y);
                Box2DDebugRenderer.mUpper.x = Math.max(Box2DDebugRenderer.mUpper.x, Box2DDebugRenderer.vertices[i].x);
                Box2DDebugRenderer.mUpper.y = Math.max(Box2DDebugRenderer.mUpper.y, Box2DDebugRenderer.vertices[i].y);
            }
            vertices[0].set(Box2DDebugRenderer.mLower.x, Box2DDebugRenderer.mLower.y);
            vertices[1].set(Box2DDebugRenderer.mUpper.x, Box2DDebugRenderer.mLower.y);
            vertices[2].set(Box2DDebugRenderer.mUpper.x, Box2DDebugRenderer.mUpper.y);
            vertices[3].set(Box2DDebugRenderer.mLower.x, Box2DDebugRenderer.mUpper.y);
            this.drawSolidPolygon(vertices, 4, this.AABB_COLOR);
        }
    }

    private void drawShape(Fixture fixture, Transform transform, Color color) {
        int i;
        int vertexCount;
        Shape chain;
        if (fixture.getType() == Shape.Type.Circle) {
            CircleShape circle = (CircleShape)fixture.getShape();
            t.set(circle.getPosition());
            transform.mul(t);
            this.drawSolidCircle(t, circle.getRadius(), axis.set(transform.vals[2], transform.vals[3]), color);
        }
        if (fixture.getType() == Shape.Type.Edge) {
            EdgeShape edge = (EdgeShape)fixture.getShape();
            edge.getVertex1(vertices[0]);
            edge.getVertex2(vertices[1]);
            transform.mul(vertices[0]);
            transform.mul(vertices[1]);
            this.drawSolidPolygon(vertices, 2, color);
        }
        if (fixture.getType() == Shape.Type.Polygon) {
            chain = (PolygonShape)fixture.getShape();
            vertexCount = ((PolygonShape)chain).getVertexCount();
            for (i = 0; i < vertexCount; ++i) {
                ((PolygonShape)chain).getVertex(i, vertices[i]);
                transform.mul(vertices[i]);
            }
            this.drawSolidPolygon(vertices, vertexCount, color);
        }
        if (fixture.getType() == Shape.Type.Chain) {
            chain = (ChainShape)fixture.getShape();
            vertexCount = ((ChainShape)chain).getVertexCount();
            for (i = 0; i < vertexCount; ++i) {
                ((ChainShape)chain).getVertex(i, vertices[i]);
                transform.mul(vertices[i]);
            }
            this.drawSolidPolygon(vertices, vertexCount, color);
        }
    }

    private void drawSolidCircle(Vector2 center, float radius, Vector2 axis, Color color) {
        float angle = 0.0f;
        float angleInc = 0.31415927f;
        this.renderer.setColor(color.r, color.g, color.b, color.a);
        int i = 0;
        while (i < 20) {
            this.v.set((float)Math.cos(angle) * radius + center.x, (float)Math.sin(angle) * radius + center.y);
            if (i == 0) {
                this.lv.set(this.v);
                this.f.set(this.v);
            } else {
                this.renderer.line(this.lv.x, this.lv.y, this.v.x, this.v.y);
                this.lv.set(this.v);
            }
            ++i;
            angle += angleInc;
        }
        this.renderer.line(this.f.x, this.f.y, this.lv.x, this.lv.y);
        this.renderer.line(center.x, center.y, 0.0f, center.x + axis.x * radius, center.y + axis.y * radius, 0.0f);
    }

    private void drawSolidPolygon(Vector2[] vertices, int vertexCount, Color color) {
        this.renderer.setColor(color.r, color.g, color.b, color.a);
        for (int i = 0; i < vertexCount; ++i) {
            Vector2 v = vertices[i];
            if (i == 0) {
                this.lv.set(v);
                this.f.set(v);
                continue;
            }
            this.renderer.line(this.lv.x, this.lv.y, v.x, v.y);
            this.lv.set(v);
        }
        this.renderer.line(this.f.x, this.f.y, this.lv.x, this.lv.y);
    }

    private void drawJoint(Joint joint) {
        Body bodyA = joint.getBodyA();
        Body bodyB = joint.getBodyB();
        Transform xf1 = bodyA.getTransform();
        Transform xf2 = bodyB.getTransform();
        Vector2 x1 = xf1.getPosition();
        Vector2 x2 = xf2.getPosition();
        Vector2 p1 = joint.getAnchorA();
        Vector2 p2 = joint.getAnchorB();
        if (joint.getType() == JointDef.JointType.DistanceJoint) {
            this.drawSegment(p1, p2, this.JOINT_COLOR);
        } else if (joint.getType() == JointDef.JointType.PulleyJoint) {
            PulleyJoint pulley = (PulleyJoint)joint;
            Vector2 s1 = pulley.getGroundAnchorA();
            Vector2 s2 = pulley.getGroundAnchorB();
            this.drawSegment(s1, p1, this.JOINT_COLOR);
            this.drawSegment(s2, p2, this.JOINT_COLOR);
            this.drawSegment(s1, s2, this.JOINT_COLOR);
        } else if (joint.getType() == JointDef.JointType.MouseJoint) {
            this.drawSegment(joint.getAnchorA(), joint.getAnchorB(), this.JOINT_COLOR);
        } else {
            this.drawSegment(x1, p1, this.JOINT_COLOR);
            this.drawSegment(p1, p2, this.JOINT_COLOR);
            this.drawSegment(x2, p2, this.JOINT_COLOR);
        }
    }

    private void drawSegment(Vector2 x1, Vector2 x2, Color color) {
        this.renderer.setColor(color);
        this.renderer.line(x1.x, x1.y, x2.x, x2.y);
    }

    private void drawContact(Contact contact) {
        WorldManifold worldManifold = contact.getWorldManifold();
        if (worldManifold.getNumberOfContactPoints() == 0) {
            return;
        }
        Vector2 point = worldManifold.getPoints()[0];
        this.renderer.point(point.x, point.y, 0.0f);
    }

    public void dispose() {
        this.batch.dispose();
    }

    static {
        t = new Vector2();
        axis = new Vector2();
    }
}

