/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import java.io.Serializable;

public class Quaternion
implements Serializable {
    private static final long serialVersionUID = -7661875440774897168L;
    private static final float NORMALIZATION_TOLERANCE = 1.0E-5f;
    private static Quaternion tmp1 = new Quaternion(0.0f, 0.0f, 0.0f, 0.0f);
    private static Quaternion tmp2 = new Quaternion(0.0f, 0.0f, 0.0f, 0.0f);
    public float x;
    public float y;
    public float z;
    public float w;

    public Quaternion(float x, float y, float z, float w) {
        this.set(x, y, z, w);
    }

    Quaternion() {
    }

    public Quaternion(Quaternion quaternion) {
        this.set(quaternion);
    }

    public Quaternion(Vector3 axis, float angle) {
        this.set(axis, angle);
    }

    public Quaternion set(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        return this;
    }

    public Quaternion set(Quaternion quaternion) {
        return this.set(quaternion.x, quaternion.y, quaternion.z, quaternion.w);
    }

    public Quaternion set(Vector3 axis, float angle) {
        float l_ang = (float)Math.toRadians(angle);
        float l_sin = (float)Math.sin(l_ang / 2.0f);
        float l_cos = (float)Math.cos(l_ang / 2.0f);
        return this.set(axis.x * l_sin, axis.y * l_sin, axis.z * l_sin, l_cos).nor();
    }

    public Quaternion cpy() {
        return new Quaternion(this);
    }

    public float len() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
    }

    public String toString() {
        return "[" + this.x + "|" + this.y + "|" + this.z + "|" + this.w + "]";
    }

    public Quaternion setEulerAngles(float yaw, float pitch, float roll) {
        yaw = (float)Math.toRadians(yaw);
        pitch = (float)Math.toRadians(pitch);
        roll = (float)Math.toRadians(roll);
        float num9 = roll * 0.5f;
        float num6 = (float)Math.sin(num9);
        float num5 = (float)Math.cos(num9);
        float num8 = pitch * 0.5f;
        float num4 = (float)Math.sin(num8);
        float num3 = (float)Math.cos(num8);
        float num7 = yaw * 0.5f;
        float num2 = (float)Math.sin(num7);
        float num = (float)Math.cos(num7);
        this.x = num * num4 * num5 + num2 * num3 * num6;
        this.y = num2 * num3 * num5 - num * num4 * num6;
        this.z = num * num3 * num6 - num2 * num4 * num5;
        this.w = num * num3 * num5 + num2 * num4 * num6;
        return this;
    }

    public float len2() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public Quaternion nor() {
        float len = this.len2();
        if (len != 0.0f && Math.abs(len - 1.0f) > 1.0E-5f) {
            len = (float)Math.sqrt(len);
            this.w /= len;
            this.x /= len;
            this.y /= len;
            this.z /= len;
        }
        return this;
    }

    public Quaternion conjugate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public void transform(Vector3 v) {
        tmp2.set(this);
        tmp2.conjugate();
        tmp2.mulLeft(tmp1.set(v.x, v.y, v.z, 0.0f)).mulLeft(this);
        v.x = Quaternion.tmp2.x;
        v.y = Quaternion.tmp2.y;
        v.z = Quaternion.tmp2.z;
    }

    public Quaternion mul(Quaternion q) {
        float newX = this.w * q.x + this.x * q.w + this.y * q.z - this.z * q.y;
        float newY = this.w * q.y + this.y * q.w + this.z * q.x - this.x * q.z;
        float newZ = this.w * q.z + this.z * q.w + this.x * q.y - this.y * q.x;
        float newW = this.w * q.w - this.x * q.x - this.y * q.y - this.z * q.z;
        this.x = newX;
        this.y = newY;
        this.z = newZ;
        this.w = newW;
        return this;
    }

    public Quaternion mulLeft(Quaternion q) {
        float newX = q.w * this.x + q.x * this.w + q.y * this.z - q.z * this.y;
        float newY = q.w * this.y + q.y * this.w + q.z * this.x - q.x * this.z;
        float newZ = q.w * this.z + q.z * this.w + q.x * this.y - q.y * this.x;
        float newW = q.w * this.w - q.x * this.x - q.y * this.y - q.z * this.z;
        this.x = newX;
        this.y = newY;
        this.z = newZ;
        this.w = newW;
        return this;
    }

    public void toMatrix(float[] matrix) {
        float xx = this.x * this.x;
        float xy = this.x * this.y;
        float xz = this.x * this.z;
        float xw = this.x * this.w;
        float yy = this.y * this.y;
        float yz = this.y * this.z;
        float yw = this.y * this.w;
        float zz = this.z * this.z;
        float zw = this.z * this.w;
        matrix[0] = 1.0f - 2.0f * (yy + zz);
        matrix[4] = 2.0f * (xy - zw);
        matrix[8] = 2.0f * (xz + yw);
        matrix[12] = 0.0f;
        matrix[1] = 2.0f * (xy + zw);
        matrix[5] = 1.0f - 2.0f * (xx + zz);
        matrix[9] = 2.0f * (yz - xw);
        matrix[13] = 0.0f;
        matrix[2] = 2.0f * (xz - yw);
        matrix[6] = 2.0f * (yz + xw);
        matrix[10] = 1.0f - 2.0f * (xx + yy);
        matrix[14] = 0.0f;
        matrix[3] = 0.0f;
        matrix[7] = 0.0f;
        matrix[11] = 0.0f;
        matrix[15] = 1.0f;
    }

    public static Quaternion idt() {
        return new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
    }

    public Quaternion setFromAxis(Vector3 axis, float angle) {
        return this.setFromAxis(axis.x, axis.y, axis.z, angle);
    }

    public Quaternion setFromAxis(float x, float y, float z, float angle) {
        float l_ang = angle * ((float)Math.PI / 180);
        float l_sin = MathUtils.sin(l_ang / 2.0f);
        float l_cos = MathUtils.cos(l_ang / 2.0f);
        return this.set(x * l_sin, y * l_sin, z * l_sin, l_cos).nor();
    }

    public Quaternion setFromMatrix(Matrix4 matrix) {
        return this.setFromAxes(matrix.val[0], matrix.val[4], matrix.val[8], matrix.val[1], matrix.val[5], matrix.val[9], matrix.val[2], matrix.val[6], matrix.val[10]);
    }

    public Quaternion setFromAxes(float xx, float xy, float xz, float yx, float yy, float yz, float zx, float zy, float zz) {
        double z;
        double y;
        double x;
        double w;
        float m00 = xx;
        float m01 = yx;
        float m02 = zx;
        float m10 = xy;
        float m11 = yy;
        float m12 = zy;
        float m20 = xz;
        float m21 = yz;
        float m22 = zz;
        float t = m00 + m11 + m22;
        if (t >= 0.0f) {
            double s = Math.sqrt(t + 1.0f);
            w = 0.5 * s;
            s = 0.5 / s;
            x = (double)(m21 - m12) * s;
            y = (double)(m02 - m20) * s;
            z = (double)(m10 - m01) * s;
        } else if (m00 > m11 && m00 > m22) {
            double s = Math.sqrt(1.0 + (double)m00 - (double)m11 - (double)m22);
            x = s * 0.5;
            s = 0.5 / s;
            y = (double)(m10 + m01) * s;
            z = (double)(m02 + m20) * s;
            w = (double)(m21 - m12) * s;
        } else if (m11 > m22) {
            double s = Math.sqrt(1.0 + (double)m11 - (double)m00 - (double)m22);
            y = s * 0.5;
            s = 0.5 / s;
            x = (double)(m10 + m01) * s;
            z = (double)(m21 + m12) * s;
            w = (double)(m02 - m20) * s;
        } else {
            double s = Math.sqrt(1.0 + (double)m22 - (double)m00 - (double)m11);
            z = s * 0.5;
            s = 0.5 / s;
            x = (double)(m02 + m20) * s;
            y = (double)(m21 + m12) * s;
            w = (double)(m10 - m01) * s;
        }
        return this.set((float)x, (float)y, (float)z, (float)w);
    }

    public Quaternion slerp(Quaternion end, float alpha) {
        if (this.equals(end)) {
            return this;
        }
        float result = this.dot(end);
        if ((double)result < 0.0) {
            end.mul(-1.0f);
            result = -result;
        }
        float scale0 = 1.0f - alpha;
        float scale1 = alpha;
        if ((double)(1.0f - result) > 0.1) {
            double theta = Math.acos(result);
            double invSinTheta = 1.0 / Math.sin(theta);
            scale0 = (float)(Math.sin((double)(1.0f - alpha) * theta) * invSinTheta);
            scale1 = (float)(Math.sin((double)alpha * theta) * invSinTheta);
        }
        float x = scale0 * this.x + scale1 * end.x;
        float y = scale0 * this.y + scale1 * end.y;
        float z = scale0 * this.z + scale1 * end.z;
        float w = scale0 * this.w + scale1 * end.w;
        this.set(x, y, z, w);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Quaternion)) {
            return false;
        }
        Quaternion comp = (Quaternion)o;
        return this.x == comp.x && this.y == comp.y && this.z == comp.z && this.w == comp.w;
    }

    public float dot(Quaternion other) {
        return this.x * other.x + this.y * other.y + this.z * other.z + this.w * other.w;
    }

    public Quaternion mul(float scalar) {
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
        this.w *= scalar;
        return this;
    }
}

