/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.Serializable;

public class Matrix3
implements Serializable {
    private static final long serialVersionUID = 7907569533774959788L;
    private static final float DEGREE_TO_RAD = (float)Math.PI / 180;
    public float[] vals = new float[9];
    private float[] tmp = new float[9];

    public Matrix3() {
        this.idt();
    }

    public Matrix3 idt() {
        this.vals[0] = 1.0f;
        this.vals[1] = 0.0f;
        this.vals[2] = 0.0f;
        this.vals[3] = 0.0f;
        this.vals[4] = 1.0f;
        this.vals[5] = 0.0f;
        this.vals[6] = 0.0f;
        this.vals[7] = 0.0f;
        this.vals[8] = 1.0f;
        return this;
    }

    public Matrix3 mul(Matrix3 m) {
        float v00 = this.vals[0] * m.vals[0] + this.vals[3] * m.vals[1] + this.vals[6] * m.vals[2];
        float v01 = this.vals[0] * m.vals[3] + this.vals[3] * m.vals[4] + this.vals[6] * m.vals[5];
        float v02 = this.vals[0] * m.vals[6] + this.vals[3] * m.vals[7] + this.vals[6] * m.vals[8];
        float v10 = this.vals[1] * m.vals[0] + this.vals[4] * m.vals[1] + this.vals[7] * m.vals[2];
        float v11 = this.vals[1] * m.vals[3] + this.vals[4] * m.vals[4] + this.vals[7] * m.vals[5];
        float v12 = this.vals[1] * m.vals[6] + this.vals[4] * m.vals[7] + this.vals[7] * m.vals[8];
        float v20 = this.vals[2] * m.vals[0] + this.vals[5] * m.vals[1] + this.vals[8] * m.vals[2];
        float v21 = this.vals[2] * m.vals[3] + this.vals[5] * m.vals[4] + this.vals[8] * m.vals[5];
        float v22 = this.vals[2] * m.vals[6] + this.vals[5] * m.vals[7] + this.vals[8] * m.vals[8];
        this.vals[0] = v00;
        this.vals[1] = v10;
        this.vals[2] = v20;
        this.vals[3] = v01;
        this.vals[4] = v11;
        this.vals[5] = v21;
        this.vals[6] = v02;
        this.vals[7] = v12;
        this.vals[8] = v22;
        return this;
    }

    public Matrix3 setToRotation(float angle) {
        angle = (float)Math.PI / 180 * angle;
        float cos = (float)Math.cos(angle);
        float sin = (float)Math.sin(angle);
        this.vals[0] = cos;
        this.vals[1] = sin;
        this.vals[2] = 0.0f;
        this.vals[3] = -sin;
        this.vals[4] = cos;
        this.vals[5] = 0.0f;
        this.vals[6] = 0.0f;
        this.vals[7] = 0.0f;
        this.vals[8] = 1.0f;
        return this;
    }

    public Matrix3 setToTranslation(float x, float y) {
        this.vals[0] = 1.0f;
        this.vals[1] = 0.0f;
        this.vals[2] = 0.0f;
        this.vals[3] = 0.0f;
        this.vals[4] = 1.0f;
        this.vals[5] = 0.0f;
        this.vals[6] = x;
        this.vals[7] = y;
        this.vals[8] = 1.0f;
        return this;
    }

    public Matrix3 setToScaling(float scaleX, float scaleY) {
        this.vals[0] = scaleX;
        this.vals[1] = 0.0f;
        this.vals[2] = 0.0f;
        this.vals[3] = 0.0f;
        this.vals[4] = scaleY;
        this.vals[5] = 0.0f;
        this.vals[6] = 0.0f;
        this.vals[7] = 0.0f;
        this.vals[8] = 1.0f;
        return this;
    }

    public String toString() {
        return "[" + this.vals[0] + "|" + this.vals[3] + "|" + this.vals[6] + "]\n" + "[" + this.vals[1] + "|" + this.vals[4] + "|" + this.vals[7] + "]\n" + "[" + this.vals[2] + "|" + this.vals[5] + "|" + this.vals[8] + "]";
    }

    public float det() {
        return this.vals[0] * this.vals[4] * this.vals[8] + this.vals[3] * this.vals[7] * this.vals[2] + this.vals[6] * this.vals[1] * this.vals[5] - this.vals[0] * this.vals[7] * this.vals[5] - this.vals[3] * this.vals[1] * this.vals[8] - this.vals[6] * this.vals[4] * this.vals[2];
    }

    public Matrix3 inv() {
        float det = this.det();
        if (det == 0.0f) {
            throw new GdxRuntimeException("Can't invert a singular matrix");
        }
        float inv_det = 1.0f / det;
        float[] tmp = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        tmp[0] = this.vals[4] * this.vals[8] - this.vals[5] * this.vals[7];
        tmp[1] = this.vals[2] * this.vals[7] - this.vals[1] * this.vals[8];
        tmp[2] = this.vals[1] * this.vals[5] - this.vals[2] * this.vals[4];
        tmp[3] = this.vals[5] * this.vals[6] - this.vals[3] * this.vals[8];
        tmp[4] = this.vals[0] * this.vals[8] - this.vals[2] * this.vals[6];
        tmp[5] = this.vals[2] * this.vals[3] - this.vals[0] * this.vals[5];
        tmp[6] = this.vals[3] * this.vals[7] - this.vals[4] * this.vals[6];
        tmp[7] = this.vals[1] * this.vals[6] - this.vals[0] * this.vals[7];
        tmp[8] = this.vals[0] * this.vals[4] - this.vals[1] * this.vals[3];
        this.vals[0] = inv_det * tmp[0];
        this.vals[1] = inv_det * tmp[1];
        this.vals[2] = inv_det * tmp[2];
        this.vals[3] = inv_det * tmp[3];
        this.vals[4] = inv_det * tmp[4];
        this.vals[5] = inv_det * tmp[5];
        this.vals[6] = inv_det * tmp[6];
        this.vals[7] = inv_det * tmp[7];
        this.vals[8] = inv_det * tmp[8];
        return this;
    }

    public Matrix3 set(Matrix3 mat) {
        this.vals[0] = mat.vals[0];
        this.vals[1] = mat.vals[1];
        this.vals[2] = mat.vals[2];
        this.vals[3] = mat.vals[3];
        this.vals[4] = mat.vals[4];
        this.vals[5] = mat.vals[5];
        this.vals[6] = mat.vals[6];
        this.vals[7] = mat.vals[7];
        this.vals[8] = mat.vals[8];
        return this;
    }

    public Matrix3 trn(Vector3 vector) {
        this.vals[6] = this.vals[6] + vector.x;
        this.vals[7] = this.vals[7] + vector.y;
        return this;
    }

    public Matrix3 trn(float x, float y) {
        this.vals[6] = this.vals[6] + x;
        this.vals[7] = this.vals[7] + y;
        return this;
    }

    public Matrix3 translate(float x, float y) {
        this.tmp[0] = 1.0f;
        this.tmp[1] = 0.0f;
        this.tmp[2] = 0.0f;
        this.tmp[3] = 0.0f;
        this.tmp[4] = 1.0f;
        this.tmp[5] = 0.0f;
        this.tmp[6] = x;
        this.tmp[7] = y;
        this.tmp[8] = 1.0f;
        Matrix3.mul(this.vals, this.tmp);
        return this;
    }

    public Matrix3 rotate(float angle) {
        if (angle == 0.0f) {
            return this;
        }
        angle = (float)Math.PI / 180 * angle;
        float cos = (float)Math.cos(angle);
        float sin = (float)Math.sin(angle);
        this.tmp[0] = cos;
        this.tmp[1] = sin;
        this.tmp[2] = 0.0f;
        this.tmp[3] = -sin;
        this.tmp[4] = cos;
        this.tmp[5] = 0.0f;
        this.tmp[6] = 0.0f;
        this.tmp[7] = 0.0f;
        this.tmp[8] = 1.0f;
        Matrix3.mul(this.vals, this.tmp);
        return this;
    }

    public Matrix3 scale(float scaleX, float scaleY) {
        this.tmp[0] = scaleX;
        this.tmp[1] = 0.0f;
        this.tmp[2] = 0.0f;
        this.tmp[3] = 0.0f;
        this.tmp[4] = scaleY;
        this.tmp[5] = 0.0f;
        this.tmp[6] = 0.0f;
        this.tmp[7] = 0.0f;
        this.tmp[8] = 1.0f;
        Matrix3.mul(this.vals, this.tmp);
        return this;
    }

    public float[] getValues() {
        return this.vals;
    }

    private static void mul(float[] mata, float[] matb) {
        float v00 = mata[0] * matb[0] + mata[3] * matb[1] + mata[6] * matb[2];
        float v01 = mata[0] * matb[3] + mata[3] * matb[4] + mata[6] * matb[5];
        float v02 = mata[0] * matb[6] + mata[3] * matb[7] + mata[6] * matb[8];
        float v10 = mata[1] * matb[0] + mata[4] * matb[1] + mata[7] * matb[2];
        float v11 = mata[1] * matb[3] + mata[4] * matb[4] + mata[7] * matb[5];
        float v12 = mata[1] * matb[6] + mata[4] * matb[7] + mata[7] * matb[8];
        float v20 = mata[2] * matb[0] + mata[5] * matb[1] + mata[8] * matb[2];
        float v21 = mata[2] * matb[3] + mata[5] * matb[4] + mata[8] * matb[5];
        float v22 = mata[2] * matb[6] + mata[5] * matb[7] + mata[8] * matb[8];
        mata[0] = v00;
        mata[1] = v10;
        mata[2] = v20;
        mata[3] = v01;
        mata[4] = v11;
        mata[5] = v21;
        mata[6] = v02;
        mata[7] = v12;
        mata[8] = v22;
    }
}

