/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.loaders.obj;

import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttribute;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class ObjLoader {
    public static Mesh loadObj(InputStream in) {
        return ObjLoader.loadObj(in, false);
    }

    public static Mesh loadObj(InputStream in, boolean flipV) {
        String line = "";
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            StringBuffer b = new StringBuffer();
            String l = reader.readLine();
            while (l != null) {
                b.append(l);
                b.append("\n");
                l = reader.readLine();
            }
            line = b.toString();
            reader.close();
        }
        catch (Exception ex) {
            return null;
        }
        return ObjLoader.loadObjFromString(line, flipV);
    }

    public static Mesh loadObjFromString(String obj) {
        return ObjLoader.loadObjFromString(obj, false);
    }

    public static Mesh loadObjFromString(String obj, boolean flipV) {
        String[] lines = obj.split("\n");
        float[] vertices = new float[lines.length * 3];
        float[] normals = new float[lines.length * 3];
        float[] uv = new float[lines.length * 3];
        int numVertices = 0;
        int numNormals = 0;
        int numUV = 0;
        int numFaces = 0;
        int[] facesVerts = new int[lines.length * 3];
        int[] facesNormals = new int[lines.length * 3];
        int[] facesUV = new int[lines.length * 3];
        int vertexIndex = 0;
        int normalIndex = 0;
        int uvIndex = 0;
        int faceIndex = 0;
        for (int i = 0; i < lines.length; ++i) {
            String[] tokens;
            String line = lines[i];
            if (line.startsWith("v ")) {
                tokens = line.split("[ ]+");
                vertices[vertexIndex] = Float.parseFloat(tokens[1]);
                vertices[vertexIndex + 1] = Float.parseFloat(tokens[2]);
                vertices[vertexIndex + 2] = Float.parseFloat(tokens[3]);
                vertexIndex += 3;
                ++numVertices;
                continue;
            }
            if (line.startsWith("vn ")) {
                tokens = line.split("[ ]+");
                normals[normalIndex] = Float.parseFloat(tokens[1]);
                normals[normalIndex + 1] = Float.parseFloat(tokens[2]);
                normals[normalIndex + 2] = Float.parseFloat(tokens[3]);
                normalIndex += 3;
                ++numNormals;
                continue;
            }
            if (line.startsWith("vt")) {
                tokens = line.split("[ ]+");
                uv[uvIndex] = Float.parseFloat(tokens[1]);
                uv[uvIndex + 1] = flipV ? 1.0f - Float.parseFloat(tokens[2]) : Float.parseFloat(tokens[2]);
                uvIndex += 2;
                ++numUV;
                continue;
            }
            if (!line.startsWith("f ")) continue;
            tokens = line.split("[ ]+");
            String[] parts = tokens[1].split("/");
            facesVerts[faceIndex] = ObjLoader.getIndex(parts[0], numVertices);
            if (parts.length > 2) {
                facesNormals[faceIndex] = ObjLoader.getIndex(parts[2], numNormals);
            }
            if (parts.length > 1) {
                facesUV[faceIndex] = ObjLoader.getIndex(parts[1], numUV);
            }
            parts = tokens[2].split("/");
            facesVerts[++faceIndex] = ObjLoader.getIndex(parts[0], numVertices);
            if (parts.length > 2) {
                facesNormals[faceIndex] = ObjLoader.getIndex(parts[2], numNormals);
            }
            if (parts.length > 1) {
                facesUV[faceIndex] = ObjLoader.getIndex(parts[1], numUV);
            }
            parts = tokens[3].split("/");
            facesVerts[++faceIndex] = ObjLoader.getIndex(parts[0], numVertices);
            if (parts.length > 2) {
                facesNormals[faceIndex] = ObjLoader.getIndex(parts[2], numNormals);
            }
            if (parts.length > 1) {
                facesUV[faceIndex] = ObjLoader.getIndex(parts[1], numUV);
            }
            ++faceIndex;
            ++numFaces;
        }
        float[] verts = new float[numFaces * 3 * (3 + (numNormals > 0 ? 3 : 0) + (numUV > 0 ? 2 : 0))];
        int vi = 0;
        for (int i = 0; i < numFaces * 3; ++i) {
            int vertexIdx = facesVerts[i] * 3;
            verts[vi++] = vertices[vertexIdx];
            verts[vi++] = vertices[vertexIdx + 1];
            verts[vi++] = vertices[vertexIdx + 2];
            if (numNormals > 0) {
                int normalIdx = facesNormals[i] * 3;
                verts[vi++] = normals[normalIdx];
                verts[vi++] = normals[normalIdx + 1];
                verts[vi++] = normals[normalIdx + 2];
            }
            if (numUV <= 0) continue;
            int uvIdx = facesUV[i] * 2;
            verts[vi++] = uv[uvIdx];
            verts[vi++] = uv[uvIdx + 1];
        }
        Mesh mesh = null;
        ArrayList<VertexAttribute> attributes = new ArrayList<VertexAttribute>();
        attributes.add(new VertexAttribute(0, 3, "a_position"));
        if (numNormals > 0) {
            attributes.add(new VertexAttribute(2, 3, "a_normal"));
        }
        if (numUV > 0) {
            attributes.add(new VertexAttribute(3, 2, "a_texCoord0"));
        }
        mesh = new Mesh(true, numFaces * 3, 0, attributes.toArray(new VertexAttribute[attributes.size()]));
        mesh.setVertices(verts);
        return mesh;
    }

    private static int getIndex(String index, int size) {
        if (index == null || index.length() == 0) {
            return 0;
        }
        int idx = Integer.parseInt(index);
        if (idx < 0) {
            return size + idx;
        }
        return idx - 1;
    }
}

