/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.loaders.md5;

import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.loaders.md5.MD5Joints;
import com.badlogic.gdx.graphics.g3d.loaders.md5.MD5Mesh;
import com.badlogic.gdx.graphics.g3d.loaders.md5.MD5Model;
import com.badlogic.gdx.math.collision.BoundingBox;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class MD5Renderer
implements Disposable {
    private final MD5Model model;
    private final Mesh mesh;
    private final short[][] indices;
    private final float[][] vertices;
    private boolean useJni;
    private boolean useNormals;
    private BoundingBox mBBox = new BoundingBox();

    public BoundingBox getBBox() {
        return this.mBBox;
    }

    public float[] getVertices(int idx) {
        return this.vertices[idx];
    }

    public short[] getIndices(int idx) {
        return this.indices[idx];
    }

    public Mesh getMesh() {
        return this.mesh;
    }

    public MD5Renderer(MD5Model model, boolean useNormals, boolean useJni) {
        if (useJni && useNormals) {
            throw new GdxRuntimeException("JNI with normals is currently unsupported.");
        }
        int maxVertices = 0;
        int maxIndices = 0;
        int stride = useNormals ? 8 : 5;
        this.model = model;
        this.useJni = useJni;
        this.useNormals = useNormals;
        this.indices = new short[model.meshes.length][];
        this.vertices = new float[model.meshes.length][];
        for (int i = 0; i < model.meshes.length; ++i) {
            if (maxVertices < model.meshes[i].numVertices) {
                maxVertices = model.meshes[i].numVertices;
            }
            if (maxIndices < model.meshes[i].numTriangles * 3) {
                maxIndices = model.meshes[i].numTriangles * 3;
            }
            this.indices[i] = model.meshes[i].getIndices();
            this.vertices[i] = model.meshes[i].createVertexArray(stride);
        }
        this.mesh = useNormals ? new Mesh(false, maxVertices, maxIndices, new VertexAttribute(0, 3, "a_position"), new VertexAttribute(3, 2, "a_texCoord0"), new VertexAttribute(2, 3, "a_normal")) : new Mesh(false, maxVertices, maxIndices, new VertexAttribute(0, 3, "a_position"), new VertexAttribute(3, 2, "a_texCoord0"));
    }

    public void setSkeleton(MD5Joints skeleton) {
        this.mBBox.clr();
        for (int i = 0; i < this.model.meshes.length; ++i) {
            MD5Mesh mesh = this.model.meshes[i];
            if (this.useJni) {
                mesh.calculateVerticesJni(skeleton, this.vertices[i]);
                continue;
            }
            if (this.useNormals) {
                mesh.calculateVerticesN(skeleton, this.vertices[i], this.mBBox);
                continue;
            }
            mesh.calculateVertices(skeleton, this.vertices[i], this.mBBox);
        }
    }

    public void setUseJni(boolean useJni) {
        this.useJni = useJni;
    }

    public void calculateNormals(MD5Joints bindPoseSkeleton) {
        for (int i = 0; i < this.model.meshes.length; ++i) {
            MD5Mesh mesh = this.model.meshes[i];
            mesh.calculateNormalsBind(bindPoseSkeleton, this.vertices[i]);
        }
    }

    public void render() {
        for (int i = 0; i < this.model.meshes.length; ++i) {
            this.mesh.setIndices(this.indices[i]);
            this.mesh.setVertices(this.vertices[i]);
            this.mesh.render(4, 0, this.indices[i].length);
        }
    }

    public void render(Material[] materials) {
        for (int i = 0; i < this.model.meshes.length; ++i) {
            if (materials[i] != null) {
                if (materials[i].Texture != null) {
                    materials[i].Texture.bind();
                }
                materials[i].set(1028);
            }
            this.mesh.setIndices(this.indices[i]);
            this.mesh.setVertices(this.vertices[i]);
            this.mesh.render(4, 0, this.indices[i].length);
        }
    }

    @Override
    public void dispose() {
        this.mesh.dispose();
    }

    public boolean isJniUsed() {
        return this.useJni;
    }
}

